/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.SolverManagerConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.quarkus.config.OptaPlannerRuntimeConfig;
import org.optaplanner.quarkus.gizmo.OptaPlannerDroolsInitializer;

@Recorder
public class OptaPlannerRecorder {
    public Supplier<SolverConfig> solverConfigSupplier(final SolverConfig solverConfig, final Map<String, RuntimeValue<MemberAccessor>> generatedGizmoMemberAccessorMap, final Map<String, RuntimeValue<SolutionCloner>> generatedGizmoSolutionClonerMap, final RuntimeValue<OptaPlannerDroolsInitializer> droolsInitializer) {
        return new Supplier<SolverConfig>(){

            @Override
            public SolverConfig get() {
                OptaPlannerRuntimeConfig optaPlannerRuntimeConfig = (OptaPlannerRuntimeConfig)Arc.container().instance(OptaPlannerRuntimeConfig.class, new Annotation[0]).get();
                OptaPlannerRecorder.this.updateSolverConfigWithRuntimeProperties(solverConfig, optaPlannerRuntimeConfig);
                HashMap memberAccessorMap = new HashMap();
                HashMap solutionClonerMap = new HashMap();
                generatedGizmoMemberAccessorMap.forEach((className, runtimeValue) -> memberAccessorMap.put(className, (MemberAccessor)runtimeValue.getValue()));
                generatedGizmoSolutionClonerMap.forEach((className, runtimeValue) -> solutionClonerMap.put(className, (SolutionCloner)runtimeValue.getValue()));
                solverConfig.setGizmoMemberAccessorMap(memberAccessorMap);
                solverConfig.setGizmoSolutionClonerMap(solutionClonerMap);
                ((OptaPlannerDroolsInitializer)droolsInitializer.getValue()).setup(solverConfig.getScoreDirectorFactoryConfig());
                return solverConfig;
            }
        };
    }

    public Supplier<SolverManagerConfig> solverManagerConfig(final SolverManagerConfig solverManagerConfig) {
        return new Supplier<SolverManagerConfig>(){

            @Override
            public SolverManagerConfig get() {
                OptaPlannerRuntimeConfig optaPlannerRuntimeConfig = (OptaPlannerRuntimeConfig)Arc.container().instance(OptaPlannerRuntimeConfig.class, new Annotation[0]).get();
                OptaPlannerRecorder.this.updateSolverManagerConfigWithRuntimeProperties(solverManagerConfig, optaPlannerRuntimeConfig);
                return solverManagerConfig;
            }
        };
    }

    private void updateSolverConfigWithRuntimeProperties(SolverConfig solverConfig, OptaPlannerRuntimeConfig optaPlannerRunTimeConfig) {
        TerminationConfig terminationConfig = solverConfig.getTerminationConfig();
        if (terminationConfig == null) {
            terminationConfig = new TerminationConfig();
            solverConfig.setTerminationConfig(terminationConfig);
        }
        optaPlannerRunTimeConfig.solver.termination.spentLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setSpentLimit(arg_0));
        optaPlannerRunTimeConfig.solver.termination.unimprovedSpentLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setUnimprovedSpentLimit(arg_0));
        optaPlannerRunTimeConfig.solver.termination.bestScoreLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setBestScoreLimit(arg_0));
        optaPlannerRunTimeConfig.solver.moveThreadCount.ifPresent(arg_0 -> ((SolverConfig)solverConfig).setMoveThreadCount(arg_0));
    }

    private void updateSolverManagerConfigWithRuntimeProperties(SolverManagerConfig solverManagerConfig, OptaPlannerRuntimeConfig optaPlannerRunTimeConfig) {
        optaPlannerRunTimeConfig.solverManager.parallelSolverCount.ifPresent(arg_0 -> ((SolverManagerConfig)solverManagerConfig).setParallelSolverCount(arg_0));
    }
}

