/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.employee;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.common.HighContrastColor;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.skill.Skill;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"tenantId", "name"})})
public class Employee
extends AbstractPersistable
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    @NotNull
    @Size(min=1, max=120)
    @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces")
    private @NotNull @Size(min=1, max=120) @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces") String name;
    @NotNull
    @Size(min=1, max=3)
    @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces")
    private @NotNull @Size(min=1, max=3) @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces") String shortId;
    @NotNull
    @Size(min=7, max=7)
    @Pattern(regexp="^#[0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f]$")
    private @NotNull @Size(min=7, max=7) @Pattern(regexp="^#[0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f]$") String color;
    @NotNull
    @ManyToOne
    private Contract contract;
    @NotNull
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="EmployeeSkillProficiencySet", joinColumns={@JoinColumn(name="employeeId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="skillId", referencedColumnName="id")})
    private Set<Skill> skillProficiencySet;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public Employee() {
    }

    public Employee(Integer tenantId, String name, Contract contract, Set<Skill> skillProficiencySet) {
        super(tenantId);
        this.$$_hibernate_write_name(name);
        this.$$_hibernate_write_shortId(Employee.generateShortIdFromName(name));
        this.$$_hibernate_write_color(HighContrastColor.generateColorFromHashcode((Object)name));
        this.$$_hibernate_write_contract(contract);
        this.$$_hibernate_write_skillProficiencySet(skillProficiencySet);
    }

    public Employee(Integer tenantId, String name, Contract contract, Set<Skill> skillProficiencySet, String shortId, String color) {
        super(tenantId);
        this.$$_hibernate_write_name(name);
        this.$$_hibernate_write_shortId(shortId);
        this.$$_hibernate_write_color(color);
        this.$$_hibernate_write_contract(contract);
        this.$$_hibernate_write_skillProficiencySet(skillProficiencySet);
    }

    @Override
    public String toString() {
        return this.$$_hibernate_read_name();
    }

    public static String generateShortIdFromName(String name) {
        return Arrays.stream(name.split(" ")).limit(3L).map(s -> s.substring(0, 1)).collect(Collectors.joining(""));
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_write_name(name);
    }

    public Set<Skill> getSkillProficiencySet() {
        return this.$$_hibernate_read_skillProficiencySet();
    }

    public void setSkillProficiencySet(Set<Skill> skillProficiencySet) {
        this.$$_hibernate_write_skillProficiencySet(skillProficiencySet);
    }

    public Contract getContract() {
        return this.$$_hibernate_read_contract();
    }

    public void setContract(Contract contract) {
        this.$$_hibernate_write_contract(contract);
    }

    public String getShortId() {
        return this.$$_hibernate_read_shortId();
    }

    public void setShortId(String shortId) {
        this.$$_hibernate_write_shortId(shortId);
    }

    public String getColor() {
        return this.$$_hibernate_read_color();
    }

    public void setColor(String color) {
        this.$$_hibernate_write_color(color);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Employee) {
            Employee other = (Employee)o;
            return this.$$_hibernate_read_name().equals(other.getName()) && this.$$_hibernate_read_contract().equals(other.getContract()) && this.$$_hibernate_read_skillProficiencySet().equals(other.getSkillProficiencySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.$$_hibernate_read_name(), this.$$_hibernate_read_contract(), this.$$_hibernate_read_skillProficiencySet());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        Employee employee = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        boolean bl;
        block0: {
            int n;
            block1: {
                Employee employee = this;
                bl = false;
                if (bl || this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("skillProficiencySet");
                if (this.skillProficiencySet != null || n == -1) break block1;
                bl = true;
                break block0;
            }
            if (this.skillProficiencySet == null || this.skillProficiencySet instanceof PersistentCollection && !((PersistentCollection)this.skillProficiencySet).wasInitialized() || n == this.skillProficiencySet.size()) break block0;
            bl = true;
        }
        return bl;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block0: {
            int n;
            block1: {
                Employee employee = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                if (this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("skillProficiencySet");
                if (this.skillProficiencySet != null || n == -1) break block1;
                dirtyTracker.add("skillProficiencySet");
                break block0;
            }
            if (this.skillProficiencySet == null || this.skillProficiencySet instanceof PersistentCollection && !((PersistentCollection)this.skillProficiencySet).wasInitialized() || n == this.skillProficiencySet.size()) break block0;
            dirtyTracker.add("skillProficiencySet");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block3: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            Employee employee = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("skillProficiencySet")) break block3;
            if (this.skillProficiencySet == null || this.skillProficiencySet instanceof PersistentCollection && !((PersistentCollection)this.skillProficiencySet).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("skillProficiencySet", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("skillProficiencySet", this.skillProficiencySet.size());
            }
        }
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!Objects.deepEquals(string, this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_shortId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.shortId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "shortId", (Object)this.shortId);
        }
        return this.shortId;
    }

    public void $$_hibernate_write_shortId(String string) {
        if (!Objects.deepEquals(string, this.shortId)) {
            this.$$_hibernate_trackChange("shortId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.shortId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "shortId", (Object)this.shortId, (Object)string);
            return;
        }
        this.shortId = string;
    }

    public String $$_hibernate_read_color() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.color = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "color", (Object)this.color);
        }
        return this.color;
    }

    public void $$_hibernate_write_color(String string) {
        if (!Objects.deepEquals(string, this.color)) {
            this.$$_hibernate_trackChange("color");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.color = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "color", (Object)this.color, (Object)string);
            return;
        }
        this.color = string;
    }

    public Contract $$_hibernate_read_contract() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.contract = (Contract)this.$$_hibernate_getInterceptor().readObject((Object)this, "contract", (Object)this.contract);
        }
        return this.contract;
    }

    public void $$_hibernate_write_contract(Contract contract) {
        if (!Objects.deepEquals(contract, this.contract)) {
            this.$$_hibernate_trackChange("contract");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.contract = (Contract)this.$$_hibernate_getInterceptor().writeObject((Object)this, "contract", (Object)this.contract, (Object)contract);
            return;
        }
        this.contract = contract;
    }

    public Set $$_hibernate_read_skillProficiencySet() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.skillProficiencySet = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "skillProficiencySet", this.skillProficiencySet);
        }
        return this.skillProficiencySet;
    }

    public void $$_hibernate_write_skillProficiencySet(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.skillProficiencySet = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "skillProficiencySet", this.skillProficiencySet, (Object)set);
            return;
        }
        this.skillProficiencySet = set;
    }

    @Override
    public Long $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_id((Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)super.$$_hibernate_read_id()));
        }
        return super.$$_hibernate_read_id();
    }

    @Override
    public void $$_hibernate_write_id(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_id((Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)super.$$_hibernate_read_id(), (Object)l));
            return;
        }
        super.$$_hibernate_write_id(l);
    }

    @Override
    public Integer $$_hibernate_read_tenantId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_tenantId((Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "tenantId", (Object)super.$$_hibernate_read_tenantId()));
        }
        return super.$$_hibernate_read_tenantId();
    }

    @Override
    public void $$_hibernate_write_tenantId(Integer n) {
        if (!Objects.deepEquals(n, ((AbstractPersistable)this).$$_hibernate_read_tenantId())) {
            this.$$_hibernate_trackChange("tenantId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_tenantId((Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "tenantId", (Object)super.$$_hibernate_read_tenantId(), (Object)n));
            return;
        }
        super.$$_hibernate_write_tenantId(n);
    }

    @Override
    public Long $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_version((Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "version", (Object)super.$$_hibernate_read_version()));
        }
        return super.$$_hibernate_read_version();
    }

    @Override
    public void $$_hibernate_write_version(Long l) {
        if (!Objects.deepEquals(l, ((AbstractPersistable)this).$$_hibernate_read_version())) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_version((Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "version", (Object)super.$$_hibernate_read_version(), (Object)l));
            return;
        }
        super.$$_hibernate_write_version(l);
    }
}

