/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.tenant;

import java.time.ZoneId;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.optaweb.employeerostering.domain.roster.view.RosterStateView;
import org.optaweb.employeerostering.domain.tenant.RosterConstraintConfiguration;
import org.optaweb.employeerostering.domain.tenant.Tenant;
import org.optaweb.employeerostering.domain.tenant.view.RosterConstraintConfigurationView;
import org.optaweb.employeerostering.service.tenant.TenantService;

@Path(value="/rest/tenant")
@ApplicationScoped
@Tag(name="Tenant")
public class TenantController {
    private final TenantService tenantService;

    public TenantController() {
    }

    @Inject
    public TenantController(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @GET
    @Path(value="/")
    @Operation(summary="List Tenants", description="Get a list of all tenants")
    public List<Tenant> getTenantList() {
        return this.tenantService.getTenantList();
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get Tenant", description="Gets a tenant by id")
    public Tenant getTenant(@PathParam(value="id") @Min(value=0L) @Min(value=0L) Integer id) {
        return this.tenantService.getTenant(id);
    }

    @POST
    @Path(value="/add")
    @Operation(summary="Add Tenant", description="Adds a new tenant")
    public Tenant createTenant(@Valid RosterStateView initialRosterStateView) {
        return this.tenantService.createTenant(initialRosterStateView);
    }

    @POST
    @Path(value="/remove/{id}")
    @Operation(summary="Delete Tenant", description="Deletes a tenant by id")
    public Boolean deleteTenant(@PathParam(value="id") @Min(value=0L) @Min(value=0L) Integer id) {
        return this.tenantService.deleteTenant(id);
    }

    @GET
    @Path(value="/{tenantId}/config/constraint")
    @Operation(summary="Get Roster Parametrization", description="Gets a tenant roster parametrization")
    public RosterConstraintConfiguration getRosterConstraintConfiguration(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return this.tenantService.getRosterConstraintConfiguration(tenantId);
    }

    @POST
    @Path(value="/{tenantId}/config/constraint/update")
    @Operation(summary="Update Roster Parametrization", description="Updates a tenant roster parametrization")
    public RosterConstraintConfiguration updateRosterConstraintConfiguration(@Valid RosterConstraintConfigurationView rosterConstraintConfigurationView) {
        return this.tenantService.updateRosterConstraintConfiguration(rosterConstraintConfigurationView);
    }

    @GET
    @Path(value="/supported/timezones")
    @Operation(summary="Supported Timezones", description="Get supported timezones")
    public List<ZoneId> getSupportedTimezones() {
        return this.tenantService.getSupportedTimezones();
    }
}

