/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.holder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScoreHolder;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;

public final class BendableBigDecimalScoreHolderImpl
extends AbstractScoreHolder<BendableBigDecimalScore>
implements BendableBigDecimalScoreHolder {
    protected final Map<Rule, AbstractScoreHolder.BigDecimalMatchExecutor> matchExecutorByNumberMap = new LinkedHashMap<Rule, AbstractScoreHolder.BigDecimalMatchExecutor>();
    protected final Map<Rule, AbstractScoreHolder.ScoreMatchExecutor<BendableBigDecimalScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, AbstractScoreHolder.ScoreMatchExecutor<BendableBigDecimalScore>>();
    private BigDecimal[] hardScores;
    private BigDecimal[] softScores;

    public BendableBigDecimalScoreHolderImpl(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled);
        this.hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(this.hardScores, BigDecimal.ZERO);
        this.softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(this.softScores, BigDecimal.ZERO);
    }

    @Override
    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public BigDecimal getHardScore(int hardLevel) {
        return this.hardScores[hardLevel];
    }

    @Override
    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public BigDecimal getSoftScore(int softLevel) {
        return this.softScores[softLevel];
    }

    @Override
    public void configureConstraintWeight(Rule rule, BendableBigDecimalScore constraintWeight) {
        AbstractScoreHolder.BigDecimalMatchExecutor matchExecutor;
        super.configureConstraintWeight(rule, constraintWeight);
        if (constraintWeight.equals(BendableBigDecimalScore.zero(this.hardScores.length, this.softScores.length))) {
            matchExecutor = (kcontext, matchWeight) -> {};
        } else {
            Integer singleLevel = null;
            BigDecimal singleLevelWeight = null;
            for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
                BigDecimal levelWeight = constraintWeight.getHardOrSoftScore(i);
                if (levelWeight.equals(BigDecimal.ZERO)) continue;
                if (singleLevel != null) {
                    singleLevel = null;
                    singleLevelWeight = null;
                    break;
                }
                singleLevel = i;
                singleLevelWeight = levelWeight;
            }
            if (singleLevel != null) {
                BigDecimal levelWeight = singleLevelWeight;
                if (singleLevel < constraintWeight.getHardLevelsSize()) {
                    int level = singleLevel;
                    matchExecutor = (kcontext, matchWeight) -> this.addHardConstraintMatch(kcontext, level, levelWeight.multiply(matchWeight));
                } else {
                    int level = singleLevel - constraintWeight.getHardLevelsSize();
                    matchExecutor = (kcontext, matchWeight) -> this.addSoftConstraintMatch(kcontext, level, levelWeight.multiply(matchWeight));
                }
            } else {
                matchExecutor = (kcontext, matchWeight) -> {
                    int i;
                    BigDecimal[] hardWeights = new BigDecimal[this.hardScores.length];
                    BigDecimal[] softWeights = new BigDecimal[this.softScores.length];
                    for (i = 0; i < hardWeights.length; ++i) {
                        hardWeights[i] = constraintWeight.getHardScore(i).multiply(matchWeight);
                    }
                    for (i = 0; i < softWeights.length; ++i) {
                        softWeights[i] = constraintWeight.getSoftScore(i).multiply(matchWeight);
                    }
                    this.addMultiConstraintMatch(kcontext, hardWeights, softWeights);
                };
            }
        }
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> {
            int i;
            BigDecimal[] hardWeights = new BigDecimal[this.hardScores.length];
            BigDecimal[] softWeights = new BigDecimal[this.softScores.length];
            for (i = 0; i < hardWeights.length; ++i) {
                hardWeights[i] = constraintWeight.getHardScore(i).multiply(weightMultiplier.getHardScore(i));
            }
            for (i = 0; i < softWeights.length; ++i) {
                softWeights[i] = constraintWeight.getSoftScore(i).multiply(weightMultiplier.getSoftScore(i));
            }
            this.addMultiConstraintMatch(kcontext, hardWeights, softWeights);
        });
    }

    @Override
    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, BigDecimal.ONE.negate());
    }

    @Override
    public void penalize(RuleContext kcontext, BigDecimal weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier.negate());
    }

    @Override
    public void penalize(RuleContext kcontext, BigDecimal[] hardWeightsMultiplier, BigDecimal[] softWeightsMultiplier) {
        int i;
        BigDecimal[] negatedHardWeightsMultiplier = new BigDecimal[this.hardScores.length];
        BigDecimal[] negatedSoftWeightsMultiplier = new BigDecimal[this.softScores.length];
        for (i = 0; i < negatedHardWeightsMultiplier.length; ++i) {
            negatedHardWeightsMultiplier[i] = hardWeightsMultiplier[i].negate();
        }
        for (i = 0; i < negatedSoftWeightsMultiplier.length; ++i) {
            negatedSoftWeightsMultiplier[i] = softWeightsMultiplier[i].negate();
        }
        this.impactScore(kcontext, negatedHardWeightsMultiplier, negatedSoftWeightsMultiplier);
    }

    @Override
    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, BigDecimal.ONE);
    }

    @Override
    public void reward(RuleContext kcontext, BigDecimal weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    @Override
    public void reward(RuleContext kcontext, BigDecimal[] hardWeightsMultiplier, BigDecimal[] softWeightsMultiplier) {
        this.impactScore(kcontext, hardWeightsMultiplier, softWeightsMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext) {
        this.impactScore(kcontext, BigDecimal.ONE);
    }

    @Override
    public void impactScore(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, BigDecimal.valueOf(weightMultiplier));
    }

    @Override
    public void impactScore(RuleContext kcontext, long weightMultiplier) {
        this.impactScore(kcontext, BigDecimal.valueOf(weightMultiplier));
    }

    @Override
    public void impactScore(RuleContext kcontext, BigDecimal weightMultiplier) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.BigDecimalMatchExecutor matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    private void impactScore(RuleContext kcontext, BigDecimal[] hardWeightsMultiplier, BigDecimal[] softWeightsMultiplier) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.ScoreMatchExecutor<BendableBigDecimalScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, BendableBigDecimalScore.of(hardWeightsMultiplier, softWeightsMultiplier));
    }

    @Override
    public void addHardConstraintMatch(RuleContext kcontext, int hardLevel, BigDecimal weight) {
        if (hardLevel >= this.hardScores.length) {
            throw new IllegalArgumentException("The hardLevel (" + hardLevel + ") isn't lower than the hardScores length (" + this.hardScores.length + ") defined by the @" + PlanningScore.class.getSimpleName() + " on the planning solution class.");
        }
        this.hardScores[hardLevel] = this.hardScores[hardLevel].add(weight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScores[hardLevel] = this.hardScores[hardLevel].subtract(weight);
        }, () -> {
            Object[] newHardScores = new BigDecimal[this.hardScores.length];
            Arrays.fill(newHardScores, BigDecimal.ZERO);
            Object[] newSoftScores = new BigDecimal[this.softScores.length];
            Arrays.fill(newSoftScores, BigDecimal.ZERO);
            newHardScores[hardLevel] = weight;
            return BendableBigDecimalScore.of((BigDecimal[])newHardScores, (BigDecimal[])newSoftScores);
        });
    }

    @Override
    public void addSoftConstraintMatch(RuleContext kcontext, int softLevel, BigDecimal weight) {
        if (softLevel >= this.softScores.length) {
            throw new IllegalArgumentException("The softLevel (" + softLevel + ") isn't lower than the softScores length (" + this.softScores.length + ") defined by the @" + PlanningScore.class.getSimpleName() + " on the planning solution class.");
        }
        this.softScores[softLevel] = this.softScores[softLevel].add(weight);
        this.registerConstraintMatch(kcontext, () -> {
            this.softScores[softLevel] = this.softScores[softLevel].subtract(weight);
        }, () -> {
            Object[] newHardScores = new BigDecimal[this.hardScores.length];
            Arrays.fill(newHardScores, BigDecimal.ZERO);
            Object[] newSoftScores = new BigDecimal[this.softScores.length];
            Arrays.fill(newSoftScores, BigDecimal.ZERO);
            newSoftScores[softLevel] = weight;
            return BendableBigDecimalScore.of((BigDecimal[])newHardScores, (BigDecimal[])newSoftScores);
        });
    }

    @Override
    public void addMultiConstraintMatch(RuleContext kcontext, BigDecimal[] hardWeights, BigDecimal[] softWeights) {
        int i;
        if (hardWeights.length != this.hardScores.length) {
            throw new IllegalArgumentException("The hardWeights length (" + hardWeights.length + ") is different than the hardScores length (" + this.hardScores.length + ") defined by the @" + PlanningScore.class.getSimpleName() + " on the planning solution class.");
        }
        for (i = 0; i < this.hardScores.length; ++i) {
            this.hardScores[i] = this.hardScores[i].add(hardWeights[i]);
        }
        if (softWeights.length != this.softScores.length) {
            throw new IllegalArgumentException("The softWeights length (" + softWeights.length + ") is different than the softScores length (" + this.softScores.length + ") defined by the @" + PlanningScore.class.getSimpleName() + " on the planning solution class.");
        }
        for (i = 0; i < this.softScores.length; ++i) {
            this.softScores[i] = this.softScores[i].add(softWeights[i]);
        }
        this.registerConstraintMatch(kcontext, () -> {
            int i;
            for (i = 0; i < this.hardScores.length; ++i) {
                this.hardScores[i] = this.hardScores[i].subtract(hardWeights[i]);
            }
            for (i = 0; i < this.softScores.length; ++i) {
                this.softScores[i] = this.softScores[i].subtract(softWeights[i]);
            }
        }, () -> BendableBigDecimalScore.of(hardWeights, softWeights));
    }

    @Override
    public BendableBigDecimalScore extractScore(int initScore) {
        return BendableBigDecimalScore.ofUninitialized(initScore, Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }
}

