/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.common.inliner;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.stream.common.inliner.WeightedScoreImpacter;

final class SimpleBigDecimalScoreInliner
extends AbstractScoreInliner<SimpleBigDecimalScore> {
    private BigDecimal score = BigDecimal.ZERO;

    SimpleBigDecimalScoreInliner(Map<Constraint, SimpleBigDecimalScore> constraintToWeightMap, boolean constraintMatchEnabled) {
        super(constraintToWeightMap, constraintMatchEnabled);
    }

    @Override
    public WeightedScoreImpacter buildWeightedScoreImpacter(Constraint constraint) {
        SimpleBigDecimalScore constraintWeight = (SimpleBigDecimalScore)this.getConstraintWeight(constraint);
        BigDecimal simpleConstraintWeight = constraintWeight.getScore();
        return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
            BigDecimal impact = simpleConstraintWeight.multiply(matchWeight);
            this.score = this.score.add(impact);
            UndoScoreImpacter undoScoreImpact = () -> {
                this.score = this.score.subtract(impact);
            };
            if (!this.constraintMatchEnabled) {
                return undoScoreImpact;
            }
            Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, SimpleBigDecimalScore.of(impact), (List)justificationsSupplier.get());
            return () -> {
                undoScoreImpact.run();
                undoConstraintMatch.run();
            };
        });
    }

    @Override
    public SimpleBigDecimalScore extractScore(int initScore) {
        return SimpleBigDecimalScore.ofUninitialized(initScore, this.score);
    }

    public String toString() {
        return SimpleBigDecimalScore.class.getSimpleName() + " inliner";
    }
}

