/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.model.BetaIndex;
import org.drools.model.BetaIndex2;
import org.drools.model.BetaIndex3;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Predicate2;
import org.drools.model.functions.Predicate3;
import org.drools.model.functions.Predicate4;
import org.drools.model.view.ViewItem;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.PatternVariable;
import org.optaplanner.core.impl.score.stream.quad.AbstractQuadJoiner;
import org.optaplanner.core.impl.score.stream.tri.AbstractTriJoiner;

class DirectPatternVariable<A>
implements PatternVariable<A, A, DirectPatternVariable<A>> {
    private final Variable<A> primaryVariable;
    private final Supplier<PatternDSL.PatternDef<A>> patternSupplier;
    private final List<ViewItem<?>> prerequisiteExpressions;
    private final List<ViewItem<?>> dependentExpressions;

    DirectPatternVariable(Variable<A> aVariable) {
        this(aVariable, Collections.emptyList());
    }

    DirectPatternVariable(Variable<A> aVariable, ViewItem<?> prerequisiteExpression) {
        this(aVariable, Collections.singletonList(prerequisiteExpression));
    }

    DirectPatternVariable(Variable<A> aVariable, List<ViewItem<?>> prerequisiteExpressions) {
        this.primaryVariable = aVariable;
        this.patternSupplier = () -> PatternDSL.pattern((Variable)aVariable);
        this.prerequisiteExpressions = prerequisiteExpressions;
        this.dependentExpressions = Collections.emptyList();
    }

    private DirectPatternVariable(DirectPatternVariable<A> patternCreator, UnaryOperator<PatternDSL.PatternDef<A>> patternMutator) {
        this.primaryVariable = patternCreator.primaryVariable;
        this.patternSupplier = () -> (PatternDSL.PatternDef)patternMutator.apply(patternCreator.patternSupplier.get());
        this.prerequisiteExpressions = patternCreator.prerequisiteExpressions;
        this.dependentExpressions = patternCreator.dependentExpressions;
    }

    private DirectPatternVariable(DirectPatternVariable<A> patternCreator, ViewItem<?> dependentExpression) {
        this.primaryVariable = patternCreator.primaryVariable;
        this.patternSupplier = patternCreator.patternSupplier;
        this.prerequisiteExpressions = patternCreator.prerequisiteExpressions;
        this.dependentExpressions = Stream.concat(patternCreator.dependentExpressions.stream(), Stream.of(dependentExpression)).collect(Collectors.toList());
    }

    @Override
    public Variable<A> getPrimaryVariable() {
        return this.primaryVariable;
    }

    public Supplier<PatternDSL.PatternDef<A>> getPatternSupplier() {
        return this.patternSupplier;
    }

    @Override
    public List<ViewItem<?>> getPrerequisiteExpressions() {
        return this.prerequisiteExpressions;
    }

    @Override
    public List<ViewItem<?>> getDependentExpressions() {
        return this.dependentExpressions;
    }

    @Override
    public DirectPatternVariable<A> filter(Predicate<A> predicate) {
        return new DirectPatternVariable<A>(this, p -> p.expr("Filter using " + predicate, predicate::test));
    }

    @Override
    public <LeftJoinVar_> DirectPatternVariable<A> filter(BiPredicate<LeftJoinVar_, A> predicate, Variable<LeftJoinVar_> leftJoinVariable) {
        return new DirectPatternVariable<A>(this, p -> p.expr("Filter using " + predicate, leftJoinVariable, (Predicate2 & Serializable)(a, leftJoinVar) -> predicate.test(leftJoinVar, a)));
    }

    @Override
    public <LeftJoinVarA_, LeftJoinVarB_> DirectPatternVariable<A> filter(TriPredicate<LeftJoinVarA_, LeftJoinVarB_, A> predicate, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB) {
        return new DirectPatternVariable<A>(this, p -> p.expr("Filter using " + predicate, leftJoinVariableA, leftJoinVariableB, (Predicate3 & Serializable)(a, leftJoinVarA, leftJoinVarB) -> predicate.test(leftJoinVarA, leftJoinVarB, a)));
    }

    @Override
    public <LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> DirectPatternVariable<A> filter(QuadPredicate<LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, A> predicate, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, Variable<LeftJoinVarC_> leftJoinVariableC) {
        return new DirectPatternVariable<A>(this, p -> p.expr("Filter using " + predicate, leftJoinVariableA, leftJoinVariableB, leftJoinVariableC, (Predicate4 & Serializable)(a, leftJoinVarA, leftJoinVarB, leftJoinVarC) -> predicate.test(leftJoinVarA, leftJoinVarB, leftJoinVarC, a)));
    }

    @Override
    public <LeftJoinVar_> PatternVariable<A, A, DirectPatternVariable<A>> filterForJoin(Variable<LeftJoinVar_> leftJoinVar, AbstractBiJoiner<LeftJoinVar_, A> joiner, JoinerType joinerType, int mappingIndex) {
        Function leftMapping = joiner.getLeftMapping(mappingIndex);
        Function rightMapping = joiner.getRightMapping(mappingIndex);
        Predicate2 & Serializable predicate = (Predicate2 & Serializable)(b, a) -> joinerType.matches(leftMapping.apply(a), rightMapping.apply(b));
        return new DirectPatternVariable<A>(this, p -> {
            BetaIndex index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply);
            return p.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVar, predicate, index);
        });
    }

    @Override
    public <LeftJoinVarA_, LeftJoinVarB_> PatternVariable<A, A, DirectPatternVariable<A>> filterForJoin(Variable<LeftJoinVarA_> leftJoinVarA, Variable<LeftJoinVarB_> leftJoinVarB, AbstractTriJoiner<LeftJoinVarA_, LeftJoinVarB_, A> joiner, JoinerType joinerType, int mappingIndex) {
        BiFunction leftMapping = joiner.getLeftMapping(mappingIndex);
        Function rightMapping = joiner.getRightMapping(mappingIndex);
        Predicate3 & Serializable predicate = (Predicate3 & Serializable)(c, a, b) -> joinerType.matches(leftMapping.apply(a, b), rightMapping.apply(c));
        return new DirectPatternVariable<A>(this, p -> {
            BetaIndex2 index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply, Object.class);
            return p.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVarA, leftJoinVarB, predicate, index);
        });
    }

    @Override
    public <LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> PatternVariable<A, A, DirectPatternVariable<A>> filterForJoin(Variable<LeftJoinVarA_> leftJoinVarA, Variable<LeftJoinVarB_> leftJoinVarB, Variable<LeftJoinVarC_> leftJoinVarC, AbstractQuadJoiner<LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, A> joiner, JoinerType joinerType, int mappingIndex) {
        TriFunction leftMapping = joiner.getLeftMapping(mappingIndex);
        Function rightMapping = joiner.getRightMapping(mappingIndex);
        Predicate4 & Serializable predicate = (Predicate4 & Serializable)(d, a, b, c) -> joinerType.matches(leftMapping.apply(a, b, c), rightMapping.apply(d));
        return new DirectPatternVariable<A>(this, p -> {
            BetaIndex3 index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply, Object.class);
            return p.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVarA, leftJoinVarB, leftJoinVarC, predicate, index);
        });
    }

    @Override
    public <BoundVar_> DirectPatternVariable<A> bind(Variable<BoundVar_> boundVariable, Function<A, BoundVar_> bindingFunction) {
        return new DirectPatternVariable<A>(this, p -> p.bind(boundVariable, bindingFunction::apply));
    }

    @Override
    public <BoundVar_, LeftJoinVar_> DirectPatternVariable<A> bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVar_> leftJoinVariable, BiFunction<A, LeftJoinVar_, BoundVar_> bindingFunction) {
        return new DirectPatternVariable<A>(this, p -> p.bind(boundVariable, leftJoinVariable, bindingFunction::apply));
    }

    @Override
    public <BoundVar_, LeftJoinVarA_, LeftJoinVarB_> DirectPatternVariable<A> bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, TriFunction<A, LeftJoinVarA_, LeftJoinVarB_, BoundVar_> bindingFunction) {
        return new DirectPatternVariable<A>(this, p -> p.bind(boundVariable, leftJoinVariableA, leftJoinVariableB, bindingFunction::apply));
    }

    @Override
    public <BoundVar_, LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> DirectPatternVariable<A> bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, Variable<LeftJoinVarC_> leftJoinVariableC, QuadFunction<A, LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, BoundVar_> bindingFunction) {
        return new DirectPatternVariable<A>(this, p -> p.bind(boundVariable, leftJoinVariableA, leftJoinVariableB, leftJoinVariableC, bindingFunction::apply));
    }

    @Override
    public DirectPatternVariable<A> addDependentExpression(ViewItem<?> expression) {
        return new DirectPatternVariable<A>(this, expression);
    }

    @Override
    public List<ViewItem<?>> build() {
        Stream prerequisites = this.prerequisiteExpressions.stream();
        Stream dependents = this.dependentExpressions.stream();
        return Stream.concat(Stream.concat(prerequisites, Stream.of(this.patternSupplier.get())), dependents).collect(Collectors.toList());
    }
}

