/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.employee;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailabilityState;
import org.optaweb.employeerostering.domain.employee.view.EmployeeAvailabilityView;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"tenantId", "employee_id", "startDateTime", "endDateTime"})})
public class EmployeeAvailability
extends AbstractPersistable
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER)
    private Employee employee;
    @NotNull
    private OffsetDateTime startDateTime;
    @NotNull
    private OffsetDateTime endDateTime;
    @NotNull
    private EmployeeAvailabilityState state;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public EmployeeAvailability() {
    }

    public EmployeeAvailability(Integer tenantId, Employee employee, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        super(tenantId);
        this.$$_hibernate_write_employee(employee);
        this.$$_hibernate_write_startDateTime(startDateTime);
        this.$$_hibernate_write_endDateTime(endDateTime);
    }

    public EmployeeAvailability(ZoneId zoneId, EmployeeAvailabilityView employeeAvailabilityView, Employee employee) {
        super((AbstractPersistable)employeeAvailabilityView);
        this.$$_hibernate_write_employee(employee);
        this.$$_hibernate_write_startDateTime(OffsetDateTime.of(employeeAvailabilityView.getStartDateTime(), zoneId.getRules().getOffset(employeeAvailabilityView.getStartDateTime())));
        this.$$_hibernate_write_endDateTime(OffsetDateTime.of(employeeAvailabilityView.getEndDateTime(), zoneId.getRules().getOffset(employeeAvailabilityView.getEndDateTime())));
        this.$$_hibernate_write_state(employeeAvailabilityView.getState());
    }

    @AssertTrue
    @JsonIgnore
    public boolean isValid() {
        return this.getDuration().getSeconds() / 3600L < 28L;
    }

    @JsonIgnore
    public Duration getDuration() {
        return Duration.between(this.$$_hibernate_read_startDateTime(), this.$$_hibernate_read_endDateTime());
    }

    @Override
    public String toString() {
        return this.$$_hibernate_read_employee() + ":" + this.$$_hibernate_read_startDateTime() + "-" + this.$$_hibernate_read_endDateTime();
    }

    public Employee getEmployee() {
        return this.$$_hibernate_read_employee();
    }

    public void setEmployee(Employee employee) {
        this.$$_hibernate_write_employee(employee);
    }

    public OffsetDateTime getStartDateTime() {
        return this.$$_hibernate_read_startDateTime();
    }

    public void setStartDateTime(OffsetDateTime startDateTime) {
        this.$$_hibernate_write_startDateTime(startDateTime);
    }

    public OffsetDateTime getEndDateTime() {
        return this.$$_hibernate_read_endDateTime();
    }

    public void setEndDateTime(OffsetDateTime endDateTime) {
        this.$$_hibernate_write_endDateTime(endDateTime);
    }

    public EmployeeAvailabilityState getState() {
        return this.$$_hibernate_read_state();
    }

    public void setState(EmployeeAvailabilityState state) {
        this.$$_hibernate_write_state(state);
    }

    public EmployeeAvailability inTimeZone(ZoneId zoneId) {
        return new EmployeeAvailability(zoneId, new EmployeeAvailabilityView(zoneId, this), this.getEmployee());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        EmployeeAvailability employeeAvailability = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        EmployeeAvailability employeeAvailability = this;
        employeeAvailability = null;
        employeeAvailability = NoopCollectionTracker.INSTANCE;
        return employeeAvailability;
    }

    public Employee $$_hibernate_read_employee() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.employee = (Employee)this.$$_hibernate_getInterceptor().readObject((Object)this, "employee", (Object)this.employee);
        }
        return this.employee;
    }

    public void $$_hibernate_write_employee(Employee employee) {
        if (!Objects.deepEquals(employee, this.employee)) {
            this.$$_hibernate_trackChange("employee");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.employee = (Employee)this.$$_hibernate_getInterceptor().writeObject((Object)this, "employee", (Object)this.employee, (Object)employee);
            return;
        }
        this.employee = employee;
    }

    public OffsetDateTime $$_hibernate_read_startDateTime() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.startDateTime = (OffsetDateTime)this.$$_hibernate_getInterceptor().readObject((Object)this, "startDateTime", (Object)this.startDateTime);
        }
        return this.startDateTime;
    }

    public void $$_hibernate_write_startDateTime(OffsetDateTime offsetDateTime) {
        if (!Objects.deepEquals(offsetDateTime, this.startDateTime)) {
            this.$$_hibernate_trackChange("startDateTime");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.startDateTime = (OffsetDateTime)this.$$_hibernate_getInterceptor().writeObject((Object)this, "startDateTime", (Object)this.startDateTime, (Object)offsetDateTime);
            return;
        }
        this.startDateTime = offsetDateTime;
    }

    public OffsetDateTime $$_hibernate_read_endDateTime() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.endDateTime = (OffsetDateTime)this.$$_hibernate_getInterceptor().readObject((Object)this, "endDateTime", (Object)this.endDateTime);
        }
        return this.endDateTime;
    }

    public void $$_hibernate_write_endDateTime(OffsetDateTime offsetDateTime) {
        if (!Objects.deepEquals(offsetDateTime, this.endDateTime)) {
            this.$$_hibernate_trackChange("endDateTime");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.endDateTime = (OffsetDateTime)this.$$_hibernate_getInterceptor().writeObject((Object)this, "endDateTime", (Object)this.endDateTime, (Object)offsetDateTime);
            return;
        }
        this.endDateTime = offsetDateTime;
    }

    public EmployeeAvailabilityState $$_hibernate_read_state() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.state = (EmployeeAvailabilityState)this.$$_hibernate_getInterceptor().readObject((Object)this, "state", (Object)this.state);
        }
        return this.state;
    }

    public void $$_hibernate_write_state(EmployeeAvailabilityState employeeAvailabilityState) {
        if (!Objects.deepEquals(employeeAvailabilityState, this.state)) {
            this.$$_hibernate_trackChange("state");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.state = (EmployeeAvailabilityState)this.$$_hibernate_getInterceptor().writeObject((Object)this, "state", (Object)this.state, (Object)employeeAvailabilityState);
            return;
        }
        this.state = employeeAvailabilityState;
    }

    @Override
    public Long $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_id((Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)super.$$_hibernate_read_id()));
        }
        return super.$$_hibernate_read_id();
    }

    @Override
    public void $$_hibernate_write_id(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_id((Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)super.$$_hibernate_read_id(), (Object)l));
            return;
        }
        super.$$_hibernate_write_id(l);
    }

    @Override
    public Integer $$_hibernate_read_tenantId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_tenantId((Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "tenantId", (Object)super.$$_hibernate_read_tenantId()));
        }
        return super.$$_hibernate_read_tenantId();
    }

    @Override
    public void $$_hibernate_write_tenantId(Integer n) {
        if (!Objects.deepEquals(n, ((AbstractPersistable)this).$$_hibernate_read_tenantId())) {
            this.$$_hibernate_trackChange("tenantId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_tenantId((Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "tenantId", (Object)super.$$_hibernate_read_tenantId(), (Object)n));
            return;
        }
        super.$$_hibernate_write_tenantId(n);
    }

    @Override
    public Long $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_version((Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "version", (Object)super.$$_hibernate_read_version()));
        }
        return super.$$_hibernate_read_version();
    }

    @Override
    public void $$_hibernate_write_version(Long l) {
        if (!Objects.deepEquals(l, ((AbstractPersistable)this).$$_hibernate_read_version())) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_version((Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "version", (Object)super.$$_hibernate_read_version(), (Object)l));
            return;
        }
        super.$$_hibernate_write_version(l);
    }
}

