/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.roster;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.tenant.Tenant;

@Entity
public class RosterState
extends AbstractPersistable
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    @NotNull
    private Integer publishNotice;
    @NotNull
    private LocalDate firstDraftDate;
    @NotNull
    private Integer publishLength;
    @NotNull
    private Integer draftLength;
    @NotNull
    private Integer unplannedRotationOffset;
    @NotNull
    @Min(value=2L)
    private @NotNull @Min(value=2L) Integer rotationLength;
    @NotNull
    private LocalDate lastHistoricDate;
    @NotNull
    private ZoneId timeZone;
    @OneToOne
    @NotNull
    @JoinColumn(name="tenantId", updatable=false, insertable=false)
    private Tenant tenant;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public RosterState() {
        super(-1);
        this.$$_hibernate_write_publishLength(1);
    }

    public RosterState(Integer tenantId, Integer publishNotice, LocalDate firstDraftDate, Integer publishLength, Integer draftLength, Integer unplannedRotationOffset, Integer rotationLength, LocalDate lastHistoricDate, ZoneId timeZone) {
        super(tenantId);
        this.$$_hibernate_write_publishNotice(publishNotice);
        this.$$_hibernate_write_firstDraftDate(firstDraftDate);
        this.$$_hibernate_write_publishLength(publishLength);
        this.$$_hibernate_write_draftLength(draftLength);
        this.$$_hibernate_write_unplannedRotationOffset(unplannedRotationOffset);
        this.$$_hibernate_write_rotationLength(rotationLength);
        this.$$_hibernate_write_lastHistoricDate(lastHistoricDate);
        this.$$_hibernate_write_timeZone(timeZone);
    }

    @JsonIgnore
    public boolean isHistoric(OffsetDateTime dateTime) {
        return dateTime.isBefore(OffsetDateTime.of(this.getFirstPublishedDate().atTime(LocalTime.MIDNIGHT), dateTime.getOffset()));
    }

    @JsonIgnore
    public boolean isDraft(OffsetDateTime dateTime) {
        return !dateTime.isBefore(OffsetDateTime.of(this.getFirstDraftDate().atTime(LocalTime.MIDNIGHT), dateTime.getOffset()));
    }

    @JsonIgnore
    public boolean isPublished(OffsetDateTime dateTime) {
        return !this.isHistoric(dateTime) && !this.isDraft(dateTime);
    }

    @JsonIgnore
    public boolean isHistoric(LocalDateTime dateTime) {
        return dateTime.isBefore(this.getFirstPublishedDate().atTime(LocalTime.MIDNIGHT));
    }

    @JsonIgnore
    public boolean isDraft(LocalDateTime dateTime) {
        return !dateTime.isBefore(this.getFirstDraftDate().atTime(LocalTime.MIDNIGHT));
    }

    @JsonIgnore
    public boolean isPublished(LocalDateTime dateTime) {
        return !this.isHistoric(dateTime) && !this.isDraft(dateTime);
    }

    @JsonIgnore
    public boolean isHistoric(Shift shift) {
        return this.isHistoric(shift.getStartDateTime());
    }

    @JsonIgnore
    public boolean isDraft(Shift shift) {
        return this.isDraft(shift.getStartDateTime());
    }

    @JsonIgnore
    public boolean isPublished(Shift shift) {
        return this.isPublished(shift.getStartDateTime());
    }

    @JsonIgnore
    public LocalDate getFirstPublishedDate() {
        return this.$$_hibernate_read_lastHistoricDate().plusDays(1L);
    }

    @JsonIgnore
    public LocalDate getFirstUnplannedDate() {
        return this.$$_hibernate_read_firstDraftDate().plusDays(this.$$_hibernate_read_draftLength().intValue());
    }

    @JsonIgnore
    public LocalDate getPublishDeadline() {
        return this.$$_hibernate_read_firstDraftDate().minusDays(this.$$_hibernate_read_publishNotice().intValue());
    }

    public Integer getPublishNotice() {
        return this.$$_hibernate_read_publishNotice();
    }

    public void setPublishNotice(Integer publishNotice) {
        this.$$_hibernate_write_publishNotice(publishNotice);
    }

    public Integer getDraftLength() {
        return this.$$_hibernate_read_draftLength();
    }

    public void setDraftLength(Integer draftLength) {
        this.$$_hibernate_write_draftLength(draftLength);
    }

    @JsonIgnore
    public Integer getPublishLength() {
        return this.$$_hibernate_read_publishLength();
    }

    public Integer getRotationLength() {
        return this.$$_hibernate_read_rotationLength();
    }

    public void setRotationLength(Integer rotationLength) {
        this.$$_hibernate_write_rotationLength(rotationLength);
    }

    public LocalDate getFirstDraftDate() {
        return this.$$_hibernate_read_firstDraftDate();
    }

    public void setFirstDraftDate(LocalDate firstDraftDate) {
        this.$$_hibernate_write_firstDraftDate(firstDraftDate);
    }

    public Integer getUnplannedRotationOffset() {
        return this.$$_hibernate_read_unplannedRotationOffset();
    }

    public void setUnplannedRotationOffset(Integer unplannedOffset) {
        this.$$_hibernate_write_unplannedRotationOffset(unplannedOffset);
    }

    public void setLastHistoricDate(LocalDate lastHistoricDate) {
        this.$$_hibernate_write_lastHistoricDate(lastHistoricDate);
    }

    public LocalDate getLastHistoricDate() {
        return this.$$_hibernate_read_lastHistoricDate();
    }

    public ZoneId getTimeZone() {
        return this.$$_hibernate_read_timeZone();
    }

    public void setTimeZone(ZoneId timeZone) {
        this.$$_hibernate_write_timeZone(timeZone);
    }

    public Tenant getTenant() {
        return this.$$_hibernate_read_tenant();
    }

    public void setTenant(Tenant tenant) {
        this.$$_hibernate_write_tenant(tenant);
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        RosterState rosterState = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        RosterState rosterState = this;
        rosterState = null;
        rosterState = NoopCollectionTracker.INSTANCE;
        return rosterState;
    }

    public Integer $$_hibernate_read_publishNotice() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.publishNotice = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "publishNotice", (Object)this.publishNotice);
        }
        return this.publishNotice;
    }

    public void $$_hibernate_write_publishNotice(Integer n) {
        if (!Objects.deepEquals(n, this.publishNotice)) {
            this.$$_hibernate_trackChange("publishNotice");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.publishNotice = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "publishNotice", (Object)this.publishNotice, (Object)n);
            return;
        }
        this.publishNotice = n;
    }

    public LocalDate $$_hibernate_read_firstDraftDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.firstDraftDate = (LocalDate)this.$$_hibernate_getInterceptor().readObject((Object)this, "firstDraftDate", (Object)this.firstDraftDate);
        }
        return this.firstDraftDate;
    }

    public void $$_hibernate_write_firstDraftDate(LocalDate localDate) {
        if (!Objects.deepEquals(localDate, this.firstDraftDate)) {
            this.$$_hibernate_trackChange("firstDraftDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.firstDraftDate = (LocalDate)this.$$_hibernate_getInterceptor().writeObject((Object)this, "firstDraftDate", (Object)this.firstDraftDate, (Object)localDate);
            return;
        }
        this.firstDraftDate = localDate;
    }

    public Integer $$_hibernate_read_publishLength() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.publishLength = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "publishLength", (Object)this.publishLength);
        }
        return this.publishLength;
    }

    public void $$_hibernate_write_publishLength(Integer n) {
        if (!Objects.deepEquals(n, this.publishLength)) {
            this.$$_hibernate_trackChange("publishLength");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.publishLength = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "publishLength", (Object)this.publishLength, (Object)n);
            return;
        }
        this.publishLength = n;
    }

    public Integer $$_hibernate_read_draftLength() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.draftLength = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "draftLength", (Object)this.draftLength);
        }
        return this.draftLength;
    }

    public void $$_hibernate_write_draftLength(Integer n) {
        if (!Objects.deepEquals(n, this.draftLength)) {
            this.$$_hibernate_trackChange("draftLength");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.draftLength = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "draftLength", (Object)this.draftLength, (Object)n);
            return;
        }
        this.draftLength = n;
    }

    public Integer $$_hibernate_read_unplannedRotationOffset() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.unplannedRotationOffset = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "unplannedRotationOffset", (Object)this.unplannedRotationOffset);
        }
        return this.unplannedRotationOffset;
    }

    public void $$_hibernate_write_unplannedRotationOffset(Integer n) {
        if (!Objects.deepEquals(n, this.unplannedRotationOffset)) {
            this.$$_hibernate_trackChange("unplannedRotationOffset");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.unplannedRotationOffset = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "unplannedRotationOffset", (Object)this.unplannedRotationOffset, (Object)n);
            return;
        }
        this.unplannedRotationOffset = n;
    }

    public Integer $$_hibernate_read_rotationLength() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.rotationLength = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "rotationLength", (Object)this.rotationLength);
        }
        return this.rotationLength;
    }

    public void $$_hibernate_write_rotationLength(Integer n) {
        if (!Objects.deepEquals(n, this.rotationLength)) {
            this.$$_hibernate_trackChange("rotationLength");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.rotationLength = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "rotationLength", (Object)this.rotationLength, (Object)n);
            return;
        }
        this.rotationLength = n;
    }

    public LocalDate $$_hibernate_read_lastHistoricDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastHistoricDate = (LocalDate)this.$$_hibernate_getInterceptor().readObject((Object)this, "lastHistoricDate", (Object)this.lastHistoricDate);
        }
        return this.lastHistoricDate;
    }

    public void $$_hibernate_write_lastHistoricDate(LocalDate localDate) {
        if (!Objects.deepEquals(localDate, this.lastHistoricDate)) {
            this.$$_hibernate_trackChange("lastHistoricDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastHistoricDate = (LocalDate)this.$$_hibernate_getInterceptor().writeObject((Object)this, "lastHistoricDate", (Object)this.lastHistoricDate, (Object)localDate);
            return;
        }
        this.lastHistoricDate = localDate;
    }

    public ZoneId $$_hibernate_read_timeZone() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.timeZone = (ZoneId)this.$$_hibernate_getInterceptor().readObject((Object)this, "timeZone", (Object)this.timeZone);
        }
        return this.timeZone;
    }

    public void $$_hibernate_write_timeZone(ZoneId zoneId) {
        if (!Objects.deepEquals(zoneId, this.timeZone)) {
            this.$$_hibernate_trackChange("timeZone");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.timeZone = (ZoneId)this.$$_hibernate_getInterceptor().writeObject((Object)this, "timeZone", (Object)this.timeZone, (Object)zoneId);
            return;
        }
        this.timeZone = zoneId;
    }

    public Tenant $$_hibernate_read_tenant() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.tenant = (Tenant)this.$$_hibernate_getInterceptor().readObject((Object)this, "tenant", (Object)this.tenant);
        }
        return this.tenant;
    }

    public void $$_hibernate_write_tenant(Tenant tenant) {
        if (!Objects.deepEquals(tenant, this.tenant)) {
            this.$$_hibernate_trackChange("tenant");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.tenant = (Tenant)this.$$_hibernate_getInterceptor().writeObject((Object)this, "tenant", (Object)this.tenant, (Object)tenant);
            return;
        }
        this.tenant = tenant;
    }

    @Override
    public Long $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_id((Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)super.$$_hibernate_read_id()));
        }
        return super.$$_hibernate_read_id();
    }

    @Override
    public void $$_hibernate_write_id(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_id((Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)super.$$_hibernate_read_id(), (Object)l));
            return;
        }
        super.$$_hibernate_write_id(l);
    }

    @Override
    public Integer $$_hibernate_read_tenantId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_tenantId((Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "tenantId", (Object)super.$$_hibernate_read_tenantId()));
        }
        return super.$$_hibernate_read_tenantId();
    }

    @Override
    public void $$_hibernate_write_tenantId(Integer n) {
        if (!Objects.deepEquals(n, ((AbstractPersistable)this).$$_hibernate_read_tenantId())) {
            this.$$_hibernate_trackChange("tenantId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_tenantId((Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "tenantId", (Object)super.$$_hibernate_read_tenantId(), (Object)n));
            return;
        }
        super.$$_hibernate_write_tenantId(n);
    }

    @Override
    public Long $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_version((Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "version", (Object)super.$$_hibernate_read_version()));
        }
        return super.$$_hibernate_read_version();
    }

    @Override
    public void $$_hibernate_write_version(Long l) {
        if (!Objects.deepEquals(l, ((AbstractPersistable)this).$$_hibernate_read_version())) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_version((Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "version", (Object)super.$$_hibernate_read_version(), (Object)l));
            return;
        }
        super.$$_hibernate_write_version(l);
    }
}

