/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.bi;

import java.util.function.BiFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiNode;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetScoringBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetScoringNode;
import org.optaplanner.core.impl.score.stream.common.inliner.UndoScoreImpacter;

public final class BavetScoringBiNode<A, B>
extends BavetAbstractBiNode<A, B>
implements BavetScoringNode {
    private final Score<?> constraintWeight;
    private final BiFunction<A, B, UndoScoreImpacter> scoreImpacter;

    public BavetScoringBiNode(BavetConstraintSession session, int nodeIndex, Score<?> constraintWeight, BiFunction<A, B, UndoScoreImpacter> scoreImpacter) {
        super(session, nodeIndex);
        this.constraintWeight = constraintWeight;
        this.scoreImpacter = scoreImpacter;
    }

    @Override
    public BavetScoringBiTuple<A, B> createTuple(BavetAbstractBiTuple<A, B> parentTuple) {
        return new BavetScoringBiTuple<A, B>(this, parentTuple);
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        BavetScoringBiTuple tuple = (BavetScoringBiTuple)uncastTuple;
        Object a = tuple.getFactA();
        Object b = tuple.getFactB();
        UndoScoreImpacter oldUndoScoreImpacter = tuple.getUndoScoreImpacter();
        if (oldUndoScoreImpacter != null) {
            oldUndoScoreImpacter.run();
        }
        if (tuple.isActive()) {
            UndoScoreImpacter undoScoreImpacter = this.scoreImpacter.apply(a, b);
            tuple.setUndoScoreImpacter(undoScoreImpacter);
        } else {
            tuple.setUndoScoreImpacter(null);
        }
    }

    public String toString() {
        return "Scoring(" + this.constraintWeight + ")";
    }
}

