/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.security.AccessController;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.drools.core.base.AccessorKey;
import org.drools.core.base.BaseClassFieldWriter;
import org.drools.core.base.ClassFieldInspector;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.FieldAccessorFactory;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.WriteAccessor;
import org.drools.core.util.ClassUtils;
import org.drools.wiring.api.ComponentsFactory;
import org.drools.wiring.api.util.ByteArrayClassLoader;

public class ClassFieldAccessorCache {
    private Map<ClassLoader, CacheEntry> cacheByClassLoader = new WeakHashMap<ClassLoader, CacheEntry>();
    private ClassLoader classLoader;

    public ClassFieldAccessorCache(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassObjectType getClassObjectType(ClassObjectType objectType, boolean lookupClass) {
        Class cls = lookupClass ? this.getClass(objectType.getClassName()) : objectType.getClassType();
        CacheEntry cache = this.getCacheEntry(cls);
        return cache.getClassObjectType(cls, objectType);
    }

    public InternalReadAccessor getReadAccessor(String className, String fieldName) {
        Class cls = this.getClass(className);
        return this.getCacheEntry(cls).getReadAccessor(this.getAccessorKey(className, fieldName), cls);
    }

    public void setReadAcessor(String className, String fieldName, InternalReadAccessor readAccessor) {
        Class cls = this.getClass(className);
        this.getCacheEntry(cls).setReadAccessor(this.getAccessorKey(className, fieldName), readAccessor);
    }

    private AccessorKey getAccessorKey(String className, String fieldName) {
        return new AccessorKey(className, fieldName, AccessorKey.AccessorType.FieldAccessor);
    }

    public WriteAccessor getWriteAccessor(String className, String fieldName) {
        Class cls = this.getClass(className);
        return this.getCacheEntry(cls).getWriteAccessor(this.getAccessorKey(className, fieldName), cls);
    }

    public void setWriteAcessor(String className, String fieldName, BaseClassFieldWriter writeAccessor) {
        Class cls = this.getClass(className);
        this.getCacheEntry(cls).setWriteAccessor(this.getAccessorKey(className, fieldName), writeAccessor);
    }

    private Class getClass(String className) {
        return ClassFieldAccessorCache.getClass(this.classLoader, className);
    }

    private static Class getClass(ClassLoader cl, String className) {
        try {
            Class<?> primitiveType = ClassUtils.convertPrimitiveNameToType(className);
            return primitiveType != null ? primitiveType : cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to resolve class '" + className + "'");
        }
    }

    public CacheEntry getCacheEntry(Class cls) {
        ClassLoader cl = cls.getClassLoader() != null ? cls.getClassLoader() : this.classLoader;
        CacheEntry cache = this.cacheByClassLoader.get(cl);
        if (cache == null) {
            cache = new CacheEntry(this.classLoader);
            this.cacheByClassLoader.put(cl, cache);
        }
        return cache;
    }

    public static class CacheEntry {
        private final ByteArrayClassLoader byteArrayClassLoader;
        private final ConcurrentMap<AccessorKey, InternalReadAccessor> readCache = new ConcurrentHashMap<AccessorKey, InternalReadAccessor>();
        private final ConcurrentMap<AccessorKey, WriteAccessor> writeCache = new ConcurrentHashMap<AccessorKey, WriteAccessor>();
        private final ConcurrentMap<Class<?>, ClassFieldInspector> inspectors = new ConcurrentHashMap();
        private final ConcurrentMap<ClassObjectTypeKey, ClassObjectType> objectTypes = new ConcurrentHashMap<ClassObjectTypeKey, ClassObjectType>();

        public CacheEntry(ClassLoader parentClassLoader) {
            if (parentClassLoader == null) {
                throw new RuntimeException("ClassFieldAccessorFactory cannot have a null parent ClassLoader");
            }
            this.byteArrayClassLoader = AccessController.doPrivileged(() -> ComponentsFactory.createByteArrayClassLoader((ClassLoader)parentClassLoader));
        }

        public ByteArrayClassLoader getByteArrayClassLoader() {
            return this.byteArrayClassLoader;
        }

        public InternalReadAccessor getReadAccessor(AccessorKey key, Class cls) {
            InternalReadAccessor existingReader;
            InternalReadAccessor reader = (InternalReadAccessor)this.readCache.get(key);
            if (reader == null && (reader = FieldAccessorFactory.get().getClassFieldReader(cls, key.getFieldName(), this)) != null && (existingReader = this.readCache.putIfAbsent(key, reader)) != null) {
                reader = existingReader;
            }
            return reader;
        }

        public void setReadAccessor(AccessorKey key, InternalReadAccessor reader) {
            this.readCache.put(key, reader);
        }

        public WriteAccessor getWriteAccessor(AccessorKey key, Class cls) {
            WriteAccessor existingWriter;
            WriteAccessor writer = (WriteAccessor)this.writeCache.get(key);
            if (writer == null && (writer = FieldAccessorFactory.get().getClassFieldWriter(cls, key.getFieldName(), this)) != null && (existingWriter = this.writeCache.putIfAbsent(key, writer)) != null) {
                writer = existingWriter;
            }
            return writer;
        }

        public void setWriteAccessor(AccessorKey key, BaseClassFieldWriter writer) {
            this.writeCache.put(key, writer);
        }

        public Map<Class<?>, ClassFieldInspector> getInspectors() {
            return this.inspectors;
        }

        public ClassObjectType getClassObjectType(Class<?> cls, ClassObjectType objectType) {
            ClassObjectTypeKey key = new ClassObjectTypeKey(cls, objectType.isEvent());
            ClassObjectType existing = (ClassObjectType)this.objectTypes.get(key);
            if (existing == null) {
                objectType.setClassType(cls);
                existing = this.objectTypes.putIfAbsent(key, objectType);
                if (existing == null) {
                    existing = objectType;
                }
            }
            return existing;
        }
    }

    public static class ClassObjectTypeKey {
        private Class cls;
        private boolean event;

        public ClassObjectTypeKey(Class cls, boolean event) {
            this.cls = cls;
            this.event = event;
        }

        public Class getCls() {
            return this.cls;
        }

        public boolean isEvent() {
            return this.event;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cls == null ? 0 : this.cls.hashCode());
            result = 31 * result + (this.event ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ClassObjectTypeKey)) {
                return false;
            }
            ClassObjectTypeKey other = (ClassObjectTypeKey)obj;
            if (this.cls == null ? other.cls != null : !this.cls.equals(other.cls)) {
                return false;
            }
            return this.event == other.event;
        }
    }
}

