/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.evaluators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Operator
implements Externalizable,
org.kie.api.runtime.rule.Operator {
    private static final Map<String, Operator> CACHE = new ConcurrentHashMap<String, Operator>();
    private static final long serialVersionUID = 510L;
    private String operator;
    private boolean isNegated;

    public static Operator addOperatorToRegistry(String operatorId, boolean isNegated) {
        Operator op = new Operator(operatorId, isNegated);
        CACHE.put(Operator.getKey(operatorId, isNegated), op);
        return op;
    }

    public static Collection<Operator> getAllOperators() {
        return CACHE.values();
    }

    public static Operator determineOperator(String operatorId, boolean isNegated) {
        return CACHE.get(Operator.getKey(operatorId, isNegated));
    }

    private static String getKey(String string, boolean isNegated) {
        return isNegated + ":" + string;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.operator = (String)in.readObject();
        this.isNegated = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.operator);
        out.writeBoolean(this.isNegated);
    }

    public Operator() {
    }

    private Operator(String operator, boolean isNegated) {
        this.operator = operator;
        this.isNegated = isNegated;
    }

    private Object readResolve() throws ObjectStreamException {
        Operator op = Operator.determineOperator(this.operator, this.isNegated);
        return op != null ? op : this;
    }

    public String toString() {
        return "Operator = '" + this.operator + "'";
    }

    public String getOperatorString() {
        return this.operator;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isNegated ? 1231 : 1237);
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operator other = (Operator)obj;
        if (this.isNegated != other.isNegated) {
            return false;
        }
        if (this.operator == null && other.operator != null) {
            return false;
        }
        return this.operator.equals(other.operator);
    }

    static {
        BuiltInOperator builtInOperator = BuiltInOperator.EQUAL;
    }

    public static enum BuiltInOperator {
        EQUAL("==", false),
        NOT_EQUAL("!=", false),
        LESS("<", false),
        LESS_OR_EQUAL("<=", false),
        GREATER(">", false),
        GREATER_OR_EQUAL(">=", false),
        CONTAINS("contains"),
        EXCLUDES("excludes"),
        MATCHES("matches"),
        MEMBEROF("memberOf"),
        SOUNDSLIKE("soundslike"),
        AFTER("after"),
        BEFORE("before"),
        COINCIDES("coincides"),
        DURING("during"),
        FINISHED_BY("finishedby"),
        FINISHES("finishes"),
        INCLUDES("includes"),
        MEETS("meets"),
        MET_BY("metby"),
        OVERLAPPED_BY("overlappedby"),
        OVERLAPS("overlaps"),
        STARTED_BY("startedby"),
        STARTS("starts"),
        STR("str");

        private final String symbol;
        private final Operator operator;

        private BuiltInOperator(String symbol) {
            this(symbol, true);
        }

        private BuiltInOperator(String symbol, boolean supportNegation) {
            this.symbol = symbol;
            this.operator = Operator.addOperatorToRegistry(symbol, false);
            if (supportNegation) {
                Operator.addOperatorToRegistry(symbol, true);
            }
        }

        public String getSymbol() {
            return this.symbol;
        }

        public Operator getOperator() {
            return this.operator;
        }
    }
}

