/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.fluent.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.drools.core.command.ConversationContextManager;
import org.drools.core.command.RequestContextImpl;
import org.drools.core.command.impl.ContextManagerImpl;
import org.drools.core.fluent.impl.Batch;
import org.drools.core.fluent.impl.InternalExecutable;
import org.drools.core.runtime.InternalLocalRunner;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Executable;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.RequestContext;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.command.ContextManager;

public class PseudoClockRunner
implements InternalLocalRunner {
    private final Map<String, Context> appContexts = new HashMap<String, Context>();
    private ConversationContextManager cvnManager = new ConversationContextManager();
    private long counter;
    private Set<KieSession> ksessions = new HashSet<KieSession>();
    private PriorityQueue<Batch> queue = new PriorityQueue<Batch>(BatchSorter.instance);
    private final long startTime;

    public PseudoClockRunner() {
        this(System.currentTimeMillis());
    }

    public PseudoClockRunner(long startTime) {
        this.startTime = startTime;
    }

    public RequestContext execute(Executable executable, RequestContext ctx) {
        this.executeBatches((InternalExecutable)executable, ctx);
        this.executeQueue(ctx);
        return ctx;
    }

    private void executeBatches(InternalExecutable executable, RequestContext ctx) {
        for (Batch batch : executable.getBatches()) {
            if (batch.getDistance() == 0L) {
                this.executeBatch(batch, ctx);
                continue;
            }
            this.queue.add(batch);
        }
    }

    private void executeQueue(RequestContext ctx) {
        while (!this.queue.isEmpty()) {
            Batch batch = (Batch)this.queue.remove();
            long timeNow = this.startTime + batch.getDistance();
            for (KieSession ksession : this.ksessions) {
                this.updateKieSessionTime(timeNow, batch.getDistance(), ksession);
            }
            for (Command cmd : batch.getCommands()) {
                Object returned = ((ExecutableCommand)cmd).execute((Context)ctx);
                if (returned == null) continue;
                ctx.setResult(returned);
                if (!(returned instanceof KieSession)) continue;
                KieSession ksession = (KieSession)returned;
                this.updateKieSessionTime(timeNow, batch.getDistance(), ksession);
                this.ksessions.add((KieSession)returned);
            }
        }
    }

    private void executeBatch(Batch batch, RequestContext ctx) {
        for (Command cmd : batch.getCommands()) {
            Object returned = ((ExecutableCommand)cmd).execute((Context)ctx);
            if (returned == null) continue;
            ctx.setResult(returned);
            if (!(returned instanceof KieSession)) continue;
            KieSession ksession = (KieSession)returned;
            this.updateKieSessionTime(this.startTime, 0L, ksession);
            this.ksessions.add((KieSession)returned);
        }
    }

    private void updateKieSessionTime(long timeNow, long distance, KieSession ksession) {
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        if (clock.getCurrentTime() != timeNow) {
            long newTime = this.startTime + distance;
            long currentTime = clock.getCurrentTime();
            clock.advanceTime(newTime - currentTime, TimeUnit.MILLISECONDS);
        }
    }

    public RequestContext createContext() {
        return new RequestContextImpl(this.counter++, (ContextManager)new ContextManagerImpl(this.appContexts), this.cvnManager);
    }

    private static class BatchSorter
    implements Comparator<Batch> {
        public static BatchSorter instance = new BatchSorter();

        private BatchSorter() {
        }

        @Override
        public int compare(Batch o1, Batch o2) {
            if (o1.getDistance() > o2.getDistance()) {
                return 1;
            }
            if (o1.getDistance() < o2.getDistance()) {
                return -1;
            }
            return 0;
        }
    }
}

