/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.EvalNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.EvalCondition;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.RuleComponent;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.kie.api.definition.rule.Rule;

public class EvalConditionNode
extends LeftTupleSource
implements LeftTupleSinkNode,
MemoryFactory<EvalMemory> {
    private static final long serialVersionUID = 510L;
    protected EvalCondition condition;
    protected boolean tupleMemoryEnabled;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private Map<Rule, RuleComponent> componentsMap = new HashMap<Rule, RuleComponent>();

    public EvalConditionNode() {
    }

    public EvalConditionNode(int id, LeftTupleSource tupleSource, EvalCondition eval, BuildContext context) {
        super(id, context);
        this.condition = eval;
        this.setLeftTupleSource(tupleSource);
        this.setObjectCount(this.leftInput.getObjectCount());
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.initMasks(context, tupleSource);
        this.hashcode = this.calculateHashCode();
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.leftInput.addTupleSink(this, context);
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.leftInput.networkUpdated(updateContext);
    }

    public EvalCondition getCondition() {
        return this.condition;
    }

    @Override
    public String toString() {
        return "[EvalConditionNode(" + this.id + ")]: cond=" + this.condition + "]";
    }

    private int calculateHashCode() {
        return this.leftInput.hashCode() ^ this.condition.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof EvalConditionNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        EvalConditionNode other = (EvalConditionNode)object;
        return this.leftInput.getId() == other.leftInput.getId() && this.condition.equals(other.condition);
    }

    @Override
    public EvalMemory createMemory(RuleBaseConfiguration config, ReteEvaluator reteEvaluator) {
        return new EvalMemory(this.condition.createContext());
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        EvalNodeLeftTuple peer = new EvalNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 131;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(factHandle, this, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return new EvalNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return new EvalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        return this.leftInput.getObjectTypeNode();
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            return true;
        }
        this.condition = (EvalCondition)this.componentsMap.values().iterator().next();
        return false;
    }

    @Override
    public void addAssociation(BuildContext context, Rule rule) {
        super.addAssociation(context, rule);
        this.componentsMap.put(rule, context.peekRuleComponent());
    }

    @Override
    public boolean removeAssociation(Rule rule) {
        boolean result = super.removeAssociation(rule);
        if (!this.isAssociatedWith(rule)) {
            this.componentsMap.remove(rule);
        }
        return result;
    }

    public static class EvalMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Externalizable,
    Memory {
        private static final long serialVersionUID = 510L;
        public Object context;
        private SegmentMemory memory;

        public EvalMemory() {
        }

        public EvalMemory(Object context) {
            this.context = context;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.context = in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.context);
        }

        @Override
        public short getNodeType() {
            return 131;
        }

        @Override
        public void setSegmentMemory(SegmentMemory smem) {
            this.memory = smem;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.memory;
        }

        @Override
        public void reset() {
        }
    }
}

