/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.FastIterator;

public class NotNodeLeftTuple
extends BaseLeftTuple {
    private static final long serialVersionUID = 540L;
    private RightTuple blocker;
    private LeftTuple blockedPrevious;
    private LeftTuple blockedNext;

    public NotNodeLeftTuple() {
    }

    public NotNodeLeftTuple(InternalFactHandle factHandle, Sink sink, boolean leftTupleMemoryEnabled) {
        super(factHandle, sink, leftTupleMemoryEnabled);
    }

    public NotNodeLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        super(factHandle, leftTuple, sink);
    }

    public NotNodeLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        super(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    public NotNodeLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        super(leftTuple, rightTuple, sink);
    }

    public NotNodeLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink, boolean leftTupleMemoryEnabled) {
        this(leftTuple, rightTuple, null, null, sink, leftTupleMemoryEnabled);
    }

    public NotNodeLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        super(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public void unlinkFromLeftParent() {
        super.unlinkFromLeftParent();
    }

    @Override
    public void unlinkFromRightParent() {
        super.unlinkFromRightParent();
    }

    @Override
    public void clearBlocker() {
        this.blockedPrevious = null;
        this.blockedNext = null;
        this.blocker = null;
    }

    @Override
    public void setBlocker(RightTuple blocker) {
        this.blocker = blocker;
    }

    @Override
    public RightTuple getBlocker() {
        return this.blocker;
    }

    @Override
    public LeftTuple getBlockedPrevious() {
        return this.blockedPrevious;
    }

    @Override
    public void setBlockedPrevious(LeftTuple blockerPrevious) {
        this.blockedPrevious = blockerPrevious;
    }

    @Override
    public LeftTuple getBlockedNext() {
        return this.blockedNext;
    }

    @Override
    public void setBlockedNext(LeftTuple blockerNext) {
        this.blockedNext = blockerNext;
    }

    @Override
    public Collection<Object> getAccumulatedObjects() {
        if (201 != this.getTupleSink().getType()) {
            return Collections.emptyList();
        }
        BetaNode betaNode = (BetaNode)this.getTupleSink();
        BetaConstraints constraints = betaNode.getRawConstraints();
        ReteEvaluator reteEvaluator = this.getFactHandle().getReteEvaluator();
        BetaMemory bm = (BetaMemory)reteEvaluator.getNodeMemory((MemoryFactory)((Object)this.getTupleSink()));
        TupleMemory rtm = bm.getRightTupleMemory();
        FastIterator it = betaNode.getRightIterator(rtm);
        ContextEntry[] contextEntry = bm.getContext();
        constraints.updateFromTuple(contextEntry, reteEvaluator, this);
        ArrayList<Object> result = new ArrayList<Object>();
        RightTuple rightTuple = betaNode.getFirstRightTuple(this, rtm, it);
        while (rightTuple != null) {
            InternalFactHandle fh;
            RightTuple nextRight = (RightTuple)it.next(rightTuple);
            if (!(rightTuple instanceof SubnetworkTuple) && constraints.isAllowedCachedLeft(contextEntry, fh = rightTuple.getFactHandleForEvaluation())) {
                result.add(fh.getObject());
            }
            rightTuple = nextRight;
        }
        return result;
    }
}

