/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.rotation;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.optaweb.employeerostering.domain.rotation.view.TimeBucketView;
import org.optaweb.employeerostering.service.rotation.RotationService;

@Path(value="/rest/tenant/{tenantId}/rotation")
@ApplicationScoped
@Tag(name="Rotation")
public class RotationController {
    private final RotationService rotationService;

    @Inject
    public RotationController(RotationService rotationService) {
        this.rotationService = rotationService;
    }

    @GET
    @Path(value="/")
    @Operation(summary="List Time Buckets", description="Get a list of all time buckets")
    public List<TimeBucketView> getTimeBucketList(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return this.rotationService.getTimeBucketList(tenantId);
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get Time Bucket", description="Gets a time bucket by id")
    public TimeBucketView getTimeBucket(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @PathParam(value="id") @Min(value=0L) @Min(value=0L) Long id) {
        return this.rotationService.getTimeBucket(tenantId, id);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(summary="Delete Time Bucket", description="Deletes a time bucket by id")
    public Boolean deleteTimeBucket(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @PathParam(value="id") @Min(value=0L) @Min(value=0L) Long id) {
        return this.rotationService.deleteTimeBucket(tenantId, id);
    }

    @POST
    @Path(value="/add")
    @Operation(summary="Add Time Bucket", description="Adds a new time bucket")
    public TimeBucketView createTimeBucket(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @Valid TimeBucketView timeBucketView) {
        return this.rotationService.createTimeBucket(tenantId, timeBucketView);
    }

    @PUT
    @Path(value="/update")
    @Operation(summary="Update Time Bucket", description="Updates a time bucket")
    public TimeBucketView updateTimeBucket(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @Valid TimeBucketView timeBucketView) {
        return this.rotationService.updateTimeBucket(tenantId, timeBucketView);
    }
}

