/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graalvm.internal;

import com.oracle.svm.core.annotate.AutomaticFeature;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.hibernate.graalvm.internal.StaticClassLists;
import org.hibernate.internal.util.ReflectHelper;

@AutomaticFeature
public class GraalVMStaticAutofeature
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess before) {
        Class[] needsHavingSimpleConstructors = StaticClassLists.typesNeedingDefaultConstructorAccessible();
        Class[] neddingAllConstructorsAccessible = StaticClassLists.typesNeedingAllConstructorsAccessible();
        ArrayList executables = new ArrayList(needsHavingSimpleConstructors.length + neddingAllConstructorsAccessible.length * 3);
        for (Class c : needsHavingSimpleConstructors) {
            executables.add(ReflectHelper.getDefaultConstructor((Class)c));
        }
        for (Class c : neddingAllConstructorsAccessible) {
            for (Constructor<?> declaredConstructor : c.getDeclaredConstructors()) {
                executables.add(declaredConstructor);
            }
        }
        RuntimeReflection.register((Class[])needsHavingSimpleConstructors);
        RuntimeReflection.register((Class[])neddingAllConstructorsAccessible);
        RuntimeReflection.register((Class[])StaticClassLists.typesNeedingArrayCopy());
        RuntimeReflection.register((Executable[])executables.toArray(new Executable[0]));
    }
}

