/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.locale;

import io.quarkus.hibernate.validator.runtime.locale.AbstractLocaleResolver;
import java.util.Locale;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolver;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolverContext;

@Singleton
@Named(value="locale-resolver-wrapper")
public class LocaleResolversWrapper
implements LocaleResolver {
    @Inject
    Instance<AbstractLocaleResolver> resolvers;

    public Locale resolve(LocaleResolverContext context) {
        for (AbstractLocaleResolver resolver : this.resolvers) {
            Locale locale = resolver.resolve(context);
            if (locale == null) continue;
            return locale;
        }
        return context.getDefaultLocale();
    }
}

