/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.admin;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class SystemPropertiesRetriever {
    public static final String ZONE_ID_SYSTEM_PROPERTY = "optaweb.generator.timeZoneId";
    public static final String INITIAL_DATA_PROPERTY = "optaweb.generator.initial.data";
    @ConfigProperty(name="optaweb.generator.timeZoneId")
    Optional<String> zoneId;
    @ConfigProperty(name="optaweb.generator.initial.data", defaultValue="DEMO_DATA")
    String demoData;

    public SystemPropertiesRetriever() {
        this(Optional.of("UTC"), "DEMO_DATA");
    }

    public SystemPropertiesRetriever(Optional<String> zoneId, String demoData) {
        this.zoneId = zoneId;
        this.demoData = demoData != null ? demoData : "DEMO_DATA";
    }

    public ZoneId determineZoneId() {
        if (this.zoneId.isPresent()) {
            try {
                return ZoneId.of(this.zoneId.get());
            }
            catch (DateTimeException e) {
                throw new IllegalStateException("The system property (optaweb.generator.timeZoneId) has an invalid value (" + this.zoneId.get() + ").", e);
            }
        }
        return ZoneId.systemDefault();
    }

    public InitialData determineInitialData() {
        try {
            return InitialData.valueOf(this.demoData);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("The system property (optaweb.generator.initial.data) has an invalid value (" + this.demoData + ").", e);
        }
    }

    public static enum InitialData {
        EMPTY,
        DEMO_DATA;

    }
}

