/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet;

import java.util.Map;
import org.optaplanner.constraint.streams.bavet.BavetConstraintSession;
import org.optaplanner.constraint.streams.bavet.BavetConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirector;

public final class BavetConstraintStreamScoreDirector<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirector<Solution_, Score_, BavetConstraintStreamScoreDirectorFactory<Solution_, Score_>> {
    protected BavetConstraintSession<Solution_, Score_> session;

    public BavetConstraintStreamScoreDirector(BavetConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory, boolean lookUpEnabled, boolean constraintMatchEnabledPreference) {
        super(scoreDirectorFactory, lookUpEnabled, constraintMatchEnabledPreference);
    }

    public void setWorkingSolution(Solution_ workingSolution) {
        super.setWorkingSolution(workingSolution);
        this.resetConstraintStreamingSession();
    }

    private void resetConstraintStreamingSession() {
        this.session = ((BavetConstraintStreamScoreDirectorFactory)this.scoreDirectorFactory).newSession(this.constraintMatchEnabledPreference, this.workingSolution);
        this.getSolutionDescriptor().visitAllFacts(this.workingSolution, this.session::insert);
    }

    public Score_ calculateScore() {
        this.variableListenerSupport.assertNotificationQueuesAreEmpty();
        Score_ score = this.session.calculateScore(this.workingInitScore);
        this.setCalculatedScore((Score)score);
        return score;
    }

    public boolean isConstraintMatchEnabled() {
        return this.constraintMatchEnabledPreference;
    }

    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        if (this.workingSolution == null) {
            throw new IllegalStateException("The method setWorkingSolution() must be called before the method getConstraintMatchTotalMap().");
        }
        return this.session.getConstraintMatchTotalMap();
    }

    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        if (this.workingSolution == null) {
            throw new IllegalStateException("The method setWorkingSolution() must be called before the method getIndictmentMap().");
        }
        return this.session.getIndictmentMap();
    }

    public boolean requiresFlushing() {
        return true;
    }

    public void close() {
        super.close();
        this.session = null;
    }

    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") cannot be added to the ScoreDirector.");
        }
        if (!this.getSolutionDescriptor().hasEntityDescriptor(entity.getClass())) {
            throw new IllegalArgumentException("The entity (" + entity + ") of class (" + entity.getClass() + ") is not a configured @" + PlanningEntity.class.getSimpleName() + ".");
        }
        this.session.insert(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        this.session.update(entity);
        super.afterVariableChanged(variableDescriptor, entity);
    }

    public void afterElementAdded(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int index) {
        this.session.update(entity);
        super.afterElementAdded(variableDescriptor, entity, index);
    }

    public void afterElementRemoved(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int index) {
        this.session.update(entity);
        super.afterElementRemoved(variableDescriptor, entity, index);
    }

    public void afterElementMoved(ListVariableDescriptor<Solution_> variableDescriptor, Object sourceEntity, int sourceIndex, Object destinationEntity, int destinationIndex) {
        this.session.update(sourceEntity);
        if (sourceEntity != destinationEntity) {
            this.session.update(destinationEntity);
        }
        super.afterElementMoved(variableDescriptor, sourceEntity, sourceIndex, destinationEntity, destinationIndex);
    }

    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.session.retract(entity);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    public void afterProblemFactAdded(Object problemFact) {
        if (problemFact == null) {
            throw new IllegalArgumentException("The problemFact (" + problemFact + ") cannot be added to the ScoreDirector.");
        }
        this.session.insert(problemFact);
        super.afterProblemFactAdded(problemFact);
    }

    public void afterProblemPropertyChanged(Object problemFactOrEntity) {
        this.session.update(problemFactOrEntity);
        super.afterProblemPropertyChanged(problemFactOrEntity);
    }

    public void afterProblemFactRemoved(Object problemFact) {
        this.session.retract(problemFact);
        super.afterProblemFactRemoved(problemFact);
    }

    public BavetConstraintSession<Solution_, Score_> getSession() {
        return this.session;
    }
}

