/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.bi;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.bi.BiTuple;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public final class JoinBiNode<A, B>
extends AbstractNode {
    private final Function<A, IndexProperties> mappingA;
    private final Function<B, IndexProperties> mappingB;
    private final int inputStoreIndexA;
    private final int inputStoreIndexB;
    private final Consumer<BiTuple<A, B>> nextNodesInsert;
    private final Consumer<BiTuple<A, B>> nextNodesRetract;
    private final int outputStoreSize;
    private final Indexer<UniTuple<A>, Map<UniTuple<B>, BiTuple<A, B>>> indexerA;
    private final Indexer<UniTuple<B>, Map<UniTuple<A>, BiTuple<A, B>>> indexerB;
    private final Queue<BiTuple<A, B>> dirtyTupleQueue;

    public JoinBiNode(Function<A, IndexProperties> mappingA, Function<B, IndexProperties> mappingB, int inputStoreIndexA, int inputStoreIndexB, Consumer<BiTuple<A, B>> nextNodesInsert, Consumer<BiTuple<A, B>> nextNodesRetract, int outputStoreSize, Indexer<UniTuple<A>, Map<UniTuple<B>, BiTuple<A, B>>> indexerA, Indexer<UniTuple<B>, Map<UniTuple<A>, BiTuple<A, B>>> indexerB) {
        this.mappingA = mappingA;
        this.mappingB = mappingB;
        this.inputStoreIndexA = inputStoreIndexA;
        this.inputStoreIndexB = inputStoreIndexB;
        this.nextNodesInsert = nextNodesInsert;
        this.nextNodesRetract = nextNodesRetract;
        this.outputStoreSize = outputStoreSize;
        this.indexerA = indexerA;
        this.indexerB = indexerB;
        this.dirtyTupleQueue = new ArrayDeque<BiTuple<A, B>>(1000);
    }

    public void insertA(UniTuple<A> tupleA) {
        if (tupleA.store[this.inputStoreIndexA] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tupleA + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingA.apply(tupleA.factA);
        tupleA.store[this.inputStoreIndexA] = indexProperties;
        HashMap tupleABMapA = new HashMap();
        this.indexerA.put(indexProperties, tupleA, tupleABMapA);
        this.indexerB.visit(indexProperties, (tupleB, tupleABMapB) -> {
            BiTuple tupleAB = new BiTuple(tupleA.factA, tupleB.factA, this.outputStoreSize);
            tupleAB.state = BavetTupleState.CREATING;
            tupleABMapA.put(tupleB, tupleAB);
            tupleABMapB.put(tupleA, tupleAB);
            this.dirtyTupleQueue.add(tupleAB);
        });
    }

    public void retractA(UniTuple<A> tupleA) {
        IndexProperties indexProperties = (IndexProperties)tupleA.store[this.inputStoreIndexA];
        if (indexProperties == null) {
            return;
        }
        tupleA.store[this.inputStoreIndexA] = null;
        this.indexerA.remove(indexProperties, tupleA);
        this.indexerB.visit(indexProperties, (tupleB, tupleABMapB) -> {
            BiTuple tupleAB = (BiTuple)tupleABMapB.remove(tupleA);
            if (tupleAB == null) {
                throw new IllegalStateException("Impossible state: the tuple (" + tupleA + ") with indexProperties (" + indexProperties + ") has tuples on the A side that didn't exist on the B side.");
            }
            this.killTuple(tupleAB);
        });
    }

    public void insertB(UniTuple<B> tupleB) {
        if (tupleB.store[this.inputStoreIndexB] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tupleB + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingB.apply(tupleB.factA);
        tupleB.store[this.inputStoreIndexB] = indexProperties;
        HashMap tupleABMapB = new HashMap();
        this.indexerB.put(indexProperties, tupleB, tupleABMapB);
        this.indexerA.visit(indexProperties, (tupleA, tupleABMapA) -> {
            BiTuple tupleAB = new BiTuple(tupleA.factA, tupleB.factA, this.outputStoreSize);
            tupleAB.state = BavetTupleState.CREATING;
            tupleABMapB.put(tupleA, tupleAB);
            tupleABMapA.put(tupleB, tupleAB);
            this.dirtyTupleQueue.add(tupleAB);
        });
    }

    public void retractB(UniTuple<B> tupleB) {
        IndexProperties indexProperties = (IndexProperties)tupleB.store[this.inputStoreIndexB];
        if (indexProperties == null) {
            return;
        }
        tupleB.store[this.inputStoreIndexB] = null;
        this.indexerB.remove(indexProperties, tupleB);
        this.indexerA.visit(indexProperties, (tupleA, tupleABMapA) -> {
            BiTuple tupleAB = (BiTuple)tupleABMapA.remove(tupleB);
            if (tupleAB == null) {
                throw new IllegalStateException("Impossible state: the tuple (" + tupleA + ") with indexProperties (" + indexProperties + ") has tuples on the B side that didn't exist on the A side.");
            }
            this.killTuple(tupleAB);
        });
    }

    private void killTuple(BiTuple<A, B> tupleAB) {
        block6: {
            block5: {
                if (!tupleAB.state.isDirty()) break block5;
                switch (tupleAB.state) {
                    case CREATING: {
                        tupleAB.state = BavetTupleState.ABORTING;
                        break block6;
                    }
                    case UPDATING: {
                        tupleAB.state = BavetTupleState.DYING;
                        break block6;
                    }
                    case DYING: {
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException("Impossible state: The tuple (" + tupleAB + ") has the dirty state (" + tupleAB.state + ").");
                    }
                }
            }
            tupleAB.state = BavetTupleState.DYING;
            this.dirtyTupleQueue.add(tupleAB);
        }
    }

    @Override
    public void calculateScore() {
        this.dirtyTupleQueue.forEach(tuple -> {
            if (tuple.state == BavetTupleState.UPDATING || tuple.state == BavetTupleState.DYING) {
                this.nextNodesRetract.accept((BiTuple<A, B>)tuple);
            }
            if (tuple.state == BavetTupleState.CREATING || tuple.state == BavetTupleState.UPDATING) {
                this.nextNodesInsert.accept((BiTuple<A, B>)tuple);
            }
            switch (tuple.state) {
                case CREATING: 
                case UPDATING: {
                    tuple.state = BavetTupleState.OK;
                    return;
                }
                case DYING: 
                case ABORTING: {
                    tuple.state = BavetTupleState.DEAD;
                    return;
                }
                case DEAD: {
                    throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + this + ") is already in the dead state (" + tuple.state + ").");
                }
            }
            throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + this + ") is in an unexpected state (" + tuple.state + ").");
        });
        this.dirtyTupleQueue.clear();
    }

    public String toString() {
        return "JoinBiNode";
    }
}

