/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.postgresql.runtime;

import io.quarkus.kubernetes.service.binding.runtime.JdbcDatasourceUtil;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBinding;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConfigSource;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PostgreSQLServiceBindingConverter
implements ServiceBindingConverter {
    public static final String BINDING_TYPE = "postgresql";
    public static final String SSL_MODE = "sslmode";
    public static final String SSL_ROOT_CERT = "sslrootcert";
    public static final String OPTIONS = "options";

    public Optional<ServiceBindingConfigSource> convert(List<ServiceBinding> serviceBindings) {
        Optional matchingByType = ServiceBinding.singleMatchingByType((String)BINDING_TYPE, serviceBindings);
        if (!matchingByType.isPresent()) {
            return Optional.empty();
        }
        ServiceBinding binding = (ServiceBinding)matchingByType.get();
        Map properties = JdbcDatasourceUtil.getServiceBindingProperties((ServiceBinding)binding, (String)BINDING_TYPE);
        StringBuilder sslparam = new StringBuilder();
        String sslmode = binding.getProperties().getOrDefault(SSL_MODE, "");
        String sslRootCert = binding.getProperties().getOrDefault(SSL_ROOT_CERT, "");
        if (!"".equals(sslmode)) {
            sslparam.append(SSL_MODE).append("=").append(sslmode);
        }
        if (!"".equals(sslRootCert)) {
            if (!"".equals(sslmode)) {
                sslparam.append("&");
            }
            sslparam.append(SSL_ROOT_CERT).append("=").append(binding.getBindingDirectory()).append(FileSystems.getDefault().getSeparator()).append(sslRootCert);
        }
        String options = binding.getProperties().getOrDefault(OPTIONS, "");
        Object crdbOption = "";
        ArrayList<CallSite> postgreOptions = new ArrayList<CallSite>();
        if (!options.equals("")) {
            String[] allOpts;
            for (String o : allOpts = options.split("&")) {
                String[] keyval = o.split("=");
                if (keyval.length != 2 || keyval[0].length() == 0 || keyval[1].length() == 0) continue;
                if (keyval[0].equals("--cluster")) {
                    crdbOption = keyval[0] + "=" + keyval[1];
                    continue;
                }
                postgreOptions.add((CallSite)((Object)("-c " + keyval[0] + "=" + keyval[1])));
            }
        }
        Object combinedOptions = crdbOption;
        if (postgreOptions.size() > 0) {
            String otherOpts = String.join((CharSequence)" ", postgreOptions);
            combinedOptions = !((String)combinedOptions).equals("") ? (String)combinedOptions + " " + otherOpts : otherOpts;
        }
        try {
            combinedOptions = ((String)combinedOptions).length() > 0 ? "options=" + this.encode((String)combinedOptions).replace("+", "%20") : "";
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("failed to encode options params" + options, e);
        }
        if (sslparam.length() > 0 && !((String)combinedOptions).equals("")) {
            combinedOptions = sslparam + "&" + (String)combinedOptions;
        } else if (sslparam.length() > 0) {
            combinedOptions = sslparam.toString();
        }
        if (!"".equals(combinedOptions)) {
            properties.put("quarkus.datasource.jdbc.url", (String)properties.get("quarkus.datasource.jdbc.url") + "?" + (String)combinedOptions);
        }
        return Optional.of(new ServiceBindingConfigSource("postgresql-k8s-service-binding-source", properties));
    }

    private String encode(String str) throws UnsupportedEncodingException {
        return URLEncoder.encode(str, StandardCharsets.UTF_8.toString());
    }
}

