/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.roster;

import io.quarkus.runtime.StartupEvent;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.apache.commons.lang3.tuple.Triple;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailability;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailabilityState;
import org.optaweb.employeerostering.domain.roster.Roster;
import org.optaweb.employeerostering.domain.roster.RosterState;
import org.optaweb.employeerostering.domain.rotation.Seat;
import org.optaweb.employeerostering.domain.rotation.TimeBucket;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.tenant.RosterConstraintConfiguration;
import org.optaweb.employeerostering.domain.tenant.Tenant;
import org.optaweb.employeerostering.service.admin.SystemPropertiesRetriever;
import org.optaweb.employeerostering.service.common.generator.StringDataGenerator;

@ApplicationScoped
public class RosterGenerator {
    private static final double[] EXTRA_SHIFT_THRESHOLDS = new double[]{0.5, 0.8, 0.95};
    private final StringDataGenerator tenantNameGenerator = StringDataGenerator.buildLocationNames();
    private final StringDataGenerator employeeNameGenerator = StringDataGenerator.buildFullNames();
    private final List<DayOfWeek> ALL_WEEK = Arrays.asList(DayOfWeek.values());
    private final List<DayOfWeek> WEEKDAYS = Arrays.asList(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    private final GeneratorType hospitalGeneratorType = new GeneratorType("Hospital", new StringDataGenerator().addPart("Ambulatory care", "Critical care", "Midwife", "Gastroenterology", "Neuroscience", "Oncology", "Pediatric", "Psychiatric", "Geriatric", "Radiology").addPart("nurse", "physician", "doctor", "attendant", "specialist", "surgeon", "medic", "practitioner", "pharmacist", "researcher"), new StringDataGenerator(true).addPart(false, 0, "Basic", "Advanced", "Expert", "Specialized", "Elder", "Child", "Infant", "Baby", "Male", "Female", "Common", "Uncommon", "Research", "Administrative", "Regressing").addPart(true, 1, "anaesthetics", "cardiology", "critical care", "emergency", "ear nose throat", "gastroenterology", "haematology", "maternity", "neurology", "oncology", "ophthalmology", "orthopaedics", "physiotherapy", "radiotherapy", "urology").addPart(false, 0, "Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omicron"), Arrays.asList(Triple.of((Object)LocalTime.of(6, 0), (Object)LocalTime.of(14, 0), this.ALL_WEEK), Triple.of((Object)LocalTime.of(9, 0), (Object)LocalTime.of(17, 0), this.ALL_WEEK), Triple.of((Object)LocalTime.of(14, 0), (Object)LocalTime.of(22, 0), this.ALL_WEEK), Triple.of((Object)LocalTime.of(22, 0), (Object)LocalTime.of(6, 0), this.ALL_WEEK)), 21, 6, (startDayOffset, timeslotRangesIndex) -> {
        switch (timeslotRangesIndex) {
            case 0: {
                return startDayOffset % 7 >= 5 ? 3 : startDayOffset / 7;
            }
            case 1: {
                return (startDayOffset + 2) % 7 < 4 ? 5 : (startDayOffset - 16 + 21) % 21 / 7;
            }
            case 2: {
                return startDayOffset % 7 < 3 ? 3 : 4;
            }
            case 3: {
                return startDayOffset % 7 < 1 ? 4 : (startDayOffset - 8 + 21) % 21 / 7;
            }
        }
        throw new IllegalStateException("Impossible state for timeslotRangesIndex (" + timeslotRangesIndex + ").");
    });
    private final GeneratorType factoryAssemblyGeneratorType = new GeneratorType("Factory assembly", new StringDataGenerator().addPart("Mechanical", "Electrical", "Safety", "Transportation", "Operational", "Physics", "Monitoring", "ICT").addPart("bachelor", "engineer", "instructor", "coordinator", "manager", "expert", "inspector", "analyst"), StringDataGenerator.buildAssemblyLineNames(), Arrays.asList(Triple.of((Object)LocalTime.of(6, 0), (Object)LocalTime.of(14, 0), this.ALL_WEEK), Triple.of((Object)LocalTime.of(14, 0), (Object)LocalTime.of(22, 0), this.ALL_WEEK), Triple.of((Object)LocalTime.of(22, 0), (Object)LocalTime.of(6, 0), this.ALL_WEEK)), 28, 4, (startDayOffset, timeslotRangesIndex) -> (startDayOffset - 9 * timeslotRangesIndex + 28) % 28 / 7);
    private final GeneratorType guardSecurityGeneratorType = new GeneratorType("Guard security", new StringDataGenerator().addPart("Martial art", "Armed", "Surveillance", "Technical", "Computer").addPart("basic", "advanced", "expert", "master", "novice"), new StringDataGenerator().addPart("Airport", "Harbor", "Bank", "Office", "Warehouse", "Store", "Factory", "Station", "Museum", "Mansion", "Monument", "City hall", "Prison", "Mine", "Palace").addPart("north gate", "south gate", "east gate", "west gate", "roof", "cellar", "north west gate", "north east gate", "south west gate", "south east gate", "main door", "back door", "side door", "balcony", "patio").addPart("Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omicron"), Arrays.asList(Triple.of((Object)LocalTime.of(7, 0), (Object)LocalTime.of(19, 0), this.ALL_WEEK), Triple.of((Object)LocalTime.of(19, 0), (Object)LocalTime.of(7, 0), this.ALL_WEEK)), 21, 3, (startDayOffset, timeslotRangesIndex) -> {
        int offset;
        int n = offset = timeslotRangesIndex == 0 ? startDayOffset : (startDayOffset + 7) % 21;
        return offset < 3 ? 0 : (offset < 7 ? 1 : (offset < 10 ? 2 : (offset < 14 ? 0 : (offset < 17 ? 1 : (offset < 21 ? 2 : -1)))));
    });
    private final GeneratorType callCenterGeneratorType = new GeneratorType("Call center", new StringDataGenerator().addPart("English", "Spanish", "French", "German", "Japanese", "Chinese", "Dutch", "Portuguese", "Italian"), new StringDataGenerator().addPart("Business loans", "Checking and savings accounts", "Debit and credit cards", "Insurances", "Merchant services", "Cash management", "Tax management", "Wealth management", "Mortgages", "Personal loans", "Online payment"), Arrays.asList(Triple.of((Object)LocalTime.of(7, 0), (Object)LocalTime.of(16, 0), this.ALL_WEEK), Triple.of((Object)LocalTime.of(11, 0), (Object)LocalTime.of(20, 0), this.ALL_WEEK)), 7, 3, (startDayOffset, timeslotRangesIndex) -> timeslotRangesIndex == 0 ? (startDayOffset < 1 ? 1 : (startDayOffset < 6 ? 0 : (startDayOffset < 7 ? 1 : -1))) : (startDayOffset < 2 ? 2 : (startDayOffset < 4 ? 1 : (startDayOffset < 7 ? 2 : -1))));
    private final GeneratorType postOfficeGeneratorType = new GeneratorType("Post office", new StringDataGenerator().addPart("Truck license", "Bicycle license", "Computer certification", "Administration", "Transportation", "Monitoring", "Logistics", "Coordination", "Customer service"), new StringDataGenerator().addPart(true, 1, "North", "South", "East", "West", "North West", "North East", "South West", "South East", "Central").addPart(true, 1, "Uptown", "Harbor", "Lakeshore", "Point", "Valley", "Port", "Heights", "Beach", "Downtown"), Arrays.asList(Triple.of((Object)LocalTime.of(9, 0), (Object)LocalTime.of(17, 0), this.WEEKDAYS), Triple.of((Object)LocalTime.of(9, 0), (Object)LocalTime.of(15, 0), Arrays.asList(DayOfWeek.SATURDAY))), 7, 3, (startDayOffset, timeslotRangesIndex) -> timeslotRangesIndex == 0 ? (startDayOffset < 1 ? 1 : (startDayOffset < 6 ? 0 : (startDayOffset < 7 ? 1 : -1))) : (startDayOffset < 2 ? 2 : (startDayOffset < 4 ? 1 : (startDayOffset < 7 ? 2 : -1))));
    private Random random;
    @PersistenceContext
    EntityManager entityManager;
    @Inject
    SystemPropertiesRetriever systemPropertiesRetriever;

    public RosterGenerator() {
        this(null, new SystemPropertiesRetriever());
    }

    @Inject
    public RosterGenerator(EntityManager entityManager, SystemPropertiesRetriever systemPropertiesRetriever) {
        this.entityManager = entityManager;
        this.systemPropertiesRetriever = systemPropertiesRetriever;
        this.random = new Random(37L);
    }

    @Transactional
    public void run(@Observes StartupEvent event) {
        this.checkForExistingData();
    }

    @Transactional
    public void checkForExistingData() {
        List tenantList = this.entityManager.createQuery("select t from Tenant t").getResultList();
        if (!tenantList.isEmpty()) {
            return;
        }
        this.setUpGeneratedData();
    }

    @Transactional
    public void setUpGeneratedData() {
        ZoneId zoneId = this.systemPropertiesRetriever.determineZoneId();
        SystemPropertiesRetriever.InitialData initialData = this.systemPropertiesRetriever.determineInitialData();
        this.random = new Random(37L);
        switch (initialData) {
            case EMPTY: {
                return;
            }
            case DEMO_DATA: {
                this.tenantNameGenerator.predictMaximumSizeAndReset(12);
                this.generateRoster(10, 7, this.hospitalGeneratorType, zoneId);
                this.generateRoster(10, 7, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(10, 7, this.guardSecurityGeneratorType, zoneId);
                this.generateRoster(10, 7, this.callCenterGeneratorType, zoneId);
                this.generateRoster(10, 7, this.postOfficeGeneratorType, zoneId);
                this.generateRoster(10, 28, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(20, 28, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(40, 14, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(80, 28, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(10, 28, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(20, 28, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(40, 14, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(80, 28, this.factoryAssemblyGeneratorType, zoneId);
            }
        }
    }

    @Transactional
    public Roster generateRoster(int spotListSize, int lengthInDays, GeneratorType generatorType, ZoneId zoneId) {
        int maxShiftSizePerDay = generatorType.timeslotRangeList.size() + EXTRA_SHIFT_THRESHOLDS.length;
        int employeeListSize = spotListSize * maxShiftSizePerDay * 7 / 5;
        int skillListSize = (spotListSize + 4) / 5;
        Tenant tenant = this.createTenant(generatorType, employeeListSize);
        Integer tenantId = tenant.getId();
        RosterConstraintConfiguration rosterConstraintConfiguration = this.createTenantConfiguration(generatorType, tenantId, zoneId);
        RosterState rosterState = this.createRosterState(generatorType, tenant, zoneId, lengthInDays);
        List<Skill> skillList = this.createSkillList(generatorType, tenantId, skillListSize);
        List<Spot> spotList = this.createSpotList(generatorType, tenantId, spotListSize, skillList);
        List<Contract> contractList = this.createContractList(tenantId);
        List<Employee> employeeList = this.createEmployeeList(generatorType, tenantId, employeeListSize, contractList, skillList);
        List<TimeBucket> timeBucketList = this.createTimeBucketList(generatorType, tenantId, rosterConstraintConfiguration.getWeekStartDay(), rosterState, spotList, employeeList, skillList);
        List<Shift> shiftList = this.createShiftList(generatorType, tenantId, rosterConstraintConfiguration, rosterState, spotList, timeBucketList);
        List<EmployeeAvailability> employeeAvailabilityList = this.createEmployeeAvailabilityList(generatorType, tenantId, rosterConstraintConfiguration, rosterState, employeeList, shiftList);
        return new Roster((long)tenantId, tenantId, rosterConstraintConfiguration, skillList, spotList, employeeList, employeeAvailabilityList, rosterState, shiftList);
    }

    @Transactional
    public Roster generateRoster(int spotListSize, int lengthInDays) {
        ZoneId zoneId = this.systemPropertiesRetriever.determineZoneId();
        return this.generateRoster(spotListSize, lengthInDays, this.hospitalGeneratorType, zoneId);
    }

    @Transactional
    public Tenant createTenant(GeneratorType generatorType, int employeeListSize) {
        String tenantName = generatorType.tenantNamePrefix + " " + this.tenantNameGenerator.generateNextValue() + " (" + employeeListSize + " employees)";
        Tenant tenant = new Tenant(tenantName);
        this.entityManager.persist((Object)tenant);
        return tenant;
    }

    @Transactional
    public RosterConstraintConfiguration createTenantConfiguration(GeneratorType generatorType, Integer tenantId, ZoneId zoneId) {
        RosterConstraintConfiguration rosterConstraintConfiguration = new RosterConstraintConfiguration();
        rosterConstraintConfiguration.setTenantId(tenantId);
        this.entityManager.persist((Object)rosterConstraintConfiguration);
        return rosterConstraintConfiguration;
    }

    @Transactional
    public RosterState createRosterState(GeneratorType generatorType, Tenant tenant, ZoneId zoneId, int lengthInDays) {
        RosterState rosterState = new RosterState();
        rosterState.setTenantId(tenant.getId());
        int publishNotice = 14;
        rosterState.setPublishNotice(publishNotice);
        LocalDate firstDraftDate = LocalDate.now().with(TemporalAdjusters.next(DayOfWeek.MONDAY)).plusDays(publishNotice);
        rosterState.setFirstDraftDate(firstDraftDate);
        rosterState.setDraftLength(14);
        rosterState.setUnplannedRotationOffset(0);
        rosterState.setRotationLength(generatorType.rotationLength);
        rosterState.setLastHistoricDate(LocalDate.now().minusDays(1L));
        rosterState.setTimeZone(zoneId);
        rosterState.setTenant(tenant);
        this.entityManager.persist((Object)rosterState);
        return rosterState;
    }

    @Transactional
    public List<Skill> createSkillList(GeneratorType generatorType, Integer tenantId, int size) {
        ArrayList<Skill> skillList = new ArrayList<Skill>(size + 3);
        generatorType.skillNameGenerator.predictMaximumSizeAndReset(size);
        for (int i = 0; i < size; ++i) {
            String name = generatorType.skillNameGenerator.generateNextValue();
            Skill skill = new Skill(tenantId, name);
            this.entityManager.persist((Object)skill);
            skillList.add(skill);
        }
        return skillList;
    }

    @Transactional
    public List<Spot> createSpotList(GeneratorType generatorType, Integer tenantId, int size, List<Skill> skillList) {
        ArrayList<Spot> spotList = new ArrayList<Spot>(size);
        generatorType.spotNameGenerator.predictMaximumSizeAndReset(size);
        for (int i = 0; i < size; ++i) {
            String name = generatorType.spotNameGenerator.generateNextValue();
            HashSet<Skill> requiredSkillSet = new HashSet<Skill>(this.extractRandomSubList(skillList, 0.5, 0.9, 1.0));
            Spot spot = new Spot(tenantId, name, requiredSkillSet);
            this.entityManager.persist((Object)spot);
            spotList.add(spot);
        }
        return spotList;
    }

    @Transactional
    public List<Contract> createContractList(Integer tenantId) {
        ArrayList<Contract> contractList = new ArrayList<Contract>(3);
        Contract contract = new Contract(tenantId, "Part Time Contract");
        this.entityManager.persist((Object)contract);
        contractList.add(contract);
        contract = new Contract(tenantId, "Max 16 Hours Per Week Contract", null, 960, null, null);
        this.entityManager.persist((Object)contract);
        contractList.add(contract);
        contract = new Contract(tenantId, "Max 16 Hours Per Week, 32 Hours Per Month Contract", null, 960, 1920, null);
        this.entityManager.persist((Object)contract);
        contractList.add(contract);
        return contractList;
    }

    @Transactional
    public List<Employee> createEmployeeList(GeneratorType generatorType, Integer tenantId, int size, List<Contract> contractList, List<Skill> generalSkillList) {
        ArrayList<Employee> employeeList = new ArrayList<Employee>(size);
        this.employeeNameGenerator.predictMaximumSizeAndReset(size);
        for (int i = 0; i < size; ++i) {
            String name = this.employeeNameGenerator.generateNextValue();
            HashSet<Skill> skillProficiencySet = new HashSet<Skill>(this.extractRandomSubList(generalSkillList, 0.1, 0.3, 0.5, 0.7, 0.9, 1.0));
            Employee employee = new Employee(tenantId, name, contractList.get(this.generateRandomIntFromThresholds(0.7, 0.5)), skillProficiencySet);
            this.entityManager.persist((Object)employee);
            employeeList.add(employee);
        }
        return employeeList;
    }

    @Transactional
    public List<TimeBucket> createTimeBucketList(GeneratorType generatorType, Integer tenantId, DayOfWeek startOfWeek, RosterState rosterState, List<Spot> spotList, List<Employee> employeeList, List<Skill> skillList) {
        ArrayList<TimeBucket> timeBucketList = new ArrayList<TimeBucket>(spotList.size() * generatorType.timeslotRangeList.size());
        ArrayList<Employee> remainingEmployeeList = new ArrayList<Employee>(employeeList);
        Consumer<Spot> createTimeBucketsForSpot = spot -> {
            Function<Predicate, List> findEmployees = p -> {
                List out = remainingEmployeeList.stream().filter(employee -> employee.getSkillProficiencySet().containsAll(spot.getRequiredSkillSet()) && employee.getContract().getMaximumMinutesPerWeek() == null && p.test(employee)).limit(generatorType.rotationEmployeeListSize).collect(Collectors.toList());
                remainingEmployeeList.removeAll(out);
                return out;
            };
            List rotationEmployeeList = findEmployees.apply(t -> true);
            for (int timeslotRangesIndex = 0; timeslotRangesIndex < generatorType.timeslotRangeList.size(); ++timeslotRangesIndex) {
                timeBucketList.add(this.getTimeBucketForTimeslotRangeListTriple(timeslotRangesIndex, tenantId, (Spot)spot, generatorType, startOfWeek, rosterState, rotationEmployeeList));
            }
        };
        spotList.stream().forEach(createTimeBucketsForSpot);
        return timeBucketList;
    }

    private TimeBucket getTimeBucketForTimeslotRangeListTriple(int timeslotRangesIndex, int tenantId, Spot spot, GeneratorType generatorType, DayOfWeek startOfWeek, RosterState rosterState, List<Employee> rotationEmployeeList) {
        Triple<LocalTime, LocalTime, List<DayOfWeek>> tr = generatorType.timeslotRangeList.get(timeslotRangesIndex);
        Set repeatDays = ((List)tr.getRight()).stream().collect(Collectors.toCollection(HashSet::new));
        ArrayList<Seat> seatList = new ArrayList<Seat>(rosterState.getRotationLength());
        for (int dayOffset = 0; dayOffset < rosterState.getRotationLength(); ++dayOffset) {
            DayOfWeek dayOfWeek = startOfWeek.plus(dayOffset);
            if (!repeatDays.contains(dayOfWeek)) continue;
            int rotationEmployeeIndex = generatorType.rotationEmployeeIndexCalculator.apply(dayOffset, timeslotRangesIndex);
            if (rotationEmployeeIndex < 0 || rotationEmployeeIndex >= generatorType.rotationEmployeeListSize) {
                throw new IllegalStateException("The rotationEmployeeIndexCalculator for generatorType (" + generatorType.tenantNamePrefix + ") returns an invalid rotationEmployeeIndex (" + rotationEmployeeIndex + ") for startDayOffset (" + dayOffset + ") and timeslotRangesIndex (" + timeslotRangesIndex + ").");
            }
            Employee rotationEmployee = rotationEmployeeIndex >= rotationEmployeeList.size() ? null : rotationEmployeeList.get(rotationEmployeeIndex);
            seatList.add(new Seat(dayOffset, rotationEmployee));
        }
        TimeBucket timeBucket = new TimeBucket(tenantId, spot, (LocalTime)tr.getLeft(), (LocalTime)tr.getMiddle(), new HashSet<Skill>(), repeatDays, seatList);
        this.entityManager.persist((Object)timeBucket);
        return timeBucket;
    }

    @Transactional
    public List<Shift> createShiftList(GeneratorType generatorType, Integer tenantId, RosterConstraintConfiguration rosterConstraintConfiguration, RosterState rosterState, List<Spot> spotList, List<TimeBucket> timeBucketList) {
        int rotationLength = rosterState.getRotationLength();
        LocalDate nextDate = rosterState.getLastHistoricDate().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDate firstUnplannedDate = rosterState.getFirstUnplannedDate();
        ArrayList<Shift> shiftList = new ArrayList<Shift>();
        int nextDayOffset = 0;
        while (nextDate.compareTo(firstUnplannedDate) < 0) {
            LocalDate date = nextDate;
            int dayOffset = nextDayOffset;
            spotList.forEach(spot -> shiftList.addAll(this.generateShiftsForSpotOnDate(generatorType, tenantId, rosterConstraintConfiguration, rosterState, (Spot)spot, date, dayOffset, timeBucketList)));
            nextDate = date.plusDays(1L);
            nextDayOffset = (dayOffset + 1) % rotationLength;
        }
        rosterState.setUnplannedRotationOffset(nextDayOffset);
        return shiftList;
    }

    private List<Shift> generateShiftsForSpotOnDate(GeneratorType generatorType, Integer tenantId, RosterConstraintConfiguration rosterConstraintConfiguration, RosterState rosterState, Spot spot, LocalDate date, int rotationDay, List<TimeBucket> timeBucketList) {
        ArrayList<Shift> shiftList = new ArrayList<Shift>();
        LocalDate firstDraftDate = rosterState.getFirstDraftDate();
        ZoneId zoneId = rosterState.getTimeZone();
        List<TimeBucket> spotTimeBucketList = timeBucketList.stream().filter(tb -> tb.getSpot().equals(spot)).collect(Collectors.toList());
        spotTimeBucketList.forEach(timeBucket -> {
            boolean defaultToRotationEmployee = date.compareTo(firstDraftDate) < 0;
            Optional<Shift> maybeShift = timeBucket.createShiftForOffset(date, rotationDay, zoneId, defaultToRotationEmployee);
            maybeShift.ifPresent(shift -> {
                if (date.compareTo(firstDraftDate) < 0 && defaultToRotationEmployee) {
                    shift.setOriginalEmployee(shift.getRotationEmployee());
                }
                this.entityManager.persist(shift);
                shiftList.add((Shift)shift);
            });
        });
        if (date.compareTo(firstDraftDate) >= 0 && !spotTimeBucketList.isEmpty()) {
            int extraShiftCount = this.generateRandomIntFromThresholds(EXTRA_SHIFT_THRESHOLDS);
            for (int i = 0; i < extraShiftCount; ++i) {
                TimeBucket timeBucket2 = (TimeBucket)this.extractRandomElement(spotTimeBucketList);
                Optional<Shift> maybeShift = timeBucket2.createShiftForOffset(date, rotationDay, zoneId, false);
                maybeShift.ifPresent(shift -> {
                    this.entityManager.persist(shift);
                    shiftList.add((Shift)shift);
                });
            }
        }
        return shiftList;
    }

    @Transactional
    public List<EmployeeAvailability> createEmployeeAvailabilityList(GeneratorType generatorType, Integer tenantId, RosterConstraintConfiguration rosterConstraintConfiguration, RosterState rosterState, List<Employee> employeeList, List<Shift> shiftList) {
        ZoneId zoneId = rosterState.getTimeZone();
        LocalDate date = rosterState.getFirstDraftDate().plusDays(1L);
        LocalDate firstUnplannedDate = rosterState.getFirstUnplannedDate();
        ArrayList<EmployeeAvailability> employeeAvailabilityList = new ArrayList<EmployeeAvailability>();
        Map<LocalDate, List<Shift>> startDayToShiftListMap = shiftList.stream().collect(Collectors.groupingBy(shift -> shift.getStartDateTime().toLocalDate()));
        while (date.compareTo(firstUnplannedDate) < 0) {
            List dayShiftList = startDayToShiftListMap.getOrDefault(date, Collections.emptyList());
            ArrayList<Employee> availableEmployeeList = new ArrayList<Employee>(employeeList);
            int stateCount = (employeeList.size() - dayShiftList.size()) / 4;
            if (stateCount <= 0) {
                stateCount = 1;
            }
            for (EmployeeAvailabilityState state : EmployeeAvailabilityState.values()) {
                for (int i = 0; i < stateCount; ++i) {
                    Employee employee = (Employee)availableEmployeeList.remove(this.random.nextInt(availableEmployeeList.size()));
                    LocalDateTime startDateTime = date.atTime(LocalTime.MIN);
                    LocalDateTime endDateTime = date.plusDays(1L).atTime(LocalTime.MIN);
                    OffsetDateTime startOffsetDateTime = OffsetDateTime.of(startDateTime, zoneId.getRules().getOffset(startDateTime));
                    OffsetDateTime endOffsetDateTime = OffsetDateTime.of(endDateTime, zoneId.getRules().getOffset(endDateTime));
                    EmployeeAvailability employeeAvailability = new EmployeeAvailability(tenantId, employee, startOffsetDateTime, endOffsetDateTime);
                    employeeAvailability.setState(state);
                    this.entityManager.persist((Object)employeeAvailability);
                    employeeAvailabilityList.add(employeeAvailability);
                }
            }
            date = date.plusDays(1L);
        }
        return employeeAvailabilityList;
    }

    private <E> E extractRandomElement(List<E> list) {
        return list.get(this.random.nextInt(list.size()));
    }

    private <E> List<E> extractRandomSubList(List<E> list, double ... thresholds) {
        int size = this.generateRandomIntFromThresholds(thresholds);
        if (size > list.size()) {
            size = list.size();
        }
        return this.extractRandomSubListOfSize(list, size);
    }

    private <E> List<E> extractRandomSubListOfSize(List<E> list, int size) {
        ArrayList<E> subList = new ArrayList<E>(list);
        Collections.shuffle(subList, this.random);
        subList.subList(size, subList.size()).clear();
        return subList;
    }

    private int generateRandomIntFromThresholds(double ... thresholds) {
        double randomDouble = this.random.nextDouble();
        for (int i = 0; i < thresholds.length; ++i) {
            if (!(randomDouble < thresholds[i])) continue;
            return i;
        }
        return thresholds.length;
    }

    public static class GeneratorType {
        public final String tenantNamePrefix;
        public final StringDataGenerator skillNameGenerator;
        public final StringDataGenerator spotNameGenerator;
        public final List<Triple<LocalTime, LocalTime, List<DayOfWeek>>> timeslotRangeList;
        public final int rotationLength;
        public final int rotationEmployeeListSize;
        public final BiFunction<Integer, Integer, Integer> rotationEmployeeIndexCalculator;

        public GeneratorType(String tenantNamePrefix, StringDataGenerator skillNameGenerator, StringDataGenerator spotNameGenerator, List<Triple<LocalTime, LocalTime, List<DayOfWeek>>> timeslotRangeList, int rotationLength, int rotationEmployeeListSize, BiFunction<Integer, Integer, Integer> rotationEmployeeIndexCalculator) {
            this.tenantNamePrefix = tenantNamePrefix;
            this.skillNameGenerator = skillNameGenerator;
            this.spotNameGenerator = spotNameGenerator;
            this.timeslotRangeList = timeslotRangeList;
            this.rotationLength = rotationLength;
            this.rotationEmployeeListSize = rotationEmployeeListSize;
            this.rotationEmployeeIndexCalculator = rotationEmployeeIndexCalculator;
        }
    }
}

