/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.classloader.ClassDefiner;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingClass;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingMetadata;
import io.smallrye.config.ConfigMappingObject;
import io.smallrye.config.ConfigMessages;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.inject.ConfigProperties;

public final class ConfigMappingLoader {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final ConcurrentHashMap<String, Object> classLoaderLocks = new ConcurrentHashMap();
    private static final ClassValue<ConfigMappingObjectHolder> CACHE = new ClassValue<ConfigMappingObjectHolder>(){

        @Override
        protected ConfigMappingObjectHolder computeValue(Class<?> type) {
            return new ConfigMappingObjectHolder(ConfigMappingLoader.getImplementationClass(type));
        }
    };

    public static List<ConfigMappingMetadata> getConfigMappingsMetadata(Class<?> type) {
        ConfigMappingClass configMappingClass;
        ArrayList<ConfigMappingMetadata> mappings = new ArrayList<ConfigMappingMetadata>();
        ConfigMappingInterface configurationInterface = ConfigMappingInterface.getConfigurationInterface(type);
        if (configurationInterface != null) {
            mappings.add(configurationInterface);
            mappings.addAll(configurationInterface.getNested());
            for (ConfigMappingInterface superType : configurationInterface.getSuperTypes()) {
                mappings.add(superType);
                mappings.addAll(superType.getNested());
            }
        }
        if ((configMappingClass = ConfigMappingClass.getConfigurationClass(type)) != null) {
            mappings.add(configMappingClass);
            mappings.addAll(ConfigMappingLoader.getConfigMappingsMetadata(ConfigMappingLoader.getConfigMappingInterface(type).getInterfaceType()));
        }
        return mappings;
    }

    static ConfigMappingInterface getConfigMappingInterface(Class<?> type) {
        return ConfigMappingInterface.getConfigurationInterface(ConfigMappingLoader.getConfigMappingClass(type));
    }

    static Class<?> getConfigMappingClass(Class<?> type) {
        ConfigMappingLoader.validateAnnotations(type);
        ConfigMappingClass configMappingClass = ConfigMappingClass.getConfigurationClass(type);
        if (configMappingClass == null) {
            return type;
        }
        return ConfigMappingLoader.loadClass(type, configMappingClass);
    }

    static <T> T configMappingObject(Class<T> interfaceType, ConfigMappingContext configMappingContext) {
        ConfigMappingObject instance;
        try {
            Constructor<? extends ConfigMappingObject> constructor = CACHE.get(interfaceType).getImplementationClass().getDeclaredConstructor(ConfigMappingContext.class);
            instance = constructor.newInstance(configMappingContext);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        return interfaceType.cast(instance);
    }

    public static <T> Class<? extends ConfigMappingObject> getImplementationClass(Class<T> type) {
        ConfigMappingInterface mappingMetadata = ConfigMappingInterface.getConfigurationInterface(type);
        if (mappingMetadata == null) {
            throw ConfigMessages.msg.classIsNotAMapping(type);
        }
        return ConfigMappingLoader.loadClass(type, mappingMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class<?> loadClass(Class<?> parent, ConfigMappingMetadata configMappingMetadata) {
        Object object = ConfigMappingLoader.getClassLoaderLock(configMappingMetadata.getClassName());
        synchronized (object) {
            try {
                Class<?> klass = parent.getClassLoader().loadClass(configMappingMetadata.getClassName());
                if (parent.isAssignableFrom(klass)) {
                    return klass;
                }
                if (configMappingMetadata instanceof ConfigMappingClass) {
                    return klass;
                }
                return ConfigMappingLoader.defineClass(parent, configMappingMetadata.getClassName(), configMappingMetadata.getClassBytes());
            }
            catch (ClassNotFoundException e) {
                return ConfigMappingLoader.defineClass(parent, configMappingMetadata.getClassName(), configMappingMetadata.getClassBytes());
            }
        }
    }

    static void validateAnnotations(Class<?> type) {
        if (!type.isInterface() && type.isAnnotationPresent(ConfigMapping.class)) {
            throw ConfigMessages.msg.mappingAnnotationNotSupportedInClass(type);
        }
        if (type.isInterface() && type.isAnnotationPresent(ConfigProperties.class)) {
            throw ConfigMessages.msg.propertiesAnnotationNotSupportedInInterface(type);
        }
    }

    private static Class<?> defineClass(Class<?> parent, String className, byte[] classBytes) {
        return ClassDefiner.defineClass((MethodHandles.Lookup)LOOKUP, parent, (String)className, (byte[])classBytes);
    }

    private static Object getClassLoaderLock(String className) {
        return classLoaderLocks.computeIfAbsent(className, c -> new Object());
    }

    private static final class ConfigMappingObjectHolder {
        private final Class<? extends ConfigMappingObject> implementationClass;

        ConfigMappingObjectHolder(Class<? extends ConfigMappingObject> implementationClass) {
            this.implementationClass = implementationClass;
        }

        public Class<? extends ConfigMappingObject> getImplementationClass() {
            return this.implementationClass;
        }
    }
}

