/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.logging.Logger;

abstract class AbstractInstanceHandle<T>
implements InstanceHandle<T> {
    private static final Logger LOGGER = Logger.getLogger((String)AbstractInstanceHandle.class.getName());
    private static final AtomicIntegerFieldUpdater<AbstractInstanceHandle> DESTROYED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractInstanceHandle.class, "destroyed");
    private final InjectableBean<T> bean;
    private final CreationalContext<T> creationalContext;
    private final CreationalContext<?> parentCreationalContext;
    private final Consumer<T> destroyLogic;
    private volatile int destroyed;

    AbstractInstanceHandle(InjectableBean<T> bean, CreationalContext<T> creationalContext, CreationalContext<?> parentCreationalContext, Consumer<T> destroyLogic) {
        this.bean = bean;
        this.creationalContext = creationalContext;
        this.parentCreationalContext = parentCreationalContext;
        this.destroyLogic = destroyLogic;
    }

    @Override
    public T get() {
        if (this.destroyed != 0) {
            throw new IllegalStateException("Instance already destroyed");
        }
        return this.instanceInternal();
    }

    @Override
    public InjectableBean<T> getBean() {
        return this.bean;
    }

    protected abstract boolean isInstanceCreated();

    protected abstract T instanceInternal();

    @Override
    public void destroy() {
        if (this.isInstanceCreated() && DESTROYED_UPDATER.compareAndSet(this, 0, 1)) {
            if (this.destroyLogic != null) {
                this.destroyLogic.accept(this.instanceInternal());
            } else if (this.bean.getScope().equals(Dependent.class)) {
                this.destroyInternal();
            } else {
                InjectableContext context = Arc.container().getActiveContext(this.bean.getScope());
                if (context == null) {
                    throw new ContextNotActiveException("Cannot destroy instance of " + this.bean + " - no active context found for: " + this.bean.getScope());
                }
                context.destroy((Contextual)this.bean);
            }
        }
    }

    protected void destroyInternal() {
        if (this.parentCreationalContext != null) {
            this.parentCreationalContext.release();
        } else {
            try {
                this.bean.destroy(this.instanceInternal(), this.creationalContext);
            }
            catch (Throwable t) {
                String msg = "Error occurred while destroying instance of bean [%s]";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.errorf(t, msg, (Object)this.bean.getClass().getName());
                }
                LOGGER.errorf(msg + ": %s", (Object)this.bean.getClass().getName(), (Object)t);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [bean=" + this.bean + ", destroyed=" + (this.destroyed != 0) + "]";
    }
}

