/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.contract;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"tenantId", "name"}), @UniqueConstraint(columnNames={"id"})})
public class Contract
extends AbstractPersistable
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    @NotNull
    @Size(min=1, max=120)
    @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces")
    private @NotNull @Size(min=1, max=120) @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces") String name;
    @Min(value=0L)
    @Max(value=1440L)
    private @Min(value=0L) @Max(value=1440L) Integer maximumMinutesPerDay;
    @Min(value=0L)
    @Max(value=10080L)
    private @Min(value=0L) @Max(value=10080L) Integer maximumMinutesPerWeek;
    @Min(value=0L)
    @Max(value=44640L)
    private @Min(value=0L) @Max(value=44640L) Integer maximumMinutesPerMonth;
    @Min(value=0L)
    @Max(value=527040L)
    private @Min(value=0L) @Max(value=527040L) Integer maximumMinutesPerYear;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public Contract() {
    }

    public Contract(Integer tenantId, String name) {
        this(tenantId, name, null, null, null, null);
    }

    public Contract(Integer tenantId, String name, Integer maximumMinutesPerDay, Integer maximumMinutesPerWeek, Integer maximumMinutesPerMonth, Integer maximumMinutesPerYear) {
        super(tenantId);
        this.$$_hibernate_write_name(name);
        this.$$_hibernate_write_maximumMinutesPerDay(maximumMinutesPerDay);
        this.$$_hibernate_write_maximumMinutesPerWeek(maximumMinutesPerWeek);
        this.$$_hibernate_write_maximumMinutesPerMonth(maximumMinutesPerMonth);
        this.$$_hibernate_write_maximumMinutesPerYear(maximumMinutesPerYear);
    }

    @AssertTrue
    @JsonIgnore
    public boolean isValid() {
        if (this.$$_hibernate_read_maximumMinutesPerDay() != null && this.$$_hibernate_read_maximumMinutesPerDay() <= 0) {
            return false;
        }
        if (this.$$_hibernate_read_maximumMinutesPerWeek() != null && this.$$_hibernate_read_maximumMinutesPerWeek() <= 0) {
            return false;
        }
        if (this.$$_hibernate_read_maximumMinutesPerMonth() != null && this.$$_hibernate_read_maximumMinutesPerMonth() <= 0) {
            return false;
        }
        return this.$$_hibernate_read_maximumMinutesPerYear() == null || this.$$_hibernate_read_maximumMinutesPerYear() > 0;
    }

    @Override
    public String toString() {
        return this.$$_hibernate_read_name();
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_write_name(name);
    }

    public Integer getMaximumMinutesPerDay() {
        return this.$$_hibernate_read_maximumMinutesPerDay();
    }

    public void setMaximumMinutesPerDay(Integer maximumMinutesPerDay) {
        this.$$_hibernate_write_maximumMinutesPerDay(maximumMinutesPerDay);
    }

    public Integer getMaximumMinutesPerWeek() {
        return this.$$_hibernate_read_maximumMinutesPerWeek();
    }

    public void setMaximumMinutesPerWeek(Integer maximumMinutesPerWeek) {
        this.$$_hibernate_write_maximumMinutesPerWeek(maximumMinutesPerWeek);
    }

    public Integer getMaximumMinutesPerMonth() {
        return this.$$_hibernate_read_maximumMinutesPerMonth();
    }

    public void setMaximumMinutesPerMonth(Integer maximumMinutesPerMonth) {
        this.$$_hibernate_write_maximumMinutesPerMonth(maximumMinutesPerMonth);
    }

    public Integer getMaximumMinutesPerYear() {
        return this.$$_hibernate_read_maximumMinutesPerYear();
    }

    public void setMaximumMinutesPerYear(Integer maximumMinutesPerYear) {
        this.$$_hibernate_write_maximumMinutesPerYear(maximumMinutesPerYear);
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        Contract contract = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        Contract contract = this;
        contract = null;
        contract = NoopCollectionTracker.INSTANCE;
        return contract;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!Objects.deepEquals(string, this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public Integer $$_hibernate_read_maximumMinutesPerDay() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.maximumMinutesPerDay = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "maximumMinutesPerDay", (Object)this.maximumMinutesPerDay);
        }
        return this.maximumMinutesPerDay;
    }

    public void $$_hibernate_write_maximumMinutesPerDay(Integer n) {
        if (!Objects.deepEquals(n, this.maximumMinutesPerDay)) {
            this.$$_hibernate_trackChange("maximumMinutesPerDay");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.maximumMinutesPerDay = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "maximumMinutesPerDay", (Object)this.maximumMinutesPerDay, (Object)n);
            return;
        }
        this.maximumMinutesPerDay = n;
    }

    public Integer $$_hibernate_read_maximumMinutesPerWeek() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.maximumMinutesPerWeek = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "maximumMinutesPerWeek", (Object)this.maximumMinutesPerWeek);
        }
        return this.maximumMinutesPerWeek;
    }

    public void $$_hibernate_write_maximumMinutesPerWeek(Integer n) {
        if (!Objects.deepEquals(n, this.maximumMinutesPerWeek)) {
            this.$$_hibernate_trackChange("maximumMinutesPerWeek");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.maximumMinutesPerWeek = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "maximumMinutesPerWeek", (Object)this.maximumMinutesPerWeek, (Object)n);
            return;
        }
        this.maximumMinutesPerWeek = n;
    }

    public Integer $$_hibernate_read_maximumMinutesPerMonth() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.maximumMinutesPerMonth = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "maximumMinutesPerMonth", (Object)this.maximumMinutesPerMonth);
        }
        return this.maximumMinutesPerMonth;
    }

    public void $$_hibernate_write_maximumMinutesPerMonth(Integer n) {
        if (!Objects.deepEquals(n, this.maximumMinutesPerMonth)) {
            this.$$_hibernate_trackChange("maximumMinutesPerMonth");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.maximumMinutesPerMonth = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "maximumMinutesPerMonth", (Object)this.maximumMinutesPerMonth, (Object)n);
            return;
        }
        this.maximumMinutesPerMonth = n;
    }

    public Integer $$_hibernate_read_maximumMinutesPerYear() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.maximumMinutesPerYear = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "maximumMinutesPerYear", (Object)this.maximumMinutesPerYear);
        }
        return this.maximumMinutesPerYear;
    }

    public void $$_hibernate_write_maximumMinutesPerYear(Integer n) {
        if (!Objects.deepEquals(n, this.maximumMinutesPerYear)) {
            this.$$_hibernate_trackChange("maximumMinutesPerYear");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.maximumMinutesPerYear = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "maximumMinutesPerYear", (Object)this.maximumMinutesPerYear, (Object)n);
            return;
        }
        this.maximumMinutesPerYear = n;
    }

    @Override
    public Long $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_id((Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)super.$$_hibernate_read_id()));
        }
        return super.$$_hibernate_read_id();
    }

    @Override
    public void $$_hibernate_write_id(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_id((Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)super.$$_hibernate_read_id(), (Object)l));
            return;
        }
        super.$$_hibernate_write_id(l);
    }

    @Override
    public Integer $$_hibernate_read_tenantId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_tenantId((Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "tenantId", (Object)super.$$_hibernate_read_tenantId()));
        }
        return super.$$_hibernate_read_tenantId();
    }

    @Override
    public void $$_hibernate_write_tenantId(Integer n) {
        if (!Objects.deepEquals(n, ((AbstractPersistable)this).$$_hibernate_read_tenantId())) {
            this.$$_hibernate_trackChange("tenantId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_tenantId((Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "tenantId", (Object)super.$$_hibernate_read_tenantId(), (Object)n));
            return;
        }
        super.$$_hibernate_write_tenantId(n);
    }

    @Override
    public Long $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_version((Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "version", (Object)super.$$_hibernate_read_version()));
        }
        return super.$$_hibernate_read_version();
    }

    @Override
    public void $$_hibernate_write_version(Long l) {
        if (!Objects.deepEquals(l, ((AbstractPersistable)this).$$_hibernate_read_version())) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_version((Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "version", (Object)super.$$_hibernate_read_version(), (Object)l));
            return;
        }
        super.$$_hibernate_write_version(l);
    }
}

