/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.shift;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.optaweb.employeerostering.domain.shift.view.ShiftView;
import org.optaweb.employeerostering.service.shift.ShiftService;

@Path(value="/rest/tenant/{tenantId}/shift")
@ApplicationScoped
@Tag(name="Shift")
public class ShiftController {
    private final ShiftService shiftService;

    public ShiftController() {
    }

    @Inject
    public ShiftController(ShiftService shiftService) {
        this.shiftService = shiftService;
    }

    @GET
    @Path(value="/")
    @Operation(summary="List Shifts", description="Get a list of all shifts")
    public List<ShiftView> getShiftList(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return this.shiftService.getShiftList(tenantId);
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get Shift", description="Gets a shift by id")
    public ShiftView getShift(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @PathParam(value="id") @Min(value=0L) @Min(value=0L) Long id) {
        return this.shiftService.getShift(tenantId, id);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(summary="Delete Shift", description="Deletes a shift by id")
    public Boolean deleteShift(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @PathParam(value="id") @Min(value=0L) @Min(value=0L) Long id) {
        return this.shiftService.deleteShift(tenantId, id);
    }

    @POST
    @Path(value="/add")
    @Operation(summary="Add Shift", description="Adds a new shift")
    public ShiftView createShift(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @Valid ShiftView shiftView) {
        return this.shiftService.createShift(tenantId, shiftView);
    }

    @PUT
    @Path(value="/update")
    @Operation(summary="Update Shift", description="Updates a shift")
    public ShiftView updateShift(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @Valid ShiftView shiftView) {
        return this.shiftService.updateShift(tenantId, shiftView);
    }
}

