/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools.tri;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.Function;
import org.optaplanner.constraint.streams.common.RetrievalSemantics;
import org.optaplanner.constraint.streams.common.ScoreImpactType;
import org.optaplanner.constraint.streams.common.quad.QuadJoinerComber;
import org.optaplanner.constraint.streams.common.tri.InnerTriConstraintStream;
import org.optaplanner.constraint.streams.drools.DroolsConstraintFactory;
import org.optaplanner.constraint.streams.drools.bi.DroolsGroupingBiConstraintStream;
import org.optaplanner.constraint.streams.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.constraint.streams.drools.common.RuleBuilder;
import org.optaplanner.constraint.streams.drools.common.TriLeftHandSide;
import org.optaplanner.constraint.streams.drools.quad.DroolsGroupingQuadConstraintStream;
import org.optaplanner.constraint.streams.drools.quad.DroolsJoinQuadConstraintStream;
import org.optaplanner.constraint.streams.drools.tri.DroolsExistsTriConstraintStream;
import org.optaplanner.constraint.streams.drools.tri.DroolsFilterTriConstraintStream;
import org.optaplanner.constraint.streams.drools.tri.DroolsFlatteningTriConstraintStream;
import org.optaplanner.constraint.streams.drools.tri.DroolsGroupingTriConstraintStream;
import org.optaplanner.constraint.streams.drools.uni.DroolsAbstractUniConstraintStream;
import org.optaplanner.constraint.streams.drools.uni.DroolsGroupingUniConstraintStream;
import org.optaplanner.constraint.streams.drools.uni.DroolsMappingUniConstraintStream;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;

public abstract class DroolsAbstractTriConstraintStream<Solution_, A, B, C>
extends DroolsAbstractConstraintStream<Solution_>
implements InnerTriConstraintStream<A, B, C> {
    public DroolsAbstractTriConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, RetrievalSemantics retrievalSemantics) {
        super(constraintFactory, retrievalSemantics);
    }

    public TriConstraintStream<A, B, C> filter(TriPredicate<A, B, C> predicate) {
        DroolsFilterTriConstraintStream stream = new DroolsFilterTriConstraintStream(this.constraintFactory, this, predicate);
        this.addChildStream(stream);
        return stream;
    }

    @SafeVarargs
    public final <D> QuadConstraintStream<A, B, C, D> join(UniConstraintStream<D> otherStream, QuadJoiner<A, B, C, D> ... joiners) {
        QuadJoinerComber joinerComber = QuadJoinerComber.comb(joiners);
        DroolsJoinQuadConstraintStream stream = new DroolsJoinQuadConstraintStream(this.constraintFactory, this, (DroolsAbstractUniConstraintStream)otherStream, joinerComber.getMergedJoiner());
        this.addChildStream(stream);
        if (joinerComber.getMergedFiltering() == null) {
            return stream;
        }
        return stream.filter(joinerComber.getMergedFiltering());
    }

    @SafeVarargs
    public final <D> TriConstraintStream<A, B, C> ifExists(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        return this.ifExistsOrNot(true, this.getRetrievalSemantics() != RetrievalSemantics.STANDARD, otherClass, joiners);
    }

    @SafeVarargs
    public final <D> TriConstraintStream<A, B, C> ifExistsIncludingNullVars(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        return this.ifExistsOrNot(true, true, otherClass, joiners);
    }

    @SafeVarargs
    public final <D> TriConstraintStream<A, B, C> ifNotExists(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        return this.ifExistsOrNot(false, this.getRetrievalSemantics() != RetrievalSemantics.STANDARD, otherClass, joiners);
    }

    @SafeVarargs
    public final <D> TriConstraintStream<A, B, C> ifNotExistsIncludingNullVars(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        return this.ifExistsOrNot(false, true, otherClass, joiners);
    }

    @SafeVarargs
    private <D> TriConstraintStream<A, B, C> ifExistsOrNot(boolean shouldExist, boolean shouldIncludeNullVars, Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        this.getConstraintFactory().assertValidFromType(otherClass);
        DroolsExistsTriConstraintStream stream = new DroolsExistsTriConstraintStream(this.constraintFactory, this, shouldExist, shouldIncludeNullVars, otherClass, joiners);
        this.addChildStream(stream);
        return stream;
    }

    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(TriConstraintCollector<A, B, C, ResultContainer_, Result_> collector) {
        DroolsGroupingUniConstraintStream stream = new DroolsGroupingUniConstraintStream(this.constraintFactory, this, collector);
        this.addChildStream(stream);
        return stream;
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_> BiConstraintStream<ResultA_, ResultB_> groupBy(TriConstraintCollector<A, B, C, ResultContainerA_, ResultA_> collectorA, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> collectorB) {
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, collectorA, collectorB);
        this.addChildStream(stream);
        return stream;
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<ResultA_, ResultB_, ResultC_> groupBy(TriConstraintCollector<A, B, C, ResultContainerA_, ResultA_> collectorA, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> collectorB, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> collectorC) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, collectorA, collectorB, collectorC);
        this.addChildStream(stream);
        return stream;
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> groupBy(TriConstraintCollector<A, B, C, ResultContainerA_, ResultA_> collectorA, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> collectorB, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> collectorC, TriConstraintCollector<A, B, C, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, collectorA, collectorB, collectorC, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(TriFunction<A, B, C, GroupKey_> groupKeyMapping) {
        DroolsGroupingUniConstraintStream stream = new DroolsGroupingUniConstraintStream(this.constraintFactory, this, groupKeyMapping);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(TriFunction<A, B, C, GroupKey_> groupKeyMapping, TriConstraintCollector<A, B, C, ResultContainer_, Result_> collector) {
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, groupKeyMapping, collector);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<GroupKey_, ResultB_, ResultC_> groupBy(TriFunction<A, B, C, GroupKey_> groupKeyMapping, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> collectorB, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> collectorC) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, groupKeyMapping, collectorB, collectorC);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKey_, ResultB_, ResultC_, ResultD_> groupBy(TriFunction<A, B, C, GroupKey_> groupKeyMapping, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> collectorB, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> collectorC, TriConstraintCollector<A, B, C, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyMapping, collectorB, collectorC, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(TriFunction<A, B, C, GroupKeyA_> groupKeyAMapping, TriFunction<A, B, C, GroupKeyB_> groupKeyBMapping) {
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(TriFunction<A, B, C, GroupKeyA_> groupKeyAMapping, TriFunction<A, B, C, GroupKeyB_> groupKeyBMapping, TriConstraintCollector<A, B, C, ResultContainer_, Result_> collector) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, collector);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(TriFunction<A, B, C, GroupKeyA_> groupKeyAMapping, TriFunction<A, B, C, GroupKeyB_> groupKeyBMapping, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> collectorC, TriConstraintCollector<A, B, C, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, collectorC, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_> TriConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_> groupBy(TriFunction<A, B, C, GroupKeyA_> groupKeyAMapping, TriFunction<A, B, C, GroupKeyB_> groupKeyBMapping, TriFunction<A, B, C, GroupKeyC_> groupKeyCMapping) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, groupKeyCMapping);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultD_> groupBy(TriFunction<A, B, C, GroupKeyA_> groupKeyAMapping, TriFunction<A, B, C, GroupKeyB_> groupKeyBMapping, TriFunction<A, B, C, GroupKeyC_> groupKeyCMapping, TriConstraintCollector<A, B, C, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, groupKeyCMapping, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> groupBy(TriFunction<A, B, C, GroupKeyA_> groupKeyAMapping, TriFunction<A, B, C, GroupKeyB_> groupKeyBMapping, TriFunction<A, B, C, GroupKeyC_> groupKeyCMapping, TriFunction<A, B, C, GroupKeyD_> groupKeyDMapping) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, groupKeyCMapping, groupKeyDMapping);
        this.addChildStream(stream);
        return stream;
    }

    public <ResultA_> UniConstraintStream<ResultA_> map(TriFunction<A, B, C, ResultA_> mapping) {
        DroolsMappingUniConstraintStream stream = new DroolsMappingUniConstraintStream(this.constraintFactory, this, Objects.requireNonNull(mapping));
        this.addChildStream(stream);
        return stream;
    }

    public <ResultC_> TriConstraintStream<A, B, ResultC_> flattenLast(Function<C, Iterable<ResultC_>> mapping) {
        DroolsFlatteningTriConstraintStream stream = new DroolsFlatteningTriConstraintStream(this.constraintFactory, this, Objects.requireNonNull(mapping));
        this.addChildStream(stream);
        return stream;
    }

    protected Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate();
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, ruleBuilder);
    }

    public Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntTriFunction<A, B, C> matchWeigher, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, ruleBuilder);
    }

    public Constraint impactScoreLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongTriFunction<A, B, C> matchWeigher, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, ruleBuilder);
    }

    public Constraint impactScoreBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, ruleBuilder);
    }

    protected Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate();
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, ruleBuilder);
    }

    public Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ToIntTriFunction<A, B, C> matchWeigher, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, ruleBuilder);
    }

    public Constraint impactScoreConfigurableLong(String constraintPackage, String constraintName, ToLongTriFunction<A, B, C> matchWeigher, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, ruleBuilder);
    }

    public Constraint impactScoreConfigurableBigDecimal(String constraintPackage, String constraintName, TriFunction<A, B, C, BigDecimal> matchWeigher, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, ruleBuilder);
    }

    public abstract TriLeftHandSide<A, B, C> getLeftHandSide();
}

