/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.netty.buffer.ByteBuf;
import io.undertow.httpcore.InputChannel;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.util.Bits;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiConsumer;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

public class ServletInputStreamImpl
extends ServletInputStream {
    private final HttpServletRequestImpl request;
    private final HttpServerExchange exchange;
    private volatile ReadListener listener;
    private volatile ServletInputStreamChannelListener internalListener;
    private static final int FLAG_CLOSED = 2;
    private static final int FLAG_FINISHED = 4;
    private static final int FLAG_ON_DATA_READ_CALLED = 8;
    private static final int FLAG_IS_READY_CALLED = 64;
    private static final AtomicIntegerFieldUpdater<ServletInputStreamImpl> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(ServletInputStreamImpl.class, "state");
    private volatile int state;
    private volatile AsyncContextImpl asyncContext;
    private volatile ByteBuf pooled;

    public ServletInputStreamImpl(HttpServletRequestImpl request) {
        this.request = request;
        this.exchange = request.getExchange();
    }

    public boolean isFinished() {
        return Bits.anyAreSet((int)this.state, (int)4);
    }

    public boolean isReady() {
        boolean ready;
        boolean finished = Bits.anyAreSet((int)this.state, (int)4);
        if (finished && Bits.anyAreClear((int)this.state, (int)8)) {
            this.exchange.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    if (Bits.anyAreClear((int)ServletInputStreamImpl.this.state, (int)8)) {
                        ServletInputStreamImpl.this.setFlags(8);
                        ServletInputStreamImpl.this.request.getServletContext().invokeOnAllDataRead(ServletInputStreamImpl.this.request.getExchange(), ServletInputStreamImpl.this.listener);
                    }
                }
            });
        }
        boolean bl = ready = this.exchange.isReadable() && !finished;
        if (!ready && this.listener != null && !finished) {
            this.exchange.setReadHandler((BiConsumer)this.internalListener, (Object)this.exchange);
        }
        if (ready) {
            this.setFlags(64);
        }
        return ready;
    }

    public void setReadListener(ReadListener readListener) {
        if (readListener == null) {
            throw UndertowServletMessages.MESSAGES.listenerCannotBeNull();
        }
        if (this.listener != null) {
            throw UndertowServletMessages.MESSAGES.listenerAlreadySet();
        }
        if (!this.request.isAsyncStarted()) {
            throw UndertowServletMessages.MESSAGES.asyncNotStarted();
        }
        this.asyncContext = this.request.getAsyncContext();
        this.listener = readListener;
        this.internalListener = new ServletInputStreamChannelListener();
        this.asyncContext.addAsyncTask(new Runnable(){

            @Override
            public void run() {
                ServletInputStreamImpl.this.exchange.getIoThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        ServletInputStreamImpl.this.internalListener.accept((InputChannel)ServletInputStreamImpl.this.exchange, ServletInputStreamImpl.this.exchange);
                    }
                });
            }
        });
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        if (this.listener != null) {
            if (Bits.anyAreClear((int)this.state, (int)64)) {
                throw UndertowServletMessages.MESSAGES.streamNotReady();
            }
            this.clearFlags(64);
        }
        this.readIntoBuffer(false);
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        ByteBuf buffer = this.pooled;
        int copied = Math.min(len, buffer.readableBytes());
        buffer.readBytes(b, off, copied);
        if (!buffer.isReadable()) {
            this.pooled.release();
            this.pooled = null;
        }
        return copied;
    }

    private void readIntoBuffer(boolean close) throws IOException {
        if (this.pooled == null && !Bits.anyAreSet((int)this.state, (int)4)) {
            ByteBuf byteBuf = this.pooled = this.listener == null || close ? this.exchange.readBlocking() : this.exchange.readAsync();
            if (this.pooled == null) {
                this.setFlags(4);
                this.pooled = null;
            }
        }
    }

    public int available() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        int ret = this.exchange.readBytesAvailable();
        if (this.pooled != null) {
            ret += this.pooled.readableBytes();
        }
        return ret;
    }

    public void close() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return;
        }
        this.setFlags(2);
        try {
            while (Bits.allAreClear((int)this.state, (int)4)) {
                this.readIntoBuffer(true);
                if (this.pooled == null) continue;
                this.pooled.release();
                this.pooled = null;
            }
        }
        finally {
            this.setFlags(4);
            if (this.pooled != null) {
                this.pooled.release();
                this.pooled = null;
            }
            this.exchange.discardRequest();
        }
    }

    private void setFlags(int flags) {
        int old;
        while (!stateUpdater.compareAndSet(this, old = this.state, old | flags)) {
        }
    }

    private void clearFlags(int flags) {
        int old;
        while (!stateUpdater.compareAndSet(this, old = this.state, old & ~flags)) {
        }
    }

    private class ServletInputStreamChannelListener
    implements BiConsumer<InputChannel, HttpServerExchange> {
        private ServletInputStreamChannelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(InputChannel inputChannel, HttpServerExchange exchange) {
            block16: {
                try {
                    if (ServletInputStreamImpl.this.asyncContext.isDispatched()) {
                        return;
                    }
                    if (Bits.anyAreSet((int)ServletInputStreamImpl.this.state, (int)4)) {
                        if (ServletInputStreamImpl.this.pooled != null) {
                            ServletInputStreamImpl.this.pooled.release();
                        }
                        return;
                    }
                    if (Bits.anyAreSet((int)ServletInputStreamImpl.this.state, (int)4)) break block16;
                    try {
                        ServletInputStreamImpl.this.request.getServletContext().invokeOnDataAvailable(ServletInputStreamImpl.this.request.getExchange(), ServletInputStreamImpl.this.listener);
                    }
                    catch (Throwable e) {
                        try {
                            ServletInputStreamImpl.this.request.getServletContext().invokeRunnable(ServletInputStreamImpl.this.request.getExchange(), new Runnable(){

                                @Override
                                public void run() {
                                    ServletInputStreamImpl.this.listener.onError(e);
                                }
                            });
                        }
                        finally {
                            if (ServletInputStreamImpl.this.pooled != null) {
                                ServletInputStreamImpl.this.pooled.release();
                                ServletInputStreamImpl.this.pooled = null;
                            }
                            exchange.discardRequest();
                        }
                    }
                    if (Bits.anyAreSet((int)ServletInputStreamImpl.this.state, (int)4) && Bits.allAreClear((int)ServletInputStreamImpl.this.state, (int)8)) {
                        ServletInputStreamImpl.this.setFlags(8);
                        ServletInputStreamImpl.this.request.getServletContext().invokeOnAllDataRead(ServletInputStreamImpl.this.request.getExchange(), ServletInputStreamImpl.this.listener);
                    }
                }
                catch (Throwable e) {
                    try {
                        ServletInputStreamImpl.this.request.getServletContext().invokeRunnable(ServletInputStreamImpl.this.request.getExchange(), new Runnable(){

                            @Override
                            public void run() {
                                ServletInputStreamImpl.this.listener.onError(e);
                            }
                        });
                    }
                    finally {
                        if (ServletInputStreamImpl.this.pooled != null) {
                            ServletInputStreamImpl.this.pooled.release();
                            ServletInputStreamImpl.this.pooled = null;
                        }
                        exchange.discardRequest();
                    }
                }
            }
        }
    }
}

