/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.common;

import java.time.Duration;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailability;
import org.optaweb.employeerostering.domain.roster.Roster;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.shift.view.ShiftView;
import org.optaweb.employeerostering.domain.tenant.RosterConstraintConfiguration;
import org.optaweb.employeerostering.domain.violation.ContractMinutesViolation;
import org.optaweb.employeerostering.domain.violation.DesiredTimeslotForEmployeeReward;
import org.optaweb.employeerostering.domain.violation.IndictmentSummary;
import org.optaweb.employeerostering.domain.violation.NoBreakViolation;
import org.optaweb.employeerostering.domain.violation.PublishedShiftReassignedPenalty;
import org.optaweb.employeerostering.domain.violation.RequiredSkillViolation;
import org.optaweb.employeerostering.domain.violation.RotationViolationPenalty;
import org.optaweb.employeerostering.domain.violation.ShiftEmployeeConflict;
import org.optaweb.employeerostering.domain.violation.UnassignedShiftPenalty;
import org.optaweb.employeerostering.domain.violation.UnavailableEmployeeViolation;
import org.optaweb.employeerostering.domain.violation.UndesiredTimeslotForEmployeePenalty;
import org.optaweb.employeerostering.service.solver.EmployeeRosteringConstraintProvider;

@ApplicationScoped
public class IndictmentUtils {
    public static final String CONSTRAINT_MATCH_PACKAGE = "org.optaweb.employeerostering.service.solver";
    private ScoreManager<Roster, HardMediumSoftLongScore> scoreManager;

    @Inject
    public IndictmentUtils(ScoreManager<Roster, HardMediumSoftLongScore> scoreManager) {
        this.scoreManager = scoreManager;
    }

    public Map<Object, Indictment<HardMediumSoftLongScore>> getIndictmentMapForRoster(Roster roster) {
        return this.scoreManager.explainScore((Object)roster).getIndictmentMap();
    }

    public IndictmentSummary getIndictmentSummaryForRoster(Roster roster) {
        Map constraintMatchTotalMap = this.scoreManager.explainScore((Object)roster).getConstraintMatchTotalMap();
        IndictmentSummary out = new IndictmentSummary();
        out.setConstraintToCountMap(constraintMatchTotalMap.values().stream().collect(Collectors.toMap(ConstraintMatchTotal::getConstraintName, ConstraintMatchTotal::getConstraintMatchCount)));
        out.setConstraintToScoreImpactMap(constraintMatchTotalMap.values().stream().collect(Collectors.toMap(ConstraintMatchTotal::getConstraintName, ConstraintMatchTotal::getScore)));
        return out;
    }

    public ShiftView getShiftViewWithIndictment(ZoneId zoneId, Shift shift, RosterConstraintConfiguration configuration, Indictment<HardMediumSoftLongScore> shiftIndictment, Indictment<HardMediumSoftLongScore> employeeIndictment) {
        List<ContractMinutesViolation> contractMinutesViolationList = this.getContractMinutesViolationList(shift, configuration, employeeIndictment);
        HardMediumSoftLongScore totalImpactOnScore = HardMediumSoftLongScore.ZERO;
        if (shiftIndictment != null) {
            totalImpactOnScore = (HardMediumSoftLongScore)shiftIndictment.getScore();
        }
        for (ContractMinutesViolation contractMinutesViolation : contractMinutesViolationList) {
            totalImpactOnScore = totalImpactOnScore.add(contractMinutesViolation.getScore());
        }
        return new ShiftView(zoneId, shift, this.getRequiredSkillViolationList(shiftIndictment), this.getUnavailableEmployeeViolationList(shiftIndictment), this.getShiftEmployeeConflictList(shiftIndictment), this.getDesiredTimeslotForEmployeeRewardList(shiftIndictment), this.getUndesiredTimeslotForEmployeePenaltyList(shiftIndictment), this.getRotationViolationPenaltyList(shiftIndictment), this.getUnassignedShiftPenaltyList(shiftIndictment), contractMinutesViolationList, this.getNoBreakViolationList(shiftIndictment), this.getPublishedShiftReassignedPenaltyList(shiftIndictment), totalImpactOnScore);
    }

    public List<RequiredSkillViolation> getRequiredSkillViolationList(Indictment<HardMediumSoftLongScore> indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(constraintMatch -> constraintMatch.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && constraintMatch.getConstraintName().equals("Required skill for a shift")).map(constraintMatch -> new RequiredSkillViolation((Shift)constraintMatch.getJustificationList().get(0), (HardMediumSoftLongScore)constraintMatch.getScore())).collect(Collectors.toList());
    }

    public List<UnavailableEmployeeViolation> getUnavailableEmployeeViolationList(Indictment<HardMediumSoftLongScore> indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(constraintMatch -> constraintMatch.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && constraintMatch.getConstraintName().equals("Unavailable time slot for an employee")).map(constraintMatch -> new UnavailableEmployeeViolation((Shift)constraintMatch.getJustificationList().get(1), (EmployeeAvailability)constraintMatch.getJustificationList().get(0), (HardMediumSoftLongScore)constraintMatch.getScore())).collect(Collectors.toList());
    }

    public List<DesiredTimeslotForEmployeeReward> getDesiredTimeslotForEmployeeRewardList(Indictment<HardMediumSoftLongScore> indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(constraintMatch -> constraintMatch.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && constraintMatch.getConstraintName().equals("Desired time slot for an employee")).map(constraintMatch -> new DesiredTimeslotForEmployeeReward((Shift)constraintMatch.getJustificationList().get(1), (EmployeeAvailability)constraintMatch.getJustificationList().get(0), (HardMediumSoftLongScore)constraintMatch.getScore())).collect(Collectors.toList());
    }

    public List<UndesiredTimeslotForEmployeePenalty> getUndesiredTimeslotForEmployeePenaltyList(Indictment<HardMediumSoftLongScore> indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(constraintMatch -> constraintMatch.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && constraintMatch.getConstraintName().equals("Undesired time slot for an employee")).map(constraintMatch -> new UndesiredTimeslotForEmployeePenalty((Shift)constraintMatch.getJustificationList().get(1), (EmployeeAvailability)constraintMatch.getJustificationList().get(0), (HardMediumSoftLongScore)constraintMatch.getScore())).collect(Collectors.toList());
    }

    public List<ShiftEmployeeConflict> getShiftEmployeeConflictList(Indictment<HardMediumSoftLongScore> indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        List<String> employeeShiftConstraintNameList = Arrays.asList("Break between non-consecutive shifts is at least 10 hours", "No overlapping shifts");
        return indictment.getConstraintMatchSet().stream().filter(constraintMatch -> constraintMatch.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && employeeShiftConstraintNameList.contains(constraintMatch.getConstraintName())).map(constraintMatch -> new ShiftEmployeeConflict((Shift)constraintMatch.getJustificationList().get(0), (Shift)constraintMatch.getJustificationList().get(1), (HardMediumSoftLongScore)constraintMatch.getScore())).collect(Collectors.toList());
    }

    public List<NoBreakViolation> getNoBreakViolationList(Indictment<HardMediumSoftLongScore> indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(constraintMatch -> constraintMatch.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && constraintMatch.getConstraintName().equals("No more than 2 consecutive shifts")).map(constraintMatch -> new NoBreakViolation((Shift)constraintMatch.getJustificationList().get(0), (Shift)constraintMatch.getJustificationList().get(1), (Shift)constraintMatch.getJustificationList().get(2), (HardMediumSoftLongScore)constraintMatch.getScore())).collect(Collectors.toList());
    }

    public List<RotationViolationPenalty> getRotationViolationPenaltyList(Indictment<HardMediumSoftLongScore> indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(constraintMatch -> constraintMatch.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && constraintMatch.getConstraintName().equals("Employee is not rotation employee")).map(constraintMatch -> new RotationViolationPenalty((Shift)constraintMatch.getJustificationList().get(0), (HardMediumSoftLongScore)constraintMatch.getScore())).collect(Collectors.toList());
    }

    public List<UnassignedShiftPenalty> getUnassignedShiftPenaltyList(Indictment<HardMediumSoftLongScore> indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(constraintMatch -> constraintMatch.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && constraintMatch.getConstraintName().equals("Assign every shift")).map(constraintMatch -> new UnassignedShiftPenalty((Shift)constraintMatch.getJustificationList().get(0), (HardMediumSoftLongScore)constraintMatch.getScore())).collect(Collectors.toList());
    }

    private static Predicate<ConstraintMatch> shiftImpactsConstraintMatch(Shift shift, RosterConstraintConfiguration configuration) {
        return constraintMatch -> {
            Comparable<ChronoLocalDate> groupKey;
            switch (constraintMatch.getConstraintName()) {
                case "Daily minutes must not exceed contract maximum": {
                    groupKey = shift.getStartDateTime().toLocalDate();
                    break;
                }
                case "Weekly minutes must not exceed contract maximum": {
                    groupKey = EmployeeRosteringConstraintProvider.extractFirstDayOfWeek(configuration.getWeekStartDay(), shift.getStartDateTime());
                    break;
                }
                case "Monthly minutes must not exceed contract maximum": {
                    groupKey = YearMonth.from(shift.getStartDateTime());
                    break;
                }
                case "Yearly minutes must not exceed contract maximum": {
                    groupKey = shift.getStartDateTime().getYear();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled constraint (" + constraintMatch.getConstraintName() + ").");
                }
            }
            return constraintMatch.getJustificationList().get(1).equals(groupKey);
        };
    }

    public List<ContractMinutesViolation> getContractMinutesViolationList(Shift shift, RosterConstraintConfiguration configuration, Indictment<HardMediumSoftLongScore> indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        List<String> contractMinutesConstraintNameList = Arrays.asList("Daily minutes must not exceed contract maximum", "Weekly minutes must not exceed contract maximum", "Monthly minutes must not exceed contract maximum", "Yearly minutes must not exceed contract maximum");
        return indictment.getConstraintMatchSet().stream().filter(constraintMatch -> constraintMatch.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && contractMinutesConstraintNameList.contains(constraintMatch.getConstraintName())).filter(IndictmentUtils.shiftImpactsConstraintMatch(shift, configuration)).map(constraintMatch -> new ContractMinutesViolation((Employee)constraintMatch.getJustificationList().get(0), ContractMinutesViolation.Type.getTypeForViolation(constraintMatch.getConstraintName()), ((Duration)constraintMatch.getJustificationList().get(2)).toMinutes(), (HardMediumSoftLongScore)constraintMatch.getScore())).collect(Collectors.toList());
    }

    public List<PublishedShiftReassignedPenalty> getPublishedShiftReassignedPenaltyList(Indictment<HardMediumSoftLongScore> indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(constraintMatch -> constraintMatch.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && constraintMatch.getConstraintName().equals("Employee is not original employee")).map(constraintMatch -> new PublishedShiftReassignedPenalty((Shift)constraintMatch.getJustificationList().get(0), (HardMediumSoftLongScore)constraintMatch.getScore())).collect(Collectors.toList());
    }
}

