/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.shift;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.entity.PlanningPin;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.shift.PinningShiftFilter;
import org.optaweb.employeerostering.domain.shift.view.ShiftView;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;

@Entity
@PlanningEntity(pinningFilter=PinningShiftFilter.class)
public class Shift
extends AbstractPersistable
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    @Transient
    private AtomicLong lengthInMinutes = new AtomicLong(-1L);
    @ManyToOne
    private Employee rotationEmployee;
    @NotNull
    @ManyToOne
    private Spot spot;
    @NotNull
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="ShiftRequiredSkillSet", joinColumns={@JoinColumn(name="shiftId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="skillId", referencedColumnName="id")})
    private Set<Skill> requiredSkillSet;
    @NotNull
    private OffsetDateTime startDateTime;
    @NotNull
    private OffsetDateTime endDateTime;
    @PlanningPin
    private boolean pinnedByUser;
    @ManyToOne
    @PlanningVariable(valueRangeProviderRefs={"employeeRange"}, nullable=true)
    private Employee employee;
    @ManyToOne
    private Employee originalEmployee;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public Shift() {
        this.$$_hibernate_write_pinnedByUser(false);
        this.$$_hibernate_write_employee(null);
        this.$$_hibernate_write_originalEmployee(null);
    }

    public Shift(Integer tenantId, Spot spot, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        this(tenantId, spot, startDateTime, endDateTime, null);
    }

    public Shift(Integer tenantId, Spot spot, OffsetDateTime startDateTime, OffsetDateTime endDateTime, Employee rotationEmployee) {
        this(tenantId, spot, startDateTime, endDateTime, rotationEmployee, new HashSet<Skill>(), null);
    }

    public Shift(Integer tenantId, Spot spot, OffsetDateTime startDateTime, OffsetDateTime endDateTime, Employee rotationEmployee, Set<Skill> requiredSkillSet, Employee originalEmployee) {
        super(tenantId);
        this.$$_hibernate_write_pinnedByUser(false);
        this.$$_hibernate_write_employee(null);
        this.$$_hibernate_write_originalEmployee(null);
        this.$$_hibernate_write_startDateTime(startDateTime);
        this.$$_hibernate_write_endDateTime(endDateTime);
        this.$$_hibernate_write_spot(spot);
        this.$$_hibernate_write_rotationEmployee(rotationEmployee);
        this.$$_hibernate_write_requiredSkillSet(requiredSkillSet);
        this.$$_hibernate_write_originalEmployee(originalEmployee);
    }

    public Shift(ZoneId zoneId, ShiftView shiftView, Spot spot) {
        this(zoneId, shiftView, spot, null);
    }

    public Shift(ZoneId zoneId, ShiftView shiftView, Spot spot, Employee rotationEmployee) {
        this(zoneId, shiftView, spot, rotationEmployee, new HashSet<Skill>(), null);
    }

    public Shift(ZoneId zoneId, ShiftView shiftView, Spot spot, Employee rotationEmployee, Set<Skill> requiredSkillSet, Employee originalEmployee) {
        super((AbstractPersistable)shiftView);
        this.$$_hibernate_write_pinnedByUser(false);
        this.$$_hibernate_write_employee(null);
        this.$$_hibernate_write_originalEmployee(null);
        this.$$_hibernate_write_startDateTime(OffsetDateTime.of(shiftView.getStartDateTime(), zoneId.getRules().getOffset(shiftView.getStartDateTime())));
        this.$$_hibernate_write_endDateTime(OffsetDateTime.of(shiftView.getEndDateTime(), zoneId.getRules().getOffset(shiftView.getEndDateTime())));
        this.$$_hibernate_write_spot(spot);
        this.$$_hibernate_write_pinnedByUser(shiftView.isPinnedByUser());
        this.$$_hibernate_write_rotationEmployee(rotationEmployee);
        this.$$_hibernate_write_requiredSkillSet(requiredSkillSet);
        this.$$_hibernate_write_originalEmployee(originalEmployee);
    }

    @AssertTrue(message="Shift's end date time is not at least 30 minutes after shift's start date time")
    @JsonIgnore
    public @AssertTrue(message="Shift's end date time is not at least 30 minutes after shift's start date time") boolean isValid() {
        return this.$$_hibernate_read_startDateTime() != null && this.$$_hibernate_read_endDateTime() != null && Duration.between(this.$$_hibernate_read_startDateTime(), this.$$_hibernate_read_endDateTime()).getSeconds() / 60L >= 30L;
    }

    @Override
    public String toString() {
        return this.$$_hibernate_read_spot() + " " + this.$$_hibernate_read_startDateTime() + "-" + this.$$_hibernate_read_endDateTime();
    }

    public boolean precedes(Shift other) {
        return !this.$$_hibernate_read_endDateTime().isAfter(other.$$_hibernate_read_startDateTime());
    }

    public long getLengthInMinutes() {
        long currentLengthInMinutes = this.lengthInMinutes.get();
        if (currentLengthInMinutes >= 0L) {
            return currentLengthInMinutes;
        }
        long newLengthInMinutes = this.$$_hibernate_read_startDateTime().until(this.$$_hibernate_read_endDateTime(), ChronoUnit.MINUTES);
        this.lengthInMinutes.set(newLengthInMinutes);
        return newLengthInMinutes;
    }

    @JsonIgnore
    public boolean isMoved() {
        return this.$$_hibernate_read_originalEmployee() != null && this.$$_hibernate_read_originalEmployee() != this.$$_hibernate_read_employee();
    }

    public boolean hasRequiredSkills() {
        return this.$$_hibernate_read_employee().getSkillProficiencySet().containsAll(this.$$_hibernate_read_spot().getRequiredSkillSet()) && this.$$_hibernate_read_employee().getSkillProficiencySet().containsAll(this.$$_hibernate_read_requiredSkillSet());
    }

    public Spot getSpot() {
        return this.$$_hibernate_read_spot();
    }

    public void setSpot(Spot spot) {
        this.$$_hibernate_write_spot(spot);
    }

    public OffsetDateTime getStartDateTime() {
        return this.$$_hibernate_read_startDateTime();
    }

    public void setStartDateTime(OffsetDateTime startDateTime) {
        this.$$_hibernate_write_startDateTime(startDateTime);
        this.lengthInMinutes.set(-1L);
    }

    public OffsetDateTime getEndDateTime() {
        return this.$$_hibernate_read_endDateTime();
    }

    public void setEndDateTime(OffsetDateTime endDateTime) {
        this.$$_hibernate_write_endDateTime(endDateTime);
        this.lengthInMinutes.set(-1L);
    }

    public boolean isPinnedByUser() {
        return this.$$_hibernate_read_pinnedByUser();
    }

    public void setPinnedByUser(boolean lockedByUser) {
        this.$$_hibernate_write_pinnedByUser(lockedByUser);
    }

    public Employee getEmployee() {
        return this.$$_hibernate_read_employee();
    }

    public void setEmployee(Employee employee) {
        this.$$_hibernate_write_employee(employee);
    }

    public Employee getRotationEmployee() {
        return this.$$_hibernate_read_rotationEmployee();
    }

    public void setRotationEmployee(Employee rotationEmployee) {
        this.$$_hibernate_write_rotationEmployee(rotationEmployee);
    }

    public Employee getOriginalEmployee() {
        return this.$$_hibernate_read_originalEmployee();
    }

    public void setOriginalEmployee(Employee originalEmployee) {
        this.$$_hibernate_write_originalEmployee(originalEmployee);
    }

    public Set<Skill> getRequiredSkillSet() {
        return this.$$_hibernate_read_requiredSkillSet();
    }

    public void setRequiredSkillSet(Set<Skill> requiredSkillSet) {
        this.$$_hibernate_write_requiredSkillSet(requiredSkillSet);
    }

    public Shift inTimeZone(ZoneId zoneId) {
        Shift out = new Shift(zoneId, new ShiftView(zoneId, this), this.getSpot(), this.getRotationEmployee(), this.getRequiredSkillSet(), this.getOriginalEmployee());
        out.setEmployee(this.getEmployee());
        return out;
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        Shift shift = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        boolean bl;
        block0: {
            int n;
            block1: {
                Shift shift = this;
                bl = false;
                if (bl || this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("requiredSkillSet");
                if (this.requiredSkillSet != null || n == -1) break block1;
                bl = true;
                break block0;
            }
            if (this.requiredSkillSet == null || this.requiredSkillSet instanceof PersistentCollection && !((PersistentCollection)this.requiredSkillSet).wasInitialized() || n == this.requiredSkillSet.size()) break block0;
            bl = true;
        }
        return bl;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block0: {
            int n;
            block1: {
                Shift shift = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                if (this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("requiredSkillSet");
                if (this.requiredSkillSet != null || n == -1) break block1;
                dirtyTracker.add("requiredSkillSet");
                break block0;
            }
            if (this.requiredSkillSet == null || this.requiredSkillSet instanceof PersistentCollection && !((PersistentCollection)this.requiredSkillSet).wasInitialized() || n == this.requiredSkillSet.size()) break block0;
            dirtyTracker.add("requiredSkillSet");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block3: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            Shift shift = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("requiredSkillSet")) break block3;
            if (this.requiredSkillSet == null || this.requiredSkillSet instanceof PersistentCollection && !((PersistentCollection)this.requiredSkillSet).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("requiredSkillSet", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("requiredSkillSet", this.requiredSkillSet.size());
            }
        }
    }

    public Employee $$_hibernate_read_rotationEmployee() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.rotationEmployee = (Employee)this.$$_hibernate_getInterceptor().readObject((Object)this, "rotationEmployee", (Object)this.rotationEmployee);
        }
        return this.rotationEmployee;
    }

    public void $$_hibernate_write_rotationEmployee(Employee employee) {
        if (!Objects.deepEquals(employee, this.rotationEmployee)) {
            this.$$_hibernate_trackChange("rotationEmployee");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.rotationEmployee = (Employee)this.$$_hibernate_getInterceptor().writeObject((Object)this, "rotationEmployee", (Object)this.rotationEmployee, (Object)employee);
            return;
        }
        this.rotationEmployee = employee;
    }

    public Spot $$_hibernate_read_spot() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.spot = (Spot)this.$$_hibernate_getInterceptor().readObject((Object)this, "spot", (Object)this.spot);
        }
        return this.spot;
    }

    public void $$_hibernate_write_spot(Spot spot) {
        if (!Objects.deepEquals(spot, this.spot)) {
            this.$$_hibernate_trackChange("spot");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.spot = (Spot)this.$$_hibernate_getInterceptor().writeObject((Object)this, "spot", (Object)this.spot, (Object)spot);
            return;
        }
        this.spot = spot;
    }

    public Set $$_hibernate_read_requiredSkillSet() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requiredSkillSet = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "requiredSkillSet", this.requiredSkillSet);
        }
        return this.requiredSkillSet;
    }

    public void $$_hibernate_write_requiredSkillSet(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requiredSkillSet = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "requiredSkillSet", this.requiredSkillSet, (Object)set);
            return;
        }
        this.requiredSkillSet = set;
    }

    public OffsetDateTime $$_hibernate_read_startDateTime() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.startDateTime = (OffsetDateTime)this.$$_hibernate_getInterceptor().readObject((Object)this, "startDateTime", (Object)this.startDateTime);
        }
        return this.startDateTime;
    }

    public void $$_hibernate_write_startDateTime(OffsetDateTime offsetDateTime) {
        if (!Objects.deepEquals(offsetDateTime, this.startDateTime)) {
            this.$$_hibernate_trackChange("startDateTime");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.startDateTime = (OffsetDateTime)this.$$_hibernate_getInterceptor().writeObject((Object)this, "startDateTime", (Object)this.startDateTime, (Object)offsetDateTime);
            return;
        }
        this.startDateTime = offsetDateTime;
    }

    public OffsetDateTime $$_hibernate_read_endDateTime() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.endDateTime = (OffsetDateTime)this.$$_hibernate_getInterceptor().readObject((Object)this, "endDateTime", (Object)this.endDateTime);
        }
        return this.endDateTime;
    }

    public void $$_hibernate_write_endDateTime(OffsetDateTime offsetDateTime) {
        if (!Objects.deepEquals(offsetDateTime, this.endDateTime)) {
            this.$$_hibernate_trackChange("endDateTime");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.endDateTime = (OffsetDateTime)this.$$_hibernate_getInterceptor().writeObject((Object)this, "endDateTime", (Object)this.endDateTime, (Object)offsetDateTime);
            return;
        }
        this.endDateTime = offsetDateTime;
    }

    public boolean $$_hibernate_read_pinnedByUser() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.pinnedByUser = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "pinnedByUser", this.pinnedByUser);
        }
        return this.pinnedByUser;
    }

    public void $$_hibernate_write_pinnedByUser(boolean bl) {
        if (bl - this.pinnedByUser != 0) {
            this.$$_hibernate_trackChange("pinnedByUser");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.pinnedByUser = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "pinnedByUser", this.pinnedByUser, bl);
            return;
        }
        this.pinnedByUser = bl;
    }

    public Employee $$_hibernate_read_employee() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.employee = (Employee)this.$$_hibernate_getInterceptor().readObject((Object)this, "employee", (Object)this.employee);
        }
        return this.employee;
    }

    public void $$_hibernate_write_employee(Employee employee) {
        if (!Objects.deepEquals(employee, this.employee)) {
            this.$$_hibernate_trackChange("employee");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.employee = (Employee)this.$$_hibernate_getInterceptor().writeObject((Object)this, "employee", (Object)this.employee, (Object)employee);
            return;
        }
        this.employee = employee;
    }

    public Employee $$_hibernate_read_originalEmployee() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.originalEmployee = (Employee)this.$$_hibernate_getInterceptor().readObject((Object)this, "originalEmployee", (Object)this.originalEmployee);
        }
        return this.originalEmployee;
    }

    public void $$_hibernate_write_originalEmployee(Employee employee) {
        if (!Objects.deepEquals(employee, this.originalEmployee)) {
            this.$$_hibernate_trackChange("originalEmployee");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.originalEmployee = (Employee)this.$$_hibernate_getInterceptor().writeObject((Object)this, "originalEmployee", (Object)this.originalEmployee, (Object)employee);
            return;
        }
        this.originalEmployee = employee;
    }

    @Override
    public Long $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_id((Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)super.$$_hibernate_read_id()));
        }
        return super.$$_hibernate_read_id();
    }

    @Override
    public void $$_hibernate_write_id(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_id((Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)super.$$_hibernate_read_id(), (Object)l));
            return;
        }
        super.$$_hibernate_write_id(l);
    }

    @Override
    public Integer $$_hibernate_read_tenantId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_tenantId((Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "tenantId", (Object)super.$$_hibernate_read_tenantId()));
        }
        return super.$$_hibernate_read_tenantId();
    }

    @Override
    public void $$_hibernate_write_tenantId(Integer n) {
        if (!Objects.deepEquals(n, ((AbstractPersistable)this).$$_hibernate_read_tenantId())) {
            this.$$_hibernate_trackChange("tenantId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_tenantId((Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "tenantId", (Object)super.$$_hibernate_read_tenantId(), (Object)n));
            return;
        }
        super.$$_hibernate_write_tenantId(n);
    }

    @Override
    public Long $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_version((Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "version", (Object)super.$$_hibernate_read_version()));
        }
        return super.$$_hibernate_read_version();
    }

    @Override
    public void $$_hibernate_write_version(Long l) {
        if (!Objects.deepEquals(l, ((AbstractPersistable)this).$$_hibernate_read_version())) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_version((Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "version", (Object)super.$$_hibernate_read_version(), (Object)l));
            return;
        }
        super.$$_hibernate_write_version(l);
    }

    public boolean $get$optaplanner$__field$__pinnedByUser() {
        return this.pinnedByUser;
    }

    public void $set$optaplanner$__field$__pinnedByUser(boolean bl) {
        this.pinnedByUser = bl;
    }

    public Employee $get$optaplanner$__field$__employee() {
        return this.employee;
    }

    public void $set$optaplanner$__field$__employee(Employee employee) {
        this.employee = employee;
    }

    public AtomicLong $get$optaplanner$__field$__lengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void $set$optaplanner$__field$__lengthInMinutes(AtomicLong atomicLong) {
        this.lengthInMinutes = atomicLong;
    }

    public Employee $get$optaplanner$__field$__rotationEmployee() {
        return this.rotationEmployee;
    }

    public void $set$optaplanner$__field$__rotationEmployee(Employee employee) {
        this.rotationEmployee = employee;
    }

    public Spot $get$optaplanner$__field$__spot() {
        return this.spot;
    }

    public void $set$optaplanner$__field$__spot(Spot spot) {
        this.spot = spot;
    }

    public Set $get$optaplanner$__field$__requiredSkillSet() {
        return this.requiredSkillSet;
    }

    public void $set$optaplanner$__field$__requiredSkillSet(Set set) {
        this.requiredSkillSet = set;
    }

    public OffsetDateTime $get$optaplanner$__field$__startDateTime() {
        return this.startDateTime;
    }

    public void $set$optaplanner$__field$__startDateTime(OffsetDateTime offsetDateTime) {
        this.startDateTime = offsetDateTime;
    }

    public OffsetDateTime $get$optaplanner$__field$__endDateTime() {
        return this.endDateTime;
    }

    public void $set$optaplanner$__field$__endDateTime(OffsetDateTime offsetDateTime) {
        this.endDateTime = offsetDateTime;
    }

    public Employee $get$optaplanner$__field$__originalEmployee() {
        return this.originalEmployee;
    }

    public void $set$optaplanner$__field$__originalEmployee(Employee employee) {
        this.originalEmployee = employee;
    }
}

