/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.tenant;

import java.time.DayOfWeek;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;

@Entity
@ConstraintConfiguration(constraintPackage="org.optaweb.employeerostering.service.solver")
public class RosterConstraintConfiguration
extends AbstractPersistable
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    public static final String CONSTRAINT_REQUIRED_SKILL_FOR_A_SHIFT = "Required skill for a shift";
    public static final String CONSTRAINT_UNAVAILABLE_TIME_SLOT_FOR_AN_EMPLOYEE = "Unavailable time slot for an employee";
    public static final String CONSTRAINT_NO_OVERLAPPING_SHIFTS = "No overlapping shifts";
    public static final String CONSTRAINT_NO_MORE_THAN_2_CONSECUTIVE_SHIFTS = "No more than 2 consecutive shifts";
    public static final String CONSTRAINT_BREAK_BETWEEN_NON_CONSECUTIVE_SHIFTS = "Break between non-consecutive shifts is at least 10 hours";
    public static final String CONSTRAINT_DAILY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM = "Daily minutes must not exceed contract maximum";
    public static final String CONSTRAINT_WEEKLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM = "Weekly minutes must not exceed contract maximum";
    public static final String CONSTRAINT_MONTHLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM = "Monthly minutes must not exceed contract maximum";
    public static final String CONSTRAINT_YEARLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM = "Yearly minutes must not exceed contract maximum";
    public static final String CONSTRAINT_ASSIGN_EVERY_SHIFT = "Assign every shift";
    public static final String CONSTRAINT_EMPLOYEE_IS_NOT_ORIGINAL_EMPLOYEE = "Employee is not original employee";
    public static final String CONSTRAINT_UNDESIRED_TIME_SLOT_FOR_AN_EMPLOYEE = "Undesired time slot for an employee";
    public static final String CONSTRAINT_DESIRED_TIME_SLOT_FOR_AN_EMPLOYEE = "Desired time slot for an employee";
    public static final String CONSTRAINT_EMPLOYEE_IS_NOT_ROTATION_EMPLOYEE = "Employee is not rotation employee";
    @NotNull
    private DayOfWeek weekStartDay;
    @ConstraintWeight(value="Required skill for a shift")
    private HardMediumSoftLongScore requiredSkill;
    @ConstraintWeight(value="Unavailable time slot for an employee")
    private HardMediumSoftLongScore unavailableTimeSlot;
    @ConstraintWeight(value="No overlapping shifts")
    private HardMediumSoftLongScore noOverlappingShifts;
    @ConstraintWeight(value="No more than 2 consecutive shifts")
    private HardMediumSoftLongScore noMoreThan2ConsecutiveShifts;
    @ConstraintWeight(value="Break between non-consecutive shifts is at least 10 hours")
    private HardMediumSoftLongScore breakBetweenNonConsecutiveShiftsAtLeast10Hours;
    @ConstraintWeight(value="Daily minutes must not exceed contract maximum")
    private HardMediumSoftLongScore contractMaximumDailyMinutes;
    @ConstraintWeight(value="Weekly minutes must not exceed contract maximum")
    private HardMediumSoftLongScore contractMaximumWeeklyMinutes;
    @ConstraintWeight(value="Monthly minutes must not exceed contract maximum")
    private HardMediumSoftLongScore contractMaximumMonthlyMinutes;
    @ConstraintWeight(value="Yearly minutes must not exceed contract maximum")
    private HardMediumSoftLongScore contractMaximumYearlyMinutes;
    @ConstraintWeight(value="Assign every shift")
    private HardMediumSoftLongScore assignEveryShift;
    @ConstraintWeight(value="Employee is not original employee")
    private HardMediumSoftLongScore notOriginalEmployee;
    @ConstraintWeight(value="Undesired time slot for an employee")
    private HardMediumSoftLongScore undesiredTimeSlot;
    @ConstraintWeight(value="Desired time slot for an employee")
    private HardMediumSoftLongScore desiredTimeSlot;
    @ConstraintWeight(value="Employee is not rotation employee")
    private HardMediumSoftLongScore notRotationEmployee;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public RosterConstraintConfiguration() {
        super(-1);
        this.$$_hibernate_write_weekStartDay(DayOfWeek.MONDAY);
        this.$$_hibernate_write_requiredSkill(HardMediumSoftLongScore.ofHard((long)100L));
        this.$$_hibernate_write_unavailableTimeSlot(HardMediumSoftLongScore.ofHard((long)50L));
        this.$$_hibernate_write_noOverlappingShifts(HardMediumSoftLongScore.ofHard((long)20L));
        this.$$_hibernate_write_noMoreThan2ConsecutiveShifts(HardMediumSoftLongScore.ofHard((long)10L));
        this.$$_hibernate_write_breakBetweenNonConsecutiveShiftsAtLeast10Hours(HardMediumSoftLongScore.ofHard((long)1L));
        this.$$_hibernate_write_contractMaximumDailyMinutes(HardMediumSoftLongScore.ofHard((long)1L));
        this.$$_hibernate_write_contractMaximumWeeklyMinutes(HardMediumSoftLongScore.ofHard((long)1L));
        this.$$_hibernate_write_contractMaximumMonthlyMinutes(HardMediumSoftLongScore.ofHard((long)1L));
        this.$$_hibernate_write_contractMaximumYearlyMinutes(HardMediumSoftLongScore.ofHard((long)1L));
        this.$$_hibernate_write_assignEveryShift(HardMediumSoftLongScore.ofMedium((long)1L));
        this.$$_hibernate_write_notOriginalEmployee(HardMediumSoftLongScore.ofSoft((long)100000000000L));
        this.$$_hibernate_write_undesiredTimeSlot(HardMediumSoftLongScore.ofSoft((long)20L));
        this.$$_hibernate_write_desiredTimeSlot(HardMediumSoftLongScore.ofSoft((long)10L));
        this.$$_hibernate_write_notRotationEmployee(HardMediumSoftLongScore.ofSoft((long)50L));
    }

    public RosterConstraintConfiguration(Integer tenantId, DayOfWeek weekStartDay) {
        super(tenantId);
        this.$$_hibernate_write_weekStartDay(DayOfWeek.MONDAY);
        this.$$_hibernate_write_requiredSkill(HardMediumSoftLongScore.ofHard((long)100L));
        this.$$_hibernate_write_unavailableTimeSlot(HardMediumSoftLongScore.ofHard((long)50L));
        this.$$_hibernate_write_noOverlappingShifts(HardMediumSoftLongScore.ofHard((long)20L));
        this.$$_hibernate_write_noMoreThan2ConsecutiveShifts(HardMediumSoftLongScore.ofHard((long)10L));
        this.$$_hibernate_write_breakBetweenNonConsecutiveShiftsAtLeast10Hours(HardMediumSoftLongScore.ofHard((long)1L));
        this.$$_hibernate_write_contractMaximumDailyMinutes(HardMediumSoftLongScore.ofHard((long)1L));
        this.$$_hibernate_write_contractMaximumWeeklyMinutes(HardMediumSoftLongScore.ofHard((long)1L));
        this.$$_hibernate_write_contractMaximumMonthlyMinutes(HardMediumSoftLongScore.ofHard((long)1L));
        this.$$_hibernate_write_contractMaximumYearlyMinutes(HardMediumSoftLongScore.ofHard((long)1L));
        this.$$_hibernate_write_assignEveryShift(HardMediumSoftLongScore.ofMedium((long)1L));
        this.$$_hibernate_write_notOriginalEmployee(HardMediumSoftLongScore.ofSoft((long)100000000000L));
        this.$$_hibernate_write_undesiredTimeSlot(HardMediumSoftLongScore.ofSoft((long)20L));
        this.$$_hibernate_write_desiredTimeSlot(HardMediumSoftLongScore.ofSoft((long)10L));
        this.$$_hibernate_write_notRotationEmployee(HardMediumSoftLongScore.ofSoft((long)50L));
        this.$$_hibernate_write_weekStartDay(weekStartDay);
    }

    public DayOfWeek getWeekStartDay() {
        return this.$$_hibernate_read_weekStartDay();
    }

    public void setWeekStartDay(DayOfWeek weekStartDay) {
        this.$$_hibernate_write_weekStartDay(weekStartDay);
    }

    public HardMediumSoftLongScore getRequiredSkill() {
        return this.$$_hibernate_read_requiredSkill();
    }

    public void setRequiredSkill(HardMediumSoftLongScore requiredSkill) {
        this.$$_hibernate_write_requiredSkill(requiredSkill);
    }

    public HardMediumSoftLongScore getUnavailableTimeSlot() {
        return this.$$_hibernate_read_unavailableTimeSlot();
    }

    public void setUnavailableTimeSlot(HardMediumSoftLongScore unavailableTimeSlot) {
        this.$$_hibernate_write_unavailableTimeSlot(unavailableTimeSlot);
    }

    public HardMediumSoftLongScore getNoOverlappingShifts() {
        return this.$$_hibernate_read_noOverlappingShifts();
    }

    public void setNoOverlappingShifts(HardMediumSoftLongScore noOverlappingShifts) {
        this.$$_hibernate_write_noOverlappingShifts(noOverlappingShifts);
    }

    public HardMediumSoftLongScore getNoMoreThan2ConsecutiveShifts() {
        return this.$$_hibernate_read_noMoreThan2ConsecutiveShifts();
    }

    public void setNoMoreThan2ConsecutiveShifts(HardMediumSoftLongScore noMoreThan2ConsecutiveShifts) {
        this.$$_hibernate_write_noMoreThan2ConsecutiveShifts(noMoreThan2ConsecutiveShifts);
    }

    public HardMediumSoftLongScore getBreakBetweenNonConsecutiveShiftsAtLeast10Hours() {
        return this.$$_hibernate_read_breakBetweenNonConsecutiveShiftsAtLeast10Hours();
    }

    public void setBreakBetweenNonConsecutiveShiftsAtLeast10Hours(HardMediumSoftLongScore breakBetweenNonConsecutiveShiftsAtLeast10Hours) {
        this.$$_hibernate_write_breakBetweenNonConsecutiveShiftsAtLeast10Hours(breakBetweenNonConsecutiveShiftsAtLeast10Hours);
    }

    public HardMediumSoftLongScore getContractMaximumDailyMinutes() {
        return this.$$_hibernate_read_contractMaximumDailyMinutes();
    }

    public void setContractMaximumDailyMinutes(HardMediumSoftLongScore contractMaximumDailyMinutes) {
        this.$$_hibernate_write_contractMaximumDailyMinutes(contractMaximumDailyMinutes);
    }

    public HardMediumSoftLongScore getContractMaximumWeeklyMinutes() {
        return this.$$_hibernate_read_contractMaximumWeeklyMinutes();
    }

    public void setContractMaximumWeeklyMinutes(HardMediumSoftLongScore contractMaximumWeeklyMinutes) {
        this.$$_hibernate_write_contractMaximumWeeklyMinutes(contractMaximumWeeklyMinutes);
    }

    public HardMediumSoftLongScore getContractMaximumMonthlyMinutes() {
        return this.$$_hibernate_read_contractMaximumMonthlyMinutes();
    }

    public void setContractMaximumMonthlyMinutes(HardMediumSoftLongScore contractMaximumMonthlyMinutes) {
        this.$$_hibernate_write_contractMaximumMonthlyMinutes(contractMaximumMonthlyMinutes);
    }

    public HardMediumSoftLongScore getContractMaximumYearlyMinutes() {
        return this.$$_hibernate_read_contractMaximumYearlyMinutes();
    }

    public void setContractMaximumYearlyMinutes(HardMediumSoftLongScore contractMaximumYearlyMinutes) {
        this.$$_hibernate_write_contractMaximumYearlyMinutes(contractMaximumYearlyMinutes);
    }

    public HardMediumSoftLongScore getAssignEveryShift() {
        return this.$$_hibernate_read_assignEveryShift();
    }

    public void setAssignEveryShift(HardMediumSoftLongScore assignEveryShift) {
        this.$$_hibernate_write_assignEveryShift(assignEveryShift);
    }

    public HardMediumSoftLongScore getNotOriginalEmployee() {
        return this.$$_hibernate_read_notOriginalEmployee();
    }

    public void setNotOriginalEmployee(HardMediumSoftLongScore notOriginalEmployee) {
        this.$$_hibernate_write_notOriginalEmployee(notOriginalEmployee);
    }

    public HardMediumSoftLongScore getUndesiredTimeSlot() {
        return this.$$_hibernate_read_undesiredTimeSlot();
    }

    public void setUndesiredTimeSlot(HardMediumSoftLongScore undesiredTimeSlot) {
        this.$$_hibernate_write_undesiredTimeSlot(undesiredTimeSlot);
    }

    public HardMediumSoftLongScore getDesiredTimeSlot() {
        return this.$$_hibernate_read_desiredTimeSlot();
    }

    public void setDesiredTimeSlot(HardMediumSoftLongScore desiredTimeSlot) {
        this.$$_hibernate_write_desiredTimeSlot(desiredTimeSlot);
    }

    public HardMediumSoftLongScore getNotRotationEmployee() {
        return this.$$_hibernate_read_notRotationEmployee();
    }

    public void setNotRotationEmployee(HardMediumSoftLongScore notRotationEmployee) {
        this.$$_hibernate_write_notRotationEmployee(notRotationEmployee);
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        RosterConstraintConfiguration rosterConstraintConfiguration = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        RosterConstraintConfiguration rosterConstraintConfiguration = this;
        rosterConstraintConfiguration = null;
        rosterConstraintConfiguration = NoopCollectionTracker.INSTANCE;
        return rosterConstraintConfiguration;
    }

    public DayOfWeek $$_hibernate_read_weekStartDay() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.weekStartDay = (DayOfWeek)this.$$_hibernate_getInterceptor().readObject((Object)this, "weekStartDay", (Object)this.weekStartDay);
        }
        return this.weekStartDay;
    }

    public void $$_hibernate_write_weekStartDay(DayOfWeek dayOfWeek) {
        if (!Objects.deepEquals(dayOfWeek, this.weekStartDay)) {
            this.$$_hibernate_trackChange("weekStartDay");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.weekStartDay = (DayOfWeek)this.$$_hibernate_getInterceptor().writeObject((Object)this, "weekStartDay", (Object)this.weekStartDay, (Object)dayOfWeek);
            return;
        }
        this.weekStartDay = dayOfWeek;
    }

    public HardMediumSoftLongScore $$_hibernate_read_requiredSkill() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requiredSkill = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().readObject((Object)this, "requiredSkill", (Object)this.requiredSkill);
        }
        return this.requiredSkill;
    }

    public void $$_hibernate_write_requiredSkill(HardMediumSoftLongScore hardMediumSoftLongScore) {
        if (!Objects.deepEquals(hardMediumSoftLongScore, this.requiredSkill)) {
            this.$$_hibernate_trackChange("requiredSkill");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requiredSkill = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().writeObject((Object)this, "requiredSkill", (Object)this.requiredSkill, (Object)hardMediumSoftLongScore);
            return;
        }
        this.requiredSkill = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $$_hibernate_read_unavailableTimeSlot() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.unavailableTimeSlot = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().readObject((Object)this, "unavailableTimeSlot", (Object)this.unavailableTimeSlot);
        }
        return this.unavailableTimeSlot;
    }

    public void $$_hibernate_write_unavailableTimeSlot(HardMediumSoftLongScore hardMediumSoftLongScore) {
        if (!Objects.deepEquals(hardMediumSoftLongScore, this.unavailableTimeSlot)) {
            this.$$_hibernate_trackChange("unavailableTimeSlot");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.unavailableTimeSlot = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().writeObject((Object)this, "unavailableTimeSlot", (Object)this.unavailableTimeSlot, (Object)hardMediumSoftLongScore);
            return;
        }
        this.unavailableTimeSlot = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $$_hibernate_read_noOverlappingShifts() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.noOverlappingShifts = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().readObject((Object)this, "noOverlappingShifts", (Object)this.noOverlappingShifts);
        }
        return this.noOverlappingShifts;
    }

    public void $$_hibernate_write_noOverlappingShifts(HardMediumSoftLongScore hardMediumSoftLongScore) {
        if (!Objects.deepEquals(hardMediumSoftLongScore, this.noOverlappingShifts)) {
            this.$$_hibernate_trackChange("noOverlappingShifts");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.noOverlappingShifts = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().writeObject((Object)this, "noOverlappingShifts", (Object)this.noOverlappingShifts, (Object)hardMediumSoftLongScore);
            return;
        }
        this.noOverlappingShifts = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $$_hibernate_read_noMoreThan2ConsecutiveShifts() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.noMoreThan2ConsecutiveShifts = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().readObject((Object)this, "noMoreThan2ConsecutiveShifts", (Object)this.noMoreThan2ConsecutiveShifts);
        }
        return this.noMoreThan2ConsecutiveShifts;
    }

    public void $$_hibernate_write_noMoreThan2ConsecutiveShifts(HardMediumSoftLongScore hardMediumSoftLongScore) {
        if (!Objects.deepEquals(hardMediumSoftLongScore, this.noMoreThan2ConsecutiveShifts)) {
            this.$$_hibernate_trackChange("noMoreThan2ConsecutiveShifts");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.noMoreThan2ConsecutiveShifts = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().writeObject((Object)this, "noMoreThan2ConsecutiveShifts", (Object)this.noMoreThan2ConsecutiveShifts, (Object)hardMediumSoftLongScore);
            return;
        }
        this.noMoreThan2ConsecutiveShifts = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $$_hibernate_read_breakBetweenNonConsecutiveShiftsAtLeast10Hours() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.breakBetweenNonConsecutiveShiftsAtLeast10Hours = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().readObject((Object)this, "breakBetweenNonConsecutiveShiftsAtLeast10Hours", (Object)this.breakBetweenNonConsecutiveShiftsAtLeast10Hours);
        }
        return this.breakBetweenNonConsecutiveShiftsAtLeast10Hours;
    }

    public void $$_hibernate_write_breakBetweenNonConsecutiveShiftsAtLeast10Hours(HardMediumSoftLongScore hardMediumSoftLongScore) {
        if (!Objects.deepEquals(hardMediumSoftLongScore, this.breakBetweenNonConsecutiveShiftsAtLeast10Hours)) {
            this.$$_hibernate_trackChange("breakBetweenNonConsecutiveShiftsAtLeast10Hours");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.breakBetweenNonConsecutiveShiftsAtLeast10Hours = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().writeObject((Object)this, "breakBetweenNonConsecutiveShiftsAtLeast10Hours", (Object)this.breakBetweenNonConsecutiveShiftsAtLeast10Hours, (Object)hardMediumSoftLongScore);
            return;
        }
        this.breakBetweenNonConsecutiveShiftsAtLeast10Hours = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $$_hibernate_read_contractMaximumDailyMinutes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.contractMaximumDailyMinutes = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().readObject((Object)this, "contractMaximumDailyMinutes", (Object)this.contractMaximumDailyMinutes);
        }
        return this.contractMaximumDailyMinutes;
    }

    public void $$_hibernate_write_contractMaximumDailyMinutes(HardMediumSoftLongScore hardMediumSoftLongScore) {
        if (!Objects.deepEquals(hardMediumSoftLongScore, this.contractMaximumDailyMinutes)) {
            this.$$_hibernate_trackChange("contractMaximumDailyMinutes");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.contractMaximumDailyMinutes = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().writeObject((Object)this, "contractMaximumDailyMinutes", (Object)this.contractMaximumDailyMinutes, (Object)hardMediumSoftLongScore);
            return;
        }
        this.contractMaximumDailyMinutes = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $$_hibernate_read_contractMaximumWeeklyMinutes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.contractMaximumWeeklyMinutes = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().readObject((Object)this, "contractMaximumWeeklyMinutes", (Object)this.contractMaximumWeeklyMinutes);
        }
        return this.contractMaximumWeeklyMinutes;
    }

    public void $$_hibernate_write_contractMaximumWeeklyMinutes(HardMediumSoftLongScore hardMediumSoftLongScore) {
        if (!Objects.deepEquals(hardMediumSoftLongScore, this.contractMaximumWeeklyMinutes)) {
            this.$$_hibernate_trackChange("contractMaximumWeeklyMinutes");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.contractMaximumWeeklyMinutes = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().writeObject((Object)this, "contractMaximumWeeklyMinutes", (Object)this.contractMaximumWeeklyMinutes, (Object)hardMediumSoftLongScore);
            return;
        }
        this.contractMaximumWeeklyMinutes = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $$_hibernate_read_contractMaximumMonthlyMinutes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.contractMaximumMonthlyMinutes = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().readObject((Object)this, "contractMaximumMonthlyMinutes", (Object)this.contractMaximumMonthlyMinutes);
        }
        return this.contractMaximumMonthlyMinutes;
    }

    public void $$_hibernate_write_contractMaximumMonthlyMinutes(HardMediumSoftLongScore hardMediumSoftLongScore) {
        if (!Objects.deepEquals(hardMediumSoftLongScore, this.contractMaximumMonthlyMinutes)) {
            this.$$_hibernate_trackChange("contractMaximumMonthlyMinutes");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.contractMaximumMonthlyMinutes = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().writeObject((Object)this, "contractMaximumMonthlyMinutes", (Object)this.contractMaximumMonthlyMinutes, (Object)hardMediumSoftLongScore);
            return;
        }
        this.contractMaximumMonthlyMinutes = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $$_hibernate_read_contractMaximumYearlyMinutes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.contractMaximumYearlyMinutes = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().readObject((Object)this, "contractMaximumYearlyMinutes", (Object)this.contractMaximumYearlyMinutes);
        }
        return this.contractMaximumYearlyMinutes;
    }

    public void $$_hibernate_write_contractMaximumYearlyMinutes(HardMediumSoftLongScore hardMediumSoftLongScore) {
        if (!Objects.deepEquals(hardMediumSoftLongScore, this.contractMaximumYearlyMinutes)) {
            this.$$_hibernate_trackChange("contractMaximumYearlyMinutes");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.contractMaximumYearlyMinutes = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().writeObject((Object)this, "contractMaximumYearlyMinutes", (Object)this.contractMaximumYearlyMinutes, (Object)hardMediumSoftLongScore);
            return;
        }
        this.contractMaximumYearlyMinutes = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $$_hibernate_read_assignEveryShift() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.assignEveryShift = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().readObject((Object)this, "assignEveryShift", (Object)this.assignEveryShift);
        }
        return this.assignEveryShift;
    }

    public void $$_hibernate_write_assignEveryShift(HardMediumSoftLongScore hardMediumSoftLongScore) {
        if (!Objects.deepEquals(hardMediumSoftLongScore, this.assignEveryShift)) {
            this.$$_hibernate_trackChange("assignEveryShift");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.assignEveryShift = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().writeObject((Object)this, "assignEveryShift", (Object)this.assignEveryShift, (Object)hardMediumSoftLongScore);
            return;
        }
        this.assignEveryShift = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $$_hibernate_read_notOriginalEmployee() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notOriginalEmployee = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().readObject((Object)this, "notOriginalEmployee", (Object)this.notOriginalEmployee);
        }
        return this.notOriginalEmployee;
    }

    public void $$_hibernate_write_notOriginalEmployee(HardMediumSoftLongScore hardMediumSoftLongScore) {
        if (!Objects.deepEquals(hardMediumSoftLongScore, this.notOriginalEmployee)) {
            this.$$_hibernate_trackChange("notOriginalEmployee");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notOriginalEmployee = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().writeObject((Object)this, "notOriginalEmployee", (Object)this.notOriginalEmployee, (Object)hardMediumSoftLongScore);
            return;
        }
        this.notOriginalEmployee = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $$_hibernate_read_undesiredTimeSlot() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.undesiredTimeSlot = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().readObject((Object)this, "undesiredTimeSlot", (Object)this.undesiredTimeSlot);
        }
        return this.undesiredTimeSlot;
    }

    public void $$_hibernate_write_undesiredTimeSlot(HardMediumSoftLongScore hardMediumSoftLongScore) {
        if (!Objects.deepEquals(hardMediumSoftLongScore, this.undesiredTimeSlot)) {
            this.$$_hibernate_trackChange("undesiredTimeSlot");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.undesiredTimeSlot = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().writeObject((Object)this, "undesiredTimeSlot", (Object)this.undesiredTimeSlot, (Object)hardMediumSoftLongScore);
            return;
        }
        this.undesiredTimeSlot = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $$_hibernate_read_desiredTimeSlot() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.desiredTimeSlot = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().readObject((Object)this, "desiredTimeSlot", (Object)this.desiredTimeSlot);
        }
        return this.desiredTimeSlot;
    }

    public void $$_hibernate_write_desiredTimeSlot(HardMediumSoftLongScore hardMediumSoftLongScore) {
        if (!Objects.deepEquals(hardMediumSoftLongScore, this.desiredTimeSlot)) {
            this.$$_hibernate_trackChange("desiredTimeSlot");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.desiredTimeSlot = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().writeObject((Object)this, "desiredTimeSlot", (Object)this.desiredTimeSlot, (Object)hardMediumSoftLongScore);
            return;
        }
        this.desiredTimeSlot = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $$_hibernate_read_notRotationEmployee() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notRotationEmployee = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().readObject((Object)this, "notRotationEmployee", (Object)this.notRotationEmployee);
        }
        return this.notRotationEmployee;
    }

    public void $$_hibernate_write_notRotationEmployee(HardMediumSoftLongScore hardMediumSoftLongScore) {
        if (!Objects.deepEquals(hardMediumSoftLongScore, this.notRotationEmployee)) {
            this.$$_hibernate_trackChange("notRotationEmployee");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notRotationEmployee = (HardMediumSoftLongScore)this.$$_hibernate_getInterceptor().writeObject((Object)this, "notRotationEmployee", (Object)this.notRotationEmployee, (Object)hardMediumSoftLongScore);
            return;
        }
        this.notRotationEmployee = hardMediumSoftLongScore;
    }

    @Override
    public Long $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_id((Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)super.$$_hibernate_read_id()));
        }
        return super.$$_hibernate_read_id();
    }

    @Override
    public void $$_hibernate_write_id(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_id((Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)super.$$_hibernate_read_id(), (Object)l));
            return;
        }
        super.$$_hibernate_write_id(l);
    }

    @Override
    public Integer $$_hibernate_read_tenantId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_tenantId((Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "tenantId", (Object)super.$$_hibernate_read_tenantId()));
        }
        return super.$$_hibernate_read_tenantId();
    }

    @Override
    public void $$_hibernate_write_tenantId(Integer n) {
        if (!Objects.deepEquals(n, ((AbstractPersistable)this).$$_hibernate_read_tenantId())) {
            this.$$_hibernate_trackChange("tenantId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_tenantId((Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "tenantId", (Object)super.$$_hibernate_read_tenantId(), (Object)n));
            return;
        }
        super.$$_hibernate_write_tenantId(n);
    }

    @Override
    public Long $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_version((Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "version", (Object)super.$$_hibernate_read_version()));
        }
        return super.$$_hibernate_read_version();
    }

    @Override
    public void $$_hibernate_write_version(Long l) {
        if (!Objects.deepEquals(l, ((AbstractPersistable)this).$$_hibernate_read_version())) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_version((Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "version", (Object)super.$$_hibernate_read_version(), (Object)l));
            return;
        }
        super.$$_hibernate_write_version(l);
    }

    public HardMediumSoftLongScore $get$optaplanner$__field$__requiredSkill() {
        return this.requiredSkill;
    }

    public void $set$optaplanner$__field$__requiredSkill(HardMediumSoftLongScore hardMediumSoftLongScore) {
        this.requiredSkill = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $get$optaplanner$__field$__unavailableTimeSlot() {
        return this.unavailableTimeSlot;
    }

    public void $set$optaplanner$__field$__unavailableTimeSlot(HardMediumSoftLongScore hardMediumSoftLongScore) {
        this.unavailableTimeSlot = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $get$optaplanner$__field$__noOverlappingShifts() {
        return this.noOverlappingShifts;
    }

    public void $set$optaplanner$__field$__noOverlappingShifts(HardMediumSoftLongScore hardMediumSoftLongScore) {
        this.noOverlappingShifts = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $get$optaplanner$__field$__noMoreThan2ConsecutiveShifts() {
        return this.noMoreThan2ConsecutiveShifts;
    }

    public void $set$optaplanner$__field$__noMoreThan2ConsecutiveShifts(HardMediumSoftLongScore hardMediumSoftLongScore) {
        this.noMoreThan2ConsecutiveShifts = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $get$optaplanner$__field$__breakBetweenNonConsecutiveShiftsAtLeast10Hours() {
        return this.breakBetweenNonConsecutiveShiftsAtLeast10Hours;
    }

    public void $set$optaplanner$__field$__breakBetweenNonConsecutiveShiftsAtLeast10Hours(HardMediumSoftLongScore hardMediumSoftLongScore) {
        this.breakBetweenNonConsecutiveShiftsAtLeast10Hours = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $get$optaplanner$__field$__contractMaximumDailyMinutes() {
        return this.contractMaximumDailyMinutes;
    }

    public void $set$optaplanner$__field$__contractMaximumDailyMinutes(HardMediumSoftLongScore hardMediumSoftLongScore) {
        this.contractMaximumDailyMinutes = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $get$optaplanner$__field$__contractMaximumWeeklyMinutes() {
        return this.contractMaximumWeeklyMinutes;
    }

    public void $set$optaplanner$__field$__contractMaximumWeeklyMinutes(HardMediumSoftLongScore hardMediumSoftLongScore) {
        this.contractMaximumWeeklyMinutes = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $get$optaplanner$__field$__contractMaximumMonthlyMinutes() {
        return this.contractMaximumMonthlyMinutes;
    }

    public void $set$optaplanner$__field$__contractMaximumMonthlyMinutes(HardMediumSoftLongScore hardMediumSoftLongScore) {
        this.contractMaximumMonthlyMinutes = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $get$optaplanner$__field$__contractMaximumYearlyMinutes() {
        return this.contractMaximumYearlyMinutes;
    }

    public void $set$optaplanner$__field$__contractMaximumYearlyMinutes(HardMediumSoftLongScore hardMediumSoftLongScore) {
        this.contractMaximumYearlyMinutes = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $get$optaplanner$__field$__assignEveryShift() {
        return this.assignEveryShift;
    }

    public void $set$optaplanner$__field$__assignEveryShift(HardMediumSoftLongScore hardMediumSoftLongScore) {
        this.assignEveryShift = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $get$optaplanner$__field$__notOriginalEmployee() {
        return this.notOriginalEmployee;
    }

    public void $set$optaplanner$__field$__notOriginalEmployee(HardMediumSoftLongScore hardMediumSoftLongScore) {
        this.notOriginalEmployee = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $get$optaplanner$__field$__undesiredTimeSlot() {
        return this.undesiredTimeSlot;
    }

    public void $set$optaplanner$__field$__undesiredTimeSlot(HardMediumSoftLongScore hardMediumSoftLongScore) {
        this.undesiredTimeSlot = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $get$optaplanner$__field$__desiredTimeSlot() {
        return this.desiredTimeSlot;
    }

    public void $set$optaplanner$__field$__desiredTimeSlot(HardMediumSoftLongScore hardMediumSoftLongScore) {
        this.desiredTimeSlot = hardMediumSoftLongScore;
    }

    public HardMediumSoftLongScore $get$optaplanner$__field$__notRotationEmployee() {
        return this.notRotationEmployee;
    }

    public void $set$optaplanner$__field$__notRotationEmployee(HardMediumSoftLongScore hardMediumSoftLongScore) {
        this.notRotationEmployee = hardMediumSoftLongScore;
    }
}

