/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.rotation;

import java.time.DayOfWeek;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityNotFoundException;
import javax.transaction.Transactional;
import javax.validation.Valid;
import javax.validation.Validator;
import javax.validation.constraints.Min;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.rotation.Seat;
import org.optaweb.employeerostering.domain.rotation.TimeBucket;
import org.optaweb.employeerostering.domain.rotation.view.TimeBucketView;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.service.common.AbstractRestService;
import org.optaweb.employeerostering.service.employee.EmployeeService;
import org.optaweb.employeerostering.service.roster.RosterService;
import org.optaweb.employeerostering.service.rotation.TimeBucketRepository;
import org.optaweb.employeerostering.service.skill.SkillService;
import org.optaweb.employeerostering.service.spot.SpotService;
import org.optaweb.employeerostering.service.tenant.TenantService;

@ApplicationScoped
public class RotationService
extends AbstractRestService {
    TimeBucketRepository timeBucketRepository;
    RosterService rosterService;
    TenantService tenantService;
    SpotService spotService;
    SkillService skillService;
    EmployeeService employeeService;

    public RotationService() {
    }

    @Inject
    public RotationService(Validator validator, TimeBucketRepository timeBucketRepository, RosterService rosterService, TenantService tenantService, SpotService spotService, SkillService skillService, EmployeeService employeeService) {
        super(validator);
        this.timeBucketRepository = timeBucketRepository;
        this.tenantService = tenantService;
        this.rosterService = rosterService;
        this.spotService = spotService;
        this.skillService = skillService;
        this.employeeService = employeeService;
    }

    private Set<Skill> getRequiredSkillSet(Integer tenantId, TimeBucketView timeBucketView) {
        return timeBucketView.getAdditionalSkillSetIdList().stream().map(id -> this.skillService.getSkill(tenantId, (Long)id)).collect(Collectors.toCollection(HashSet::new));
    }

    public List<TimeBucketView> getTimeBucketList(@Min(value=0L) @Min(value=0L) Integer tenantId) {
        return this.timeBucketRepository.findAllByTenantId(tenantId).stream().map(TimeBucketView::new).collect(Collectors.toList());
    }

    public TimeBucketView getTimeBucket(@Min(value=0L) @Min(value=0L) Integer tenantId, @Min(value=0L) @Min(value=0L) Long id) {
        TimeBucket timeBucket = (TimeBucket)this.timeBucketRepository.findByIdOptional((Object)id).orElseThrow(() -> new EntityNotFoundException("No TimeBucket entity found with ID (" + id + ")."));
        this.validateBean(tenantId, timeBucket);
        return new TimeBucketView(timeBucket);
    }

    @Transactional
    public Boolean deleteTimeBucket(@Min(value=0L) @Min(value=0L) Integer tenantId, @Min(value=0L) @Min(value=0L) Long id) {
        Optional timeBucketOptional = this.timeBucketRepository.findByIdOptional((Object)id);
        if (!timeBucketOptional.isPresent()) {
            return false;
        }
        this.validateBean(tenantId, (AbstractPersistable)timeBucketOptional.get());
        this.timeBucketRepository.deleteById((Object)id);
        return true;
    }

    @Transactional
    public TimeBucketView createTimeBucket(@Min(value=0L) @Min(value=0L) Integer tenantId, @Valid TimeBucketView timeBucketView) {
        TimeBucket timeBucket;
        Spot spot = this.spotService.getSpot(tenantId, timeBucketView.getSpotId());
        Set<Skill> additionalSkillSet = this.getRequiredSkillSet(tenantId, timeBucketView);
        Integer rotationLength = this.rosterService.getRosterState(tenantId).getRotationLength();
        HashSet<DayOfWeek> repeatOnDaySet = new HashSet<DayOfWeek>(timeBucketView.getRepeatOnDaySetList());
        if (timeBucketView.getSeatList() != null) {
            List<Seat> seatList = timeBucketView.getSeatList().stream().map(seat -> {
                if (seat.getEmployeeId() != null) {
                    Employee employee = this.employeeService.getEmployee(tenantId, seat.getEmployeeId());
                    return new Seat(seat.getDayInRotation(), employee);
                }
                return new Seat(seat.getDayInRotation(), null);
            }).collect(Collectors.toList());
            timeBucket = new TimeBucket(timeBucketView.getTenantId(), spot, timeBucketView.getStartTime(), timeBucketView.getEndTime(), additionalSkillSet, repeatOnDaySet, seatList);
        } else {
            DayOfWeek startOfWeek = this.tenantService.getRosterConstraintConfiguration(tenantId).getWeekStartDay();
            timeBucket = new TimeBucket(timeBucketView.getTenantId(), spot, timeBucketView.getStartTime(), timeBucketView.getEndTime(), additionalSkillSet, repeatOnDaySet, startOfWeek, rotationLength);
        }
        this.validateBean(tenantId, timeBucket);
        this.timeBucketRepository.persist(timeBucket);
        return new TimeBucketView(timeBucket);
    }

    @Transactional
    public TimeBucketView updateTimeBucket(@Min(value=0L) @Min(value=0L) Integer tenantId, @Valid TimeBucketView timeBucketView) {
        TimeBucket newTimeBucket;
        Spot spot = this.spotService.getSpot(tenantId, timeBucketView.getSpotId());
        Set<Skill> additionalSkillSet = this.getRequiredSkillSet(tenantId, timeBucketView);
        Integer rotationLength = this.rosterService.getRosterState(tenantId).getRotationLength();
        HashSet<DayOfWeek> repeatOnDaySet = new HashSet<DayOfWeek>(timeBucketView.getRepeatOnDaySetList());
        if (timeBucketView.getSeatList() != null) {
            List<Seat> seatList = timeBucketView.getSeatList().stream().map(seat -> {
                if (seat.getEmployeeId() != null) {
                    Employee employee = this.employeeService.getEmployee(tenantId, seat.getEmployeeId());
                    return new Seat(seat.getDayInRotation(), employee);
                }
                return new Seat(seat.getDayInRotation(), null);
            }).collect(Collectors.toList());
            newTimeBucket = new TimeBucket(timeBucketView.getTenantId(), spot, timeBucketView.getStartTime(), timeBucketView.getEndTime(), additionalSkillSet, repeatOnDaySet, seatList);
        } else {
            DayOfWeek startOfWeek = this.tenantService.getRosterConstraintConfiguration(tenantId).getWeekStartDay();
            newTimeBucket = new TimeBucket(timeBucketView.getTenantId(), spot, timeBucketView.getStartTime(), timeBucketView.getEndTime(), additionalSkillSet, repeatOnDaySet, startOfWeek, rotationLength);
        }
        newTimeBucket.setId(timeBucketView.getId());
        newTimeBucket.setVersion(timeBucketView.getVersion());
        this.validateBean(tenantId, newTimeBucket);
        TimeBucket oldTimeBucket = (TimeBucket)this.timeBucketRepository.findByIdOptional((Object)newTimeBucket.getId()).orElseThrow(() -> new EntityNotFoundException("TimeBucket entity with ID (" + newTimeBucket.getId() + ") not found."));
        if (!oldTimeBucket.getTenantId().equals(newTimeBucket.getTenantId())) {
            throw new IllegalStateException("TimeBucket entity with tenantId (" + oldTimeBucket.getTenantId() + ") cannot change tenants.");
        }
        oldTimeBucket.setValuesFromTimeBucket(newTimeBucket);
        this.timeBucketRepository.persistAndFlush(oldTimeBucket);
        return new TimeBucketView(oldTimeBucket);
    }
}

