/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.spot;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.spot.view.SpotView;
import org.optaweb.employeerostering.service.spot.SpotService;

@Path(value="/rest/tenant/{tenantId}/spot")
@ApplicationScoped
@Tag(name="Spot")
public class SpotController {
    private final SpotService spotService;

    public SpotController() {
    }

    @Inject
    public SpotController(SpotService spotService) {
        this.spotService = spotService;
    }

    @GET
    @Path(value="/")
    @Operation(summary="List Spots", description="Get a list of all spots")
    public List<Spot> getSpotList(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return this.spotService.getSpotList(tenantId);
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get Spot", description="Gets a spot by id")
    public Spot getSpot(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @PathParam(value="id") @Min(value=0L) @Min(value=0L) Long id) {
        return this.spotService.getSpot(tenantId, id);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(summary="Delete Spot", description="Deletes a spot by id")
    public Boolean deleteSpot(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @PathParam(value="id") @Min(value=0L) @Min(value=0L) Long id) {
        return this.spotService.deleteSpot(tenantId, id);
    }

    @POST
    @Path(value="/add")
    @Operation(summary="Add Spot", description="Adds a new spot")
    public Spot createSpot(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @Valid SpotView spotView) {
        return this.spotService.createSpot(tenantId, spotView);
    }

    @POST
    @Path(value="/update")
    @Operation(summary="Update Spot", description="Updates a spot")
    public Spot updateSpot(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @Valid SpotView spotView) {
        return this.spotService.updateSpot(tenantId, spotView);
    }
}

