/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.inverserelation;

import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.ListVariableListener;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class SingletonListInverseVariableListener<Solution_>
implements ListVariableListener<Solution_, Object>,
SingletonInverseVariableSupply {
    protected final InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor;
    protected final ListVariableDescriptor<Solution_> sourceVariableDescriptor;

    public SingletonListInverseVariableListener(InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor, ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public void beforeEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
        for (Object element : this.sourceVariableDescriptor.getListVariable(entity)) {
            this.setInverse((InnerScoreDirector)scoreDirector, element, entity, null);
        }
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        for (Object element : this.sourceVariableDescriptor.getListVariable(entity)) {
            this.setInverse(innerScoreDirector, element, null, entity);
        }
    }

    @Override
    public void beforeElementAdded(ScoreDirector<Solution_> scoreDirector, Object entity, int index) {
    }

    @Override
    public void afterElementAdded(ScoreDirector<Solution_> scoreDirector, Object entity, int index) {
        this.setInverse((InnerScoreDirector)scoreDirector, this.sourceVariableDescriptor.getElement(entity, index), entity, null);
    }

    @Override
    public void beforeElementRemoved(ScoreDirector<Solution_> scoreDirector, Object entity, int index) {
        this.setInverse((InnerScoreDirector)scoreDirector, this.sourceVariableDescriptor.getElement(entity, index), null, entity);
    }

    @Override
    public void afterElementRemoved(ScoreDirector<Solution_> scoreDirector, Object entity, int index) {
    }

    @Override
    public void beforeElementMoved(ScoreDirector<Solution_> scoreDirector, Object sourceEntity, int sourceIndex, Object destinationEntity, int destinationIndex) {
    }

    @Override
    public void afterElementMoved(ScoreDirector<Solution_> scoreDirector, Object sourceEntity, int sourceIndex, Object destinationEntity, int destinationIndex) {
        if (sourceEntity == destinationEntity) {
            return;
        }
        this.setInverse((InnerScoreDirector)scoreDirector, this.sourceVariableDescriptor.getElement(destinationEntity, destinationIndex), destinationEntity, sourceEntity);
    }

    private void setInverse(InnerScoreDirector<Solution_, ?> scoreDirector, Object element, Object inverseEntity, Object expectedOldInverseEntity) {
        Object oldInverseEntity = this.shadowVariableDescriptor.getValue(element);
        if (oldInverseEntity == inverseEntity) {
            return;
        }
        if (oldInverseEntity != expectedOldInverseEntity) {
            throw new IllegalStateException("The entity (" + inverseEntity + ") has a list variable (" + this.sourceVariableDescriptor.getVariableName() + ") and one of its elements (" + element + ") which has a shadow variable (" + this.shadowVariableDescriptor.getVariableName() + ") has an oldInverseEntity (" + oldInverseEntity + ") which is not that entity.\nVerify the consistency of your input problem for that shadow variable.");
        }
        scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
        this.shadowVariableDescriptor.setValue(element, inverseEntity);
        scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
    }

    @Override
    public Object getInverseSingleton(Object planningValue) {
        return this.shadowVariableDescriptor.getValue(planningValue);
    }
}

