/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener.support;

import java.util.ArrayDeque;
import java.util.Collection;
import org.optaplanner.core.api.domain.variable.AbstractVariableListener;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.ListVariableListener;
import org.optaplanner.core.impl.domain.variable.listener.support.EntityNotifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.EntityNotification;
import org.optaplanner.core.impl.domain.variable.listener.support.ListVariableListenerNotifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.Notification;
import org.optaplanner.core.impl.domain.variable.listener.support.SmallScalingOrderedSet;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotifiable;

abstract class AbstractNotifiable<Solution_, T extends AbstractVariableListener<Solution_, Object>>
implements EntityNotifiable<Solution_> {
    private final ScoreDirector<Solution_> scoreDirector;
    private final int globalOrder;
    private final T variableListener;
    private final Collection<Notification<Solution_, ? super T>> notificationQueue;

    static <Solution_> EntityNotifiable<Solution_> buildNotifiable(ScoreDirector<Solution_> scoreDirector, AbstractVariableListener<Solution_, Object> variableListener, int globalOrder) {
        if (variableListener instanceof ListVariableListener) {
            return new ListVariableListenerNotifiable<Solution_>(scoreDirector, (ListVariableListener)variableListener, globalOrder);
        }
        return new VariableListenerNotifiable<Solution_>(scoreDirector, (VariableListener)variableListener, globalOrder);
    }

    protected AbstractNotifiable(ScoreDirector<Solution_> scoreDirector, T variableListener, int globalOrder) {
        this.scoreDirector = scoreDirector;
        this.globalOrder = globalOrder;
        this.variableListener = variableListener;
        this.notificationQueue = variableListener.requiresUniqueEntityEvents() ? new SmallScalingOrderedSet<Notification<Solution_, ? super T>>() : new ArrayDeque<Notification<Solution_, ? super T>>();
    }

    @Override
    public void addNotification(EntityNotification<Solution_> notification) {
        if (this.notificationQueue.add(notification)) {
            notification.triggerBefore(this.variableListener, this.scoreDirector);
        }
    }

    public void addNotification(Notification<Solution_, T> notification) {
        if (this.notificationQueue.add(notification)) {
            notification.triggerBefore(this.variableListener, this.scoreDirector);
        }
    }

    @Override
    public void resetWorkingSolution() {
        this.variableListener.resetWorkingSolution(this.scoreDirector);
    }

    @Override
    public void closeVariableListener() {
        this.variableListener.close();
    }

    @Override
    public void triggerAllNotifications() {
        int notifiedCount = 0;
        for (Notification<Solution_, T> notification : this.notificationQueue) {
            notification.triggerAfter(this.variableListener, this.scoreDirector);
            ++notifiedCount;
        }
        if (notifiedCount != this.notificationQueue.size()) {
            throw new IllegalStateException("The variableListener (" + this.variableListener.getClass() + ") has been notified with notifiedCount (" + notifiedCount + ") but after being triggered, its notificationCount (" + this.notificationQueue.size() + ") is different.\nMaybe that variableListener (" + this.variableListener.getClass() + ") changed an upstream shadow variable (which is illegal).");
        }
        this.notificationQueue.clear();
    }

    public String toString() {
        return "(" + this.globalOrder + ") " + this.variableListener;
    }
}

