/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.thread.ApplyStepOperation;
import org.optaplanner.core.impl.heuristic.thread.DestroyOperation;
import org.optaplanner.core.impl.heuristic.thread.MoveEvaluationOperation;
import org.optaplanner.core.impl.heuristic.thread.MoveThreadOperation;
import org.optaplanner.core.impl.heuristic.thread.MoveThreadRunner;
import org.optaplanner.core.impl.heuristic.thread.OrderByMoveIndexBlockingQueue;
import org.optaplanner.core.impl.heuristic.thread.SetupOperation;
import org.optaplanner.core.impl.localsearch.decider.LocalSearchDecider;
import org.optaplanner.core.impl.localsearch.decider.acceptor.Acceptor;
import org.optaplanner.core.impl.localsearch.decider.forager.LocalSearchForager;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.optaplanner.core.impl.solver.thread.ThreadUtils;

public class MultiThreadedLocalSearchDecider<Solution_>
extends LocalSearchDecider<Solution_> {
    protected final ThreadFactory threadFactory;
    protected final int moveThreadCount;
    protected final int selectedMoveBufferSize;
    protected boolean assertStepScoreFromScratch = false;
    protected boolean assertExpectedStepScore = false;
    protected boolean assertShadowVariablesAreNotStaleAfterStep = false;
    protected BlockingQueue<MoveThreadOperation<Solution_>> operationQueue;
    protected OrderByMoveIndexBlockingQueue<Solution_> resultQueue;
    protected CyclicBarrier moveThreadBarrier;
    protected ExecutorService executor;
    protected List<MoveThreadRunner<Solution_, ?>> moveThreadRunnerList;

    public MultiThreadedLocalSearchDecider(String logIndentation, Termination<Solution_> termination, MoveSelector<Solution_> moveSelector, Acceptor<Solution_> acceptor, LocalSearchForager<Solution_> forager, ThreadFactory threadFactory, int moveThreadCount, int selectedMoveBufferSize) {
        super(logIndentation, termination, moveSelector, acceptor, forager);
        this.threadFactory = threadFactory;
        this.moveThreadCount = moveThreadCount;
        this.selectedMoveBufferSize = selectedMoveBufferSize;
    }

    public void setAssertStepScoreFromScratch(boolean assertStepScoreFromScratch) {
        this.assertStepScoreFromScratch = assertStepScoreFromScratch;
    }

    public void setAssertExpectedStepScore(boolean assertExpectedStepScore) {
        this.assertExpectedStepScore = assertExpectedStepScore;
    }

    public void setAssertShadowVariablesAreNotStaleAfterStep(boolean assertShadowVariablesAreNotStaleAfterStep) {
        this.assertShadowVariablesAreNotStaleAfterStep = assertShadowVariablesAreNotStaleAfterStep;
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.operationQueue = new ArrayBlockingQueue<MoveThreadOperation<Solution_>>(this.selectedMoveBufferSize + this.moveThreadCount + this.moveThreadCount);
        this.resultQueue = new OrderByMoveIndexBlockingQueue(this.selectedMoveBufferSize + this.moveThreadCount);
        this.moveThreadBarrier = new CyclicBarrier(this.moveThreadCount);
        InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
        this.executor = this.createThreadPoolExecutor();
        this.moveThreadRunnerList = new ArrayList(this.moveThreadCount);
        for (int moveThreadIndex = 0; moveThreadIndex < this.moveThreadCount; ++moveThreadIndex) {
            MoveThreadRunner moveThreadRunner = new MoveThreadRunner(this.logIndentation, moveThreadIndex, true, this.operationQueue, this.resultQueue, this.moveThreadBarrier, this.assertMoveScoreFromScratch, this.assertExpectedUndoMoveScore, this.assertStepScoreFromScratch, this.assertExpectedStepScore, this.assertShadowVariablesAreNotStaleAfterStep);
            this.moveThreadRunnerList.add(moveThreadRunner);
            this.executor.submit(moveThreadRunner);
            this.operationQueue.add(new SetupOperation(scoreDirector));
        }
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        DestroyOperation destroyOperation = new DestroyOperation();
        for (int i = 0; i < this.moveThreadCount; ++i) {
            this.operationQueue.add(destroyOperation);
        }
        this.shutdownMoveThreads();
        long childThreadsScoreCalculationCount = 0L;
        for (MoveThreadRunner<Solution_, ?> moveThreadRunner : this.moveThreadRunnerList) {
            childThreadsScoreCalculationCount += moveThreadRunner.getCalculationCount();
        }
        phaseScope.addChildThreadsScoreCalculationCount(childThreadsScoreCalculationCount);
        this.operationQueue = null;
        this.resultQueue = null;
        this.moveThreadRunnerList = null;
    }

    @Override
    public void solvingError(SolverScope<Solution_> solverScope, Exception exception) {
        super.solvingError(solverScope, exception);
        this.shutdownMoveThreads();
    }

    protected ExecutorService createThreadPoolExecutor() {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(this.moveThreadCount, this.threadFactory);
        if (threadPoolExecutor.getMaximumPoolSize() < this.moveThreadCount) {
            throw new IllegalStateException("The threadPoolExecutor's maximumPoolSize (" + threadPoolExecutor.getMaximumPoolSize() + ") is less than the moveThreadCount (" + this.moveThreadCount + "), this is unsupported.");
        }
        return threadPoolExecutor;
    }

    @Override
    public void decideNextStep(LocalSearchStepScope<Solution_> stepScope) {
        int stepIndex = stepScope.getStepIndex();
        this.resultQueue.startNextStep(stepIndex);
        int selectingMoveIndex = 0;
        int foragingMoveIndex = 0;
        Iterator moveIterator = this.moveSelector.iterator();
        do {
            boolean moveIteratorEmpty;
            boolean bl = moveIteratorEmpty = !moveIterator.hasNext();
            if (selectingMoveIndex >= this.selectedMoveBufferSize || moveIteratorEmpty) {
                if (this.forageResult(stepScope, stepIndex)) break;
                ++foragingMoveIndex;
            }
            if (moveIteratorEmpty) continue;
            Move selectingMove = (Move)moveIterator.next();
            this.operationQueue.add(new MoveEvaluationOperation(stepIndex, selectingMoveIndex, selectingMove));
            ++selectingMoveIndex;
        } while (foragingMoveIndex < selectingMoveIndex);
        this.operationQueue.clear();
        this.pickMove(stepScope);
        if (stepScope.getStep() != null) {
            InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
            if (scoreDirector.requiresFlushing() && stepIndex % 100 == 99) {
                scoreDirector.calculateScore();
            }
            ApplyStepOperation stepOperation = new ApplyStepOperation(stepIndex + 1, stepScope.getStep(), stepScope.getScore());
            for (int i = 0; i < this.moveThreadCount; ++i) {
                this.operationQueue.add(stepOperation);
            }
        }
    }

    private boolean forageResult(LocalSearchStepScope<Solution_> stepScope, int stepIndex) {
        OrderByMoveIndexBlockingQueue.MoveResult<Solution_> result;
        try {
            result = this.resultQueue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
        if (stepIndex != result.getStepIndex()) {
            throw new IllegalStateException("Impossible situation: the solverThread's stepIndex (" + stepIndex + ") differs from the result's stepIndex (" + result.getStepIndex() + ").");
        }
        Move<Solution_> foragingMove = result.getMove().rebase(stepScope.getScoreDirector());
        int foragingMoveIndex = result.getMoveIndex();
        LocalSearchMoveScope<Solution_> moveScope = new LocalSearchMoveScope<Solution_>(stepScope, foragingMoveIndex, foragingMove);
        if (!result.isMoveDoable()) {
            this.logger.trace("{}        Move index ({}) not doable, ignoring move ({}).", new Object[]{this.logIndentation, foragingMoveIndex, foragingMove});
        } else {
            moveScope.setScore(result.getScore());
            boolean accepted = this.acceptor.isAccepted(moveScope);
            moveScope.setAccepted(accepted);
            this.logger.trace("{}        Move index ({}), score ({}), accepted ({}), move ({}).", new Object[]{this.logIndentation, foragingMoveIndex, moveScope.getScore(), moveScope.getAccepted(), foragingMove});
            this.forager.addMove(moveScope);
            if (this.forager.isQuitEarly()) {
                return true;
            }
        }
        stepScope.getPhaseScope().getSolverScope().checkYielding();
        return this.termination.isPhaseTerminated(stepScope.getPhaseScope());
    }

    private void shutdownMoveThreads() {
        if (this.executor != null && !this.executor.isShutdown()) {
            ThreadUtils.shutdownAwaitOrKill(this.executor, this.logIndentation, "Multi-threaded Local Search");
        }
    }
}

