/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.spot;

import java.util.List;
import java.util.Optional;
import javax.persistence.EntityNotFoundException;
import javax.validation.Validator;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.spot.view.SpotView;
import org.optaweb.employeerostering.service.common.AbstractRestService;
import org.optaweb.employeerostering.service.spot.SpotRepository;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SpotService
extends AbstractRestService {
    private final SpotRepository spotRepository;

    public SpotService(Validator validator, SpotRepository spotRepository) {
        super(validator);
        this.spotRepository = spotRepository;
    }

    public Spot convertFromView(Integer tenantId, SpotView spotView) {
        Spot spot = new Spot(spotView.getTenantId(), spotView.getName(), spotView.getRequiredSkillSet());
        spot.setId(spotView.getId());
        spot.setVersion(spotView.getVersion());
        this.validateBean(tenantId, (AbstractPersistable)spot);
        return spot;
    }

    @Transactional
    public List<Spot> getSpotList(Integer tenantId) {
        return this.spotRepository.findAllByTenantId(tenantId, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
    }

    @Transactional
    public Spot getSpot(Integer tenantId, Long id) {
        Spot spot = (Spot)this.spotRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("No Spot entity found with ID (" + id + ")."));
        this.validateBean(tenantId, (AbstractPersistable)spot);
        return spot;
    }

    @Transactional
    public Boolean deleteSpot(Integer tenantId, Long id) {
        Optional spotOptional = this.spotRepository.findById((Object)id);
        if (!spotOptional.isPresent()) {
            return false;
        }
        this.validateBean(tenantId, (AbstractPersistable)spotOptional.get());
        this.spotRepository.deleteById((Object)id);
        return true;
    }

    @Transactional
    public Spot createSpot(Integer tenantId, SpotView spotView) {
        Spot spot = this.convertFromView(tenantId, spotView);
        return (Spot)this.spotRepository.save((Object)spot);
    }

    @Transactional
    public Spot updateSpot(Integer tenantId, SpotView spotView) {
        Spot newSpot = this.convertFromView(tenantId, spotView);
        Spot oldSpot = (Spot)this.spotRepository.findById((Object)newSpot.getId()).orElseThrow(() -> new EntityNotFoundException("Spot entity with ID (" + newSpot.getId() + ") not found."));
        if (!oldSpot.getTenantId().equals(newSpot.getTenantId())) {
            throw new IllegalStateException("Spot entity with tenantId (" + oldSpot.getTenantId() + ") cannot change tenants.");
        }
        oldSpot.setName(newSpot.getName());
        oldSpot.setRequiredSkillSet(newSpot.getRequiredSkillSet());
        return (Spot)this.spotRepository.save((Object)oldSpot);
    }
}

