/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.roster;

public class Pagination {
    private final Integer pageNumber;
    private final Integer numberOfItemsPerPage;

    public static Pagination of(Integer pageNumber, Integer numberOfItemsPerPage) {
        if (pageNumber == null) {
            if (numberOfItemsPerPage == null) {
                return new Pagination(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            }
            throw new IllegalStateException("When pageNumber (" + pageNumber + ") is null, then numberOfItemsPerPage (" + numberOfItemsPerPage + ") must be null too.");
        }
        if (numberOfItemsPerPage == null) {
            throw new IllegalStateException("When numberOfItemsPerPage (" + numberOfItemsPerPage + ") is null, then pageNumber (" + pageNumber + ") must be null too.");
        }
        return new Pagination(pageNumber, numberOfItemsPerPage);
    }

    private Pagination(Integer pageNumber, Integer numberOfItemsPerPage) {
        this.pageNumber = pageNumber;
        this.numberOfItemsPerPage = numberOfItemsPerPage;
    }

    public Integer getNumberOfItemsPerPage() {
        return this.numberOfItemsPerPage;
    }

    public Integer getFirstResultIndex() {
        return this.pageNumber * this.numberOfItemsPerPage;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Pagination nextPage() {
        return new Pagination(Integer.valueOf(this.pageNumber + 1), this.numberOfItemsPerPage);
    }

    public Pagination previousPage() {
        return new Pagination(Integer.valueOf(Math.max(0, this.pageNumber - 1)), this.numberOfItemsPerPage);
    }

    public Pagination withNumberOfItemsPerPage(Integer numberOfItemsPerPage) {
        return new Pagination(this.pageNumber, numberOfItemsPerPage);
    }

    public boolean isOnFirstPage() {
        return this.pageNumber == 0;
    }
}

