/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.shift;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import javax.validation.Validator;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.shift.view.ShiftView;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.service.common.AbstractRestService;
import org.optaweb.employeerostering.service.common.IndictmentUtils;
import org.optaweb.employeerostering.service.employee.EmployeeRepository;
import org.optaweb.employeerostering.service.roster.RosterService;
import org.optaweb.employeerostering.service.shift.ShiftRepository;
import org.optaweb.employeerostering.service.skill.SkillService;
import org.optaweb.employeerostering.service.spot.SpotRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShiftService
extends AbstractRestService {
    private ShiftRepository shiftRepository;
    private SpotRepository spotRepository;
    private SkillService skillService;
    private EmployeeRepository employeeRepository;
    private RosterService rosterService;
    private IndictmentUtils indictmentUtils;

    public ShiftService(Validator validator, ShiftRepository shiftRepository, SpotRepository spotRepository, SkillService skillService, EmployeeRepository employeeRepository, RosterService rosterService, IndictmentUtils indictmentUtils) {
        super(validator);
        this.shiftRepository = shiftRepository;
        this.spotRepository = spotRepository;
        this.skillService = skillService;
        this.employeeRepository = employeeRepository;
        this.rosterService = rosterService;
        this.indictmentUtils = indictmentUtils;
    }

    public List<ShiftView> getShiftList(Integer tenantId) {
        Map indictmentMap = this.indictmentUtils.getIndictmentMapForRoster(this.rosterService.buildRoster(tenantId));
        return this.getAllShifts(tenantId).stream().map(s -> this.indictmentUtils.getShiftViewWithIndictment(this.rosterService.getRosterState(tenantId).getTimeZone(), s, (Indictment)indictmentMap.get(s))).collect(Collectors.toList());
    }

    private List<Shift> getAllShifts(Integer tenantId) {
        return this.shiftRepository.findAllByTenantId(tenantId);
    }

    @Transactional
    public ShiftView getShift(Integer tenantId, Long id) {
        Shift shift = (Shift)this.shiftRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("No Shift entity found with ID (" + id + ")."));
        this.validateBean(tenantId, (AbstractPersistable)shift);
        Indictment indictment = (Indictment)this.indictmentUtils.getIndictmentMapForRoster(this.rosterService.buildRoster(tenantId)).get(shift);
        return this.indictmentUtils.getShiftViewWithIndictment(this.rosterService.getRosterState(tenantId).getTimeZone(), shift, indictment);
    }

    private Shift convertFromView(Integer tenantId, ShiftView shiftView) {
        this.validateBean(tenantId, (AbstractPersistable)shiftView);
        Spot spot = (Spot)this.spotRepository.findById((Object)shiftView.getSpotId()).orElseThrow(() -> new EntityNotFoundException("No Spot entity found with ID (" + shiftView.getSpotId() + ")."));
        this.validateBean(tenantId, (AbstractPersistable)spot);
        Long rotationEmployeeId = shiftView.getRotationEmployeeId();
        Employee rotationEmployee = null;
        if (rotationEmployeeId != null) {
            rotationEmployee = (Employee)this.employeeRepository.findById((Object)rotationEmployeeId).orElseThrow(() -> new EntityNotFoundException("ShiftView (" + shiftView + ") has an non-existing rotationEmployeeId (" + rotationEmployeeId + ")."));
            this.validateBean(tenantId, (AbstractPersistable)rotationEmployee);
        }
        Long originalEmployeeId = shiftView.getOriginalEmployeeId();
        Employee originalEmployee = null;
        if (originalEmployeeId != null) {
            originalEmployee = (Employee)this.employeeRepository.findById((Object)originalEmployeeId).orElseThrow(() -> new EntityNotFoundException("ShiftView (" + shiftView + ") has an non-existing originalEmployeeId (" + originalEmployeeId + ")."));
            this.validateBean(tenantId, (AbstractPersistable)originalEmployee);
        }
        Set requiredSkillSet = shiftView.getRequiredSkillSetIdList().stream().map(id -> this.skillService.getSkill(tenantId, id)).collect(Collectors.toCollection(HashSet::new));
        Shift shift = new Shift(this.rosterService.getRosterState(tenantId).getTimeZone(), shiftView, spot, rotationEmployee, requiredSkillSet, originalEmployee);
        shift.setPinnedByUser(shiftView.isPinnedByUser());
        Long employeeId = shiftView.getEmployeeId();
        if (employeeId != null) {
            Employee employee = (Employee)this.employeeRepository.findById((Object)employeeId).orElseThrow(() -> new EntityNotFoundException("ShiftView (" + shiftView + ") has an non-existing employeeId (" + employeeId + ")."));
            this.validateBean(tenantId, (AbstractPersistable)employee);
            shift.setEmployee(employee);
        }
        this.validateBean(tenantId, (AbstractPersistable)shift);
        return shift;
    }

    @Transactional
    public ShiftView createShift(Integer tenantId, ShiftView shiftView) {
        Shift shift = this.convertFromView(tenantId, shiftView);
        Shift persistedShift = (Shift)this.shiftRepository.save((Object)shift);
        Indictment indictment = (Indictment)this.indictmentUtils.getIndictmentMapForRoster(this.rosterService.buildRoster(tenantId)).get(persistedShift);
        return this.indictmentUtils.getShiftViewWithIndictment(this.rosterService.getRosterState(tenantId).getTimeZone(), persistedShift, indictment);
    }

    @Transactional
    public ShiftView updateShift(Integer tenantId, ShiftView shiftView) {
        Shift newShift = this.convertFromView(tenantId, shiftView);
        Shift oldShift = (Shift)this.shiftRepository.findById((Object)newShift.getId()).orElseThrow(() -> new EntityNotFoundException("Shift entity with ID (" + newShift.getId() + ") not found."));
        if (!oldShift.getTenantId().equals(newShift.getTenantId())) {
            throw new IllegalStateException("Shift entity with tenantId (" + oldShift.getTenantId() + ") cannot change tenants.");
        }
        oldShift.setRotationEmployee(newShift.getRotationEmployee());
        oldShift.setOriginalEmployee(newShift.getOriginalEmployee());
        oldShift.setSpot(newShift.getSpot());
        oldShift.setStartDateTime(newShift.getStartDateTime());
        oldShift.setEndDateTime(newShift.getEndDateTime());
        oldShift.setPinnedByUser(newShift.isPinnedByUser());
        oldShift.setEmployee(newShift.getEmployee());
        oldShift.setRequiredSkillSet(newShift.getRequiredSkillSet());
        Shift updatedShift = (Shift)this.shiftRepository.saveAndFlush((Object)oldShift);
        Indictment indictment = (Indictment)this.indictmentUtils.getIndictmentMapForRoster(this.rosterService.buildRoster(tenantId)).get(updatedShift);
        return this.indictmentUtils.getShiftViewWithIndictment(this.rosterService.getRosterState(tenantId).getTimeZone(), updatedShift, indictment);
    }

    @Transactional
    public Boolean deleteShift(Integer tenantId, Long id) {
        Optional shiftOptional = this.shiftRepository.findById((Object)id);
        if (!shiftOptional.isPresent()) {
            return false;
        }
        this.validateBean(tenantId, (AbstractPersistable)shiftOptional.get());
        this.shiftRepository.deleteById((Object)id);
        return true;
    }
}

