/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.skill;

import java.util.List;
import java.util.Optional;
import javax.persistence.EntityNotFoundException;
import javax.validation.Validator;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.skill.view.SkillView;
import org.optaweb.employeerostering.service.common.AbstractRestService;
import org.optaweb.employeerostering.service.skill.SkillRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SkillService
extends AbstractRestService {
    private final SkillRepository skillRepository;

    public SkillService(Validator validator, SkillRepository skillRepository) {
        super(validator);
        this.skillRepository = skillRepository;
    }

    public Skill convertFromView(Integer tenantId, SkillView skillView) {
        Skill skill = new Skill(skillView.getTenantId(), skillView.getName());
        skill.setId(skillView.getId());
        skill.setVersion(skillView.getVersion());
        this.validateBean(tenantId, (AbstractPersistable)skill);
        return skill;
    }

    @Transactional
    public List<Skill> getSkillList(Integer tenantId) {
        return this.skillRepository.findAllByTenantId(tenantId);
    }

    @Transactional
    public Skill getSkill(Integer tenantId, Long id) {
        Skill skill = (Skill)this.skillRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("No Skill entity found with ID (" + id + ")."));
        this.validateBean(tenantId, (AbstractPersistable)skill);
        return skill;
    }

    @Transactional
    public Boolean deleteSkill(Integer tenantId, Long id) {
        Optional skillOptional = this.skillRepository.findById((Object)id);
        if (!skillOptional.isPresent()) {
            return false;
        }
        this.validateBean(tenantId, (AbstractPersistable)skillOptional.get());
        this.skillRepository.deleteById((Object)id);
        return true;
    }

    @Transactional
    public Skill createSkill(Integer tenantId, SkillView skillView) {
        Skill skill = this.convertFromView(tenantId, skillView);
        return (Skill)this.skillRepository.save((Object)skill);
    }

    @Transactional
    public Skill updateSkill(Integer tenantId, SkillView skillView) {
        Skill newSkill = this.convertFromView(tenantId, skillView);
        Skill oldSkill = (Skill)this.skillRepository.findById((Object)newSkill.getId()).orElseThrow(() -> new EntityNotFoundException("Skill entity with ID (" + newSkill.getId() + ") not found."));
        if (!oldSkill.getTenantId().equals(newSkill.getTenantId())) {
            throw new IllegalStateException("Skill entity with tenantId (" + oldSkill.getTenantId() + ") cannot change tenants.");
        }
        oldSkill.setName(newSkill.getName());
        return (Skill)this.skillRepository.save((Object)oldSkill);
    }
}

