/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.employee;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailabilityState;
import org.optaweb.employeerostering.domain.employee.view.EmployeeAvailabilityView;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"tenantId", "employee_id", "startDateTime", "endDateTime"})})
public class EmployeeAvailability
extends AbstractPersistable {
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER)
    private Employee employee;
    @NotNull
    private OffsetDateTime startDateTime;
    @NotNull
    private OffsetDateTime endDateTime;
    @NotNull
    private EmployeeAvailabilityState state;

    public EmployeeAvailability() {
    }

    public EmployeeAvailability(Integer tenantId, Employee employee, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        super(tenantId);
        this.employee = employee;
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
    }

    public EmployeeAvailability(ZoneId zoneId, EmployeeAvailabilityView employeeAvailabilityView, Employee employee) {
        super(employeeAvailabilityView);
        this.employee = employee;
        this.startDateTime = OffsetDateTime.of(employeeAvailabilityView.getStartDateTime(), zoneId.getRules().getOffset(employeeAvailabilityView.getStartDateTime()));
        this.endDateTime = OffsetDateTime.of(employeeAvailabilityView.getEndDateTime(), zoneId.getRules().getOffset(employeeAvailabilityView.getEndDateTime()));
        this.state = employeeAvailabilityView.getState();
    }

    @AssertTrue
    @JsonIgnore
    public boolean isValid() {
        return this.getDuration().getSeconds() / 3600L < 28L;
    }

    @JsonIgnore
    public Duration getDuration() {
        return Duration.between(this.startDateTime, this.endDateTime);
    }

    @Override
    public String toString() {
        return this.employee + ":" + this.startDateTime + "-" + this.endDateTime;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public OffsetDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public OffsetDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public EmployeeAvailabilityState getState() {
        return this.state;
    }

    public void setState(EmployeeAvailabilityState state) {
        this.state = state;
    }

    public EmployeeAvailability inTimeZone(ZoneId zoneId) {
        return new EmployeeAvailability(zoneId, new EmployeeAvailabilityView(zoneId, this), this.getEmployee());
    }
}

