/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.roster;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityNotFoundException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transactional;
import javax.transaction.UserTransaction;
import javax.validation.Validator;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.api.solver.SolverStatus;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailability;
import org.optaweb.employeerostering.domain.employee.view.EmployeeAvailabilityView;
import org.optaweb.employeerostering.domain.roster.Pagination;
import org.optaweb.employeerostering.domain.roster.PublishResult;
import org.optaweb.employeerostering.domain.roster.Roster;
import org.optaweb.employeerostering.domain.roster.RosterState;
import org.optaweb.employeerostering.domain.roster.view.AvailabilityRosterView;
import org.optaweb.employeerostering.domain.roster.view.ShiftRosterView;
import org.optaweb.employeerostering.domain.rotation.TimeBucket;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.shift.view.ShiftView;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.service.common.AbstractRestService;
import org.optaweb.employeerostering.service.common.IndictmentUtils;
import org.optaweb.employeerostering.service.employee.EmployeeAvailabilityRepository;
import org.optaweb.employeerostering.service.employee.EmployeeRepository;
import org.optaweb.employeerostering.service.roster.RosterStateRepository;
import org.optaweb.employeerostering.service.rotation.TimeBucketRepository;
import org.optaweb.employeerostering.service.shift.ShiftRepository;
import org.optaweb.employeerostering.service.skill.SkillRepository;
import org.optaweb.employeerostering.service.spot.SpotRepository;
import org.optaweb.employeerostering.service.tenant.RosterConstraintConfigurationRepository;

@ApplicationScoped
public class RosterService
extends AbstractRestService {
    private RosterStateRepository rosterStateRepository;
    private SkillRepository skillRepository;
    private SpotRepository spotRepository;
    private EmployeeRepository employeeRepository;
    private EmployeeAvailabilityRepository employeeAvailabilityRepository;
    private ShiftRepository shiftRepository;
    private RosterConstraintConfigurationRepository rosterConstraintConfigurationRepository;
    private TimeBucketRepository timeBucketRepository;
    private SolverManager<Roster, Integer> solverManager;
    private ScoreManager<Roster, HardMediumSoftLongScore> scoreManager;
    private IndictmentUtils indictmentUtils;
    private UserTransaction transaction;
    private ExecutorService rosterUpdateExecutorService = Executors.newCachedThreadPool();
    private Map<Integer, Future<?>> tenantIdToRosterUpdateFutureMap = new ConcurrentHashMap();
    private Map<Integer, Roster> tenantIdToNextRosterMap = new ConcurrentHashMap<Integer, Roster>();

    @Inject
    public RosterService(Validator validator, RosterStateRepository rosterStateRepository, SkillRepository skillRepository, SpotRepository spotRepository, EmployeeRepository employeeRepository, EmployeeAvailabilityRepository employeeAvailabilityRepository, ShiftRepository shiftRepository, RosterConstraintConfigurationRepository rosterConstraintConfigurationRepository, TimeBucketRepository timeBucketRepository, SolverManager<Roster, Integer> solverManager, ScoreManager<Roster, HardMediumSoftLongScore> scoreManager, UserTransaction transaction, IndictmentUtils indictmentUtils) {
        super(validator);
        this.rosterStateRepository = rosterStateRepository;
        this.skillRepository = skillRepository;
        this.spotRepository = spotRepository;
        this.employeeRepository = employeeRepository;
        this.employeeAvailabilityRepository = employeeAvailabilityRepository;
        this.shiftRepository = shiftRepository;
        this.rosterConstraintConfigurationRepository = rosterConstraintConfigurationRepository;
        this.timeBucketRepository = timeBucketRepository;
        this.solverManager = solverManager;
        this.scoreManager = scoreManager;
        this.indictmentUtils = indictmentUtils;
        this.transaction = transaction;
    }

    @Transactional
    public RosterState getRosterState(Integer tenantId) {
        RosterState rosterState = this.rosterStateRepository.findByTenantId(tenantId).orElseThrow(() -> new EntityNotFoundException("No RosterState entity found with tenantId (" + tenantId + ")."));
        this.validateBean(tenantId, rosterState);
        return rosterState;
    }

    @Transactional
    public ShiftRosterView getCurrentShiftRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage) {
        RosterState rosterState = this.getRosterState(tenantId);
        LocalDate startDate = rosterState.getFirstPublishedDate();
        LocalDate endDate = rosterState.getFirstUnplannedDate();
        return this.getShiftRosterView(tenantId, startDate, endDate, Pagination.of(pageNumber, numberOfItemsPerPage));
    }

    @Transactional
    public ShiftRosterView getShiftRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage, String startDateString, String endDateString) {
        return this.getShiftRosterView(tenantId, LocalDate.parse(startDateString), LocalDate.parse(endDateString), Pagination.of(pageNumber, numberOfItemsPerPage));
    }

    private ShiftRosterView getShiftRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, Pagination pagination) {
        List spots = this.spotRepository.find("tenantId", new Object[]{tenantId}).page(pagination.getPageNumber().intValue(), pagination.getNumberOfItemsPerPage().intValue()).list();
        return this.getShiftRosterView(tenantId, startDate, endDate, spots);
    }

    @Transactional
    public ShiftRosterView getShiftRosterViewFor(Integer tenantId, String startDateString, String endDateString, List<Spot> spotList) {
        LocalDate startDate = LocalDate.parse(startDateString);
        LocalDate endDate = LocalDate.parse(endDateString);
        if (spotList == null) {
            throw new IllegalArgumentException("The spotList (" + spotList + ") must not be null.");
        }
        return this.getShiftRosterView(tenantId, startDate, endDate, spotList);
    }

    private ShiftRosterView getShiftRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, List<Spot> spotList) {
        ShiftRosterView shiftRosterView = new ShiftRosterView(tenantId, startDate, endDate);
        shiftRosterView.setSpotList(spotList);
        List<Employee> employeeList = this.employeeRepository.findAllByTenantId(tenantId);
        shiftRosterView.setEmployeeList(employeeList);
        HashSet<Spot> spotSet = new HashSet<Spot>(spotList);
        ZoneId timeZone = this.getRosterState(tenantId).getTimeZone();
        List<Shift> shiftList = this.shiftRepository.filterWithSpots(tenantId, spotSet, startDate.atStartOfDay(timeZone).toOffsetDateTime(), endDate.atStartOfDay(timeZone).toOffsetDateTime());
        LinkedHashMap<Long, List<ShiftView>> spotIdToShiftViewListMap = new LinkedHashMap<Long, List<ShiftView>>(spotList.size());
        Roster roster = this.buildRoster(tenantId);
        Map<Object, Indictment<HardMediumSoftLongScore>> indictmentMap = this.indictmentUtils.getIndictmentMapForRoster(roster);
        for (Shift shift : shiftList) {
            Indictment<HardMediumSoftLongScore> indictment = indictmentMap.get(shift);
            spotIdToShiftViewListMap.computeIfAbsent(shift.getSpot().getId(), k -> new ArrayList()).add(this.indictmentUtils.getShiftViewWithIndictment(timeZone, shift, indictment));
        }
        shiftRosterView.setSpotIdToShiftViewListMap(spotIdToShiftViewListMap);
        shiftRosterView.setScore(roster == null ? null : roster.getScore());
        shiftRosterView.setRosterState(this.getRosterState(tenantId));
        shiftRosterView.setIndictmentSummary(this.indictmentUtils.getIndictmentSummaryForRoster(roster));
        return shiftRosterView;
    }

    @Transactional
    public AvailabilityRosterView getCurrentAvailabilityRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage) {
        RosterState rosterState = this.getRosterState(tenantId);
        LocalDate startDate = rosterState.getLastHistoricDate();
        LocalDate endDate = rosterState.getFirstUnplannedDate();
        return this.getAvailabilityRosterView(tenantId, startDate, endDate, Pagination.of(pageNumber, numberOfItemsPerPage));
    }

    @Transactional
    public AvailabilityRosterView getAvailabilityRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage, String startDateString, String endDateString) {
        LocalDate startDate = LocalDate.parse(startDateString);
        LocalDate endDate = LocalDate.parse(endDateString);
        return this.getAvailabilityRosterView(tenantId, startDate, endDate, Pagination.of(pageNumber, numberOfItemsPerPage));
    }

    @Transactional
    public AvailabilityRosterView getAvailabilityRosterViewFor(Integer tenantId, String startDateString, String endDateString, List<Employee> employeeList) {
        LocalDate startDate = LocalDate.parse(startDateString);
        LocalDate endDate = LocalDate.parse(endDateString);
        if (employeeList == null) {
            throw new IllegalArgumentException("The employeeList (" + employeeList + ") must not be null.");
        }
        return this.getAvailabilityRosterView(tenantId, startDate, endDate, employeeList);
    }

    private AvailabilityRosterView getAvailabilityRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, Pagination pagination) {
        List employeeList = this.employeeRepository.find("tenantId", new Object[]{tenantId}).page(pagination.getPageNumber().intValue(), pagination.getNumberOfItemsPerPage().intValue()).list();
        return this.getAvailabilityRosterView(tenantId, startDate, endDate, employeeList);
    }

    private AvailabilityRosterView getAvailabilityRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, List<Employee> employeeList) {
        AvailabilityRosterView availabilityRosterView = new AvailabilityRosterView(tenantId, startDate, endDate);
        List<Spot> spotList = this.spotRepository.findAllByTenantId(tenantId);
        availabilityRosterView.setSpotList(spotList);
        availabilityRosterView.setEmployeeList(employeeList);
        LinkedHashMap<Long, List<ShiftView>> employeeIdToShiftViewListMap = new LinkedHashMap<Long, List<ShiftView>>(employeeList.size());
        ArrayList<ShiftView> unassignedShiftViewList = new ArrayList<ShiftView>();
        HashSet<Employee> employeeSet = new HashSet<Employee>(employeeList);
        ZoneId timeZone = this.getRosterState(tenantId).getTimeZone();
        List<Shift> shiftList = this.shiftRepository.filterWithEmployees(tenantId, employeeSet, startDate.atStartOfDay(timeZone).toOffsetDateTime(), endDate.atStartOfDay(timeZone).toOffsetDateTime());
        Roster roster = this.buildRoster(tenantId);
        Map<Object, Indictment<HardMediumSoftLongScore>> indictmentMap = this.indictmentUtils.getIndictmentMapForRoster(roster);
        for (Shift shift : shiftList) {
            Indictment<HardMediumSoftLongScore> indictment = indictmentMap.get(shift);
            if (shift.getEmployee() != null) {
                employeeIdToShiftViewListMap.computeIfAbsent(shift.getEmployee().getId(), k -> new ArrayList()).add(this.indictmentUtils.getShiftViewWithIndictment(timeZone, shift, indictment));
                continue;
            }
            unassignedShiftViewList.add(this.indictmentUtils.getShiftViewWithIndictment(timeZone, shift, indictment));
        }
        availabilityRosterView.setEmployeeIdToShiftViewListMap(employeeIdToShiftViewListMap);
        availabilityRosterView.setUnassignedShiftViewList(unassignedShiftViewList);
        LinkedHashMap<Long, List<EmployeeAvailabilityView>> employeeIdToAvailabilityViewListMap = new LinkedHashMap<Long, List<EmployeeAvailabilityView>>(employeeList.size());
        List<EmployeeAvailability> employeeAvailabilityList = this.employeeAvailabilityRepository.filterWithEmployee(tenantId, employeeSet, startDate.atStartOfDay(timeZone).toOffsetDateTime(), endDate.atStartOfDay(timeZone).toOffsetDateTime());
        for (EmployeeAvailability employeeAvailability : employeeAvailabilityList) {
            employeeIdToAvailabilityViewListMap.computeIfAbsent(employeeAvailability.getEmployee().getId(), k -> new ArrayList()).add(new EmployeeAvailabilityView(timeZone, employeeAvailability));
        }
        availabilityRosterView.setEmployeeIdToAvailabilityViewListMap(employeeIdToAvailabilityViewListMap);
        availabilityRosterView.setScore(roster.getScore());
        availabilityRosterView.setRosterState(this.getRosterState(tenantId));
        availabilityRosterView.setIndictmentSummary(this.indictmentUtils.getIndictmentSummaryForRoster(roster));
        return availabilityRosterView;
    }

    @Transactional
    public Roster buildRoster(Integer tenantId) {
        ZoneId zoneId = this.getRosterState(tenantId).getTimeZone();
        List<Skill> skillList = this.skillRepository.findAllByTenantId(tenantId);
        List<Spot> spotList = this.spotRepository.findAllByTenantId(tenantId);
        List<Employee> employeeList = this.employeeRepository.findAllByTenantId(tenantId);
        List<EmployeeAvailability> employeeAvailabilityList = this.employeeAvailabilityRepository.findAllByTenantId(tenantId).stream().map(ea -> ea.inTimeZone(zoneId)).collect(Collectors.toList());
        List<Shift> shiftList = this.shiftRepository.findAllByTenantId(tenantId).stream().map(s -> s.inTimeZone(zoneId)).collect(Collectors.toList());
        Roster roster = new Roster((long)tenantId, tenantId, this.rosterConstraintConfigurationRepository.findByTenantId(tenantId).orElseThrow(() -> new EntityNotFoundException("No RosterConstraintConfiguration entity found with tenantId(" + tenantId + ").")), skillList, spotList, employeeList, employeeAvailabilityList, this.getRosterState(tenantId), shiftList);
        this.scoreManager.updateScore((Object)roster);
        return roster;
    }

    @Transactional
    public void updateShiftsOfRoster(Roster newRoster) {
        Integer tenantId = newRoster.getTenantId();
        Map employeeIdMap = this.employeeRepository.findAllByTenantId(tenantId).stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        Map shiftIdMap = this.shiftRepository.findAllByTenantId(tenantId).stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        for (Shift shift : newRoster.getShiftList()) {
            Shift attachedShift = (Shift)shiftIdMap.get(shift.getId());
            if (attachedShift == null) continue;
            attachedShift.setEmployee(shift.getEmployee() == null ? null : (Employee)employeeIdMap.get(shift.getEmployee().getId()));
        }
    }

    @Transactional
    public void scheduleUpdateOfRoster(Roster newRoster) {
        this.tenantIdToRosterUpdateFutureMap.compute(newRoster.getTenantId(), (tenantId, task) -> {
            if (task != null && !task.isDone()) {
                this.tenantIdToNextRosterMap.put((Integer)tenantId, newRoster);
                return task;
            }
            this.tenantIdToNextRosterMap.remove(tenantId);
            return this.rosterUpdateExecutorService.submit(() -> {
                try {
                    this.transaction.begin();
                    this.updateShiftsOfRoster(newRoster);
                    this.transaction.commit();
                    this.tenantIdToRosterUpdateFutureMap.remove(tenantId);
                    if (this.tenantIdToNextRosterMap.containsKey(tenantId)) {
                        this.scheduleUpdateOfRoster(this.tenantIdToNextRosterMap.remove(tenantId));
                    }
                }
                catch (HeuristicMixedException | HeuristicRollbackException | NotSupportedException | RollbackException | SystemException e) {
                    throw new IllegalStateException(e);
                }
            });
        });
    }

    @Transactional
    public void solveRoster(Integer tenantId) {
        this.solverManager.solveAndListen((Object)tenantId, this::buildRoster, this::scheduleUpdateOfRoster);
    }

    @Transactional
    public void replanRoster(Integer tenantId) {
        Roster roster = this.buildRoster(tenantId);
        roster.setNondisruptivePlanning(true);
        roster.setNondisruptiveReplanFrom(OffsetDateTime.now());
        Map constraintMatchTotalMap = this.scoreManager.explainScore((Object)roster).getConstraintMatchTotalMap();
        String CONSTRAINT_ID = ConstraintMatchTotal.composeConstraintId((String)"org.optaweb.employeerostering.service.solver", (String)"Unavailable time slot for an employee");
        ((ConstraintMatchTotal)constraintMatchTotalMap.get(CONSTRAINT_ID)).getConstraintMatchSet().forEach(constraintMatch -> constraintMatch.getJustificationList().stream().filter(o -> o instanceof Shift).forEach(justification -> {
            Shift shift = (Shift)justification;
            if (!shift.isPinnedByUser()) {
                shift.setEmployee(null);
            }
        }));
        this.solverManager.solveAndListen((Object)tenantId, id -> roster, this::scheduleUpdateOfRoster);
    }

    public SolverStatus getSolverStatus(Integer tenantId) {
        return this.solverManager.getSolverStatus((Object)tenantId);
    }

    public void terminateRosterEarly(Integer tenantId) {
        this.solverManager.terminateEarly((Object)tenantId);
    }

    @Transactional
    public void provision(Integer tenantId, Integer startRotationOffset, LocalDate fromDate, LocalDate toDate, List<Long> timeBucketIdList) {
        RosterState rosterState = this.getRosterState(tenantId);
        List timeBucketList = this.timeBucketRepository.find("id in ?1", new Object[]{timeBucketIdList}).list();
        if (timeBucketList.stream().anyMatch(tb -> !tb.getTenantId().equals(tenantId))) {
            throw new IllegalArgumentException("Can only provision shifts from timebuckets from the same tenant");
        }
        if (startRotationOffset > rosterState.getRotationLength()) {
            throw new IllegalArgumentException("startRotationOffset (" + startRotationOffset + ") is greater than the rotation length (" + rosterState.getRotationLength() + ")");
        }
        if (startRotationOffset < 0) {
            throw new IllegalArgumentException("startRotationOffset (" + startRotationOffset + ") is negative");
        }
        if (toDate.isBefore(fromDate)) {
            throw new IllegalArgumentException("toDate (" + toDate.toString() + ") is before fromDate (" + fromDate.toString() + ")");
        }
        int dayOffset = startRotationOffset;
        LocalDate shiftDate = fromDate;
        while (!shiftDate.isAfter(toDate)) {
            for (TimeBucket timeBucket : timeBucketList) {
                timeBucket.createShiftForOffset(shiftDate, dayOffset, rosterState.getTimeZone(), false).ifPresent(arg_0 -> ((ShiftRepository)this.shiftRepository).persist(arg_0));
            }
            shiftDate = shiftDate.plusDays(1L);
            dayOffset = (dayOffset + 1) % rosterState.getRotationLength();
        }
    }

    @Transactional
    public PublishResult publishAndProvision(Integer tenantId) {
        RosterState rosterState = this.getRosterState(tenantId);
        LocalDate publishFrom = rosterState.getFirstDraftDate();
        LocalDate publishTo = publishFrom.plusDays(rosterState.getPublishLength().intValue());
        LocalDate firstUnplannedDate = rosterState.getFirstUnplannedDate();
        ZoneId timeZone = rosterState.getTimeZone();
        List<Shift> publishedShifts = this.shiftRepository.findAllByTenantIdBetweenDates(tenantId, publishFrom.atStartOfDay(timeZone).toOffsetDateTime(), publishTo.atStartOfDay(timeZone).toOffsetDateTime());
        publishedShifts.forEach(s -> s.setOriginalEmployee(s.getEmployee()));
        this.shiftRepository.persist(publishedShifts);
        rosterState.setFirstDraftDate(publishTo);
        this.provision(tenantId, rosterState.getUnplannedRotationOffset(), firstUnplannedDate, firstUnplannedDate.plusDays(rosterState.getPublishLength() - 1), this.timeBucketRepository.findAllByTenantId(tenantId).stream().map(AbstractPersistable::getId).collect(Collectors.toList()));
        return new PublishResult(publishFrom, publishTo);
    }

    @Transactional
    public void commitChanges(Integer tenantId) {
        RosterState rosterState = this.getRosterState(tenantId);
        LocalDate publishFrom = LocalDate.now();
        LocalDate publishTo = rosterState.getFirstDraftDate();
        ZoneId timeZone = rosterState.getTimeZone();
        List<Shift> publishedShifts = this.shiftRepository.findAllByTenantIdBetweenDates(tenantId, publishFrom.atStartOfDay(timeZone).toOffsetDateTime(), publishTo.atStartOfDay(timeZone).toOffsetDateTime());
        publishedShifts.forEach(s -> s.setOriginalEmployee(s.getEmployee()));
        this.shiftRepository.persist(publishedShifts);
    }
}

