/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime.devconsole;

import io.quarkus.arc.runtime.devconsole.Invocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Singleton;

@Singleton
public class InvocationsMonitor {
    private static final int DEFAULT_LIMIT = 1000;
    private final List<Invocation> invocations = Collections.synchronizedList(new ArrayList());
    private volatile boolean filterOutQuarkusBeans = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInvocation(Invocation invocation) {
        if (this.invocations.size() > 1000) {
            List<Invocation> list = this.invocations;
            synchronized (list) {
                if (this.invocations.size() > 1000) {
                    this.invocations.subList(0, 500).clear();
                }
            }
        }
        this.invocations.add(invocation);
    }

    public List<Invocation> getLastInvocations() {
        ArrayList<Invocation> result = new ArrayList<Invocation>(this.invocations);
        if (this.filterOutQuarkusBeans) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                Invocation invocation = (Invocation)it.next();
                if (!invocation.getInterceptedBean().getBeanClass().getName().startsWith("io.quarkus")) continue;
                it.remove();
            }
        }
        Collections.reverse(result);
        return result;
    }

    public void clear() {
        this.invocations.clear();
    }

    public boolean isFilterOutQuarkusBeans() {
        return this.filterOutQuarkusBeans;
    }

    public void toggleFilterOutQuarkusBeans() {
        this.filterOutQuarkusBeans = !this.filterOutQuarkusBeans;
    }
}

