/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.util.AsciiString;
import io.quarkus.vertx.http.runtime.HttpConfiguration;

public class ForwardingProxyOptions {
    boolean proxyAddressForwarding;
    boolean allowForwarded;
    boolean enableForwardedHost;
    boolean enableForwardedPrefix;
    AsciiString forwardedHostHeader;
    AsciiString forwardedPrefixHeader;

    public ForwardingProxyOptions(boolean proxyAddressForwarding, boolean allowForwarded, boolean enableForwardedHost, AsciiString forwardedHostHeader, boolean enableForwardedPrefix, AsciiString forwardedPrefixHeader) {
        this.proxyAddressForwarding = proxyAddressForwarding;
        this.allowForwarded = allowForwarded;
        this.enableForwardedHost = enableForwardedHost;
        this.enableForwardedPrefix = enableForwardedPrefix;
        this.forwardedHostHeader = forwardedHostHeader;
        this.forwardedPrefixHeader = forwardedPrefixHeader;
    }

    public static ForwardingProxyOptions from(HttpConfiguration httpConfiguration) {
        boolean proxyAddressForwarding = httpConfiguration.proxyAddressForwarding.orElse(httpConfiguration.proxy.proxyAddressForwarding);
        boolean allowForwarded = httpConfiguration.allowForwarded.orElse(httpConfiguration.proxy.allowForwarded);
        boolean enableForwardedHost = httpConfiguration.proxy.enableForwardedHost;
        boolean enableForwardedPrefix = httpConfiguration.proxy.enableForwardedPrefix;
        AsciiString forwardedPrefixHeader = AsciiString.cached((String)httpConfiguration.proxy.forwardedPrefixHeader);
        AsciiString forwardedHostHeader = AsciiString.cached((String)httpConfiguration.proxy.forwardedHostHeader);
        return new ForwardingProxyOptions(proxyAddressForwarding, allowForwarded, enableForwardedHost, forwardedHostHeader, enableForwardedPrefix, forwardedPrefixHeader);
    }
}

