/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.Objects;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Tuple;
import org.drools.model.Variable;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractAccumulator;

final class BiAccumulator<A, B, ResultContainer_, Result_>
extends AbstractAccumulator<ResultContainer_, Result_> {
    private final String varA;
    private final String varB;
    private final TriFunction<ResultContainer_, A, B, Runnable> accumulator;
    private Declaration declarationA;
    private Declaration declarationB;
    private int offsetToA;
    private int offsetToB;

    public BiAccumulator(Variable<A> varA, Variable<B> varB, BiConstraintCollector<A, B, ResultContainer_, Result_> collector) {
        super(collector.supplier(), collector.finisher());
        this.accumulator = Objects.requireNonNull(collector.accumulator());
        this.varA = varA.getName();
        this.varB = varB.getName();
    }

    public Object accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) {
        if (this.declarationA == null) {
            this.init(leftTuple, innerDeclarations);
        }
        Object a = BiAccumulator.extractValue(this.declarationA, this.offsetToA, leftTuple);
        Object b = BiAccumulator.extractValue(this.declarationB, this.offsetToB, leftTuple);
        return this.accumulator.apply(context, a, b);
    }

    private void init(Tuple leftTuple, Declaration[] innerDeclarations) {
        for (Declaration declaration : innerDeclarations) {
            if (declaration.getBindingName().equals(this.varA)) {
                this.declarationA = declaration;
                continue;
            }
            if (!declaration.getBindingName().equals(this.varB)) continue;
            this.declarationB = declaration;
        }
        this.offsetToA = BiAccumulator.findTupleOffset(this.declarationA, leftTuple);
        this.offsetToB = BiAccumulator.findTupleOffset(this.declarationB, leftTuple);
    }
}

