/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.KeyStoreHelper;
import java.security.KeyStore;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public abstract class KeyStoreOptionsBase
implements KeyCertOptions,
TrustOptions {
    private KeyStoreHelper helper;
    private String provider;
    private String type;
    private String password;
    private String path;
    private Buffer value;
    private String alias;

    protected KeyStoreOptionsBase() {
    }

    protected KeyStoreOptionsBase(KeyStoreOptionsBase other) {
        this.type = other.type;
        this.password = other.password;
        this.path = other.path;
        this.value = other.value;
        this.alias = other.alias;
    }

    protected String getType() {
        return this.type;
    }

    protected KeyStoreOptionsBase setType(String type) {
        this.type = type;
        return this;
    }

    protected String getProvider() {
        return this.provider;
    }

    protected KeyStoreOptionsBase setProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public KeyStoreOptionsBase setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public KeyStoreOptionsBase setPath(String path) {
        this.path = path;
        return this;
    }

    public Buffer getValue() {
        return this.value;
    }

    public KeyStoreOptionsBase setValue(Buffer value) {
        this.value = value;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public KeyStoreOptionsBase setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    KeyStoreHelper getHelper(Vertx vertx) throws Exception {
        if (this.helper == null) {
            Supplier<Buffer> value;
            if (this.path != null) {
                value = () -> vertx.fileSystem().readFileBlocking(((VertxInternal)vertx).resolveFile(this.path).getAbsolutePath());
            } else if (this.value != null) {
                value = this::getValue;
            } else {
                return null;
            }
            this.helper = new KeyStoreHelper(KeyStoreHelper.loadKeyStore(this.type, this.provider, this.password, value, this.getAlias()), this.password);
        }
        return this.helper;
    }

    public KeyStore loadKeyStore(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper.store() : null;
    }

    @Override
    public KeyManagerFactory getKeyManagerFactory(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper.getKeyMgrFactory() : null;
    }

    @Override
    public Function<String, X509KeyManager> keyManagerMapper(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper::getKeyMgr : null;
    }

    @Override
    public TrustManagerFactory getTrustManagerFactory(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper.getTrustMgrFactory((VertxInternal)vertx) : null;
    }

    @Override
    public Function<String, TrustManager[]> trustManagerMapper(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper::getTrustMgr : null;
    }

    @Override
    public abstract KeyStoreOptionsBase copy();
}

