/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.runtime;

import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.common.runtime.AbstractJpaOperations;
import io.quarkus.hibernate.orm.panache.runtime.CustomCountPanacheQuery;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.hibernate.common.runtime.PanacheJpaUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;

public class AdditionalJpaOperations {
    public static PanacheQuery<?> find(AbstractJpaOperations<?> jpaOperations, Class<?> entityClass, String query, String countQuery, Sort sort, Map<String, Object> params) {
        String findQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)query, (int)jpaOperations.paramCount(params));
        EntityManager em = jpaOperations.getEntityManager();
        Query jpaQuery = em.createQuery((String)(sort != null ? findQuery + PanacheJpaUtil.toOrderBy((Sort)sort) : findQuery));
        JpaOperations.bindParameters((Query)jpaQuery, params);
        return new CustomCountPanacheQuery(em, jpaQuery, findQuery, countQuery, params);
    }

    public static PanacheQuery<?> find(AbstractJpaOperations<?> jpaOperations, Class<?> entityClass, String query, String countQuery, Sort sort, Parameters parameters) {
        return AdditionalJpaOperations.find(jpaOperations, entityClass, query, countQuery, sort, parameters.map());
    }

    public static PanacheQuery<?> find(AbstractJpaOperations<?> jpaOperations, Class<?> entityClass, String query, String countQuery, Sort sort, Object ... params) {
        String findQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)query, (int)jpaOperations.paramCount(params));
        EntityManager em = jpaOperations.getEntityManager();
        Query jpaQuery = em.createQuery((String)(sort != null ? findQuery + PanacheJpaUtil.toOrderBy((Sort)sort) : findQuery));
        JpaOperations.bindParameters((Query)jpaQuery, (Object[])params);
        return new CustomCountPanacheQuery(em, jpaQuery, findQuery, countQuery, params);
    }

    public static long deleteAllWithCascade(AbstractJpaOperations<?> jpaOperations, Class<?> entityClass) {
        EntityManager em = jpaOperations.getEntityManager();
        if (AdditionalJpaOperations.deleteOnCascadeDetected(jpaOperations, entityClass)) {
            int count = 0;
            List objects = jpaOperations.listAll(entityClass);
            for (Object entity : objects) {
                em.remove(entity);
                ++count;
            }
            return count;
        }
        return jpaOperations.deleteAll(entityClass);
    }

    private static boolean deleteOnCascadeDetected(AbstractJpaOperations<?> jpaOperations, Class<?> entityClass) {
        EntityManager em = jpaOperations.getEntityManager();
        Metamodel metamodel = em.getMetamodel();
        EntityType entity1 = metamodel.entity(entityClass);
        Set declaredAttributes = ((EntityTypeImpl)entity1).getDeclaredAttributes();
        CascadeStyle[] propertyCascadeStyles = ((SessionImplementor)em.unwrap(SessionImplementor.class)).getEntityPersister(entityClass.getName(), null).getPropertyCascadeStyles();
        boolean doCascade = Arrays.stream(propertyCascadeStyles).anyMatch(cascadeStyle -> cascadeStyle.doCascade(CascadingActions.DELETE));
        boolean hasElementCollection = declaredAttributes.stream().filter(attribute -> attribute.getPersistentAttributeType().equals((Object)Attribute.PersistentAttributeType.ELEMENT_COLLECTION)).count() > 0L;
        return doCascade || hasElementCollection;
    }

    public static <PanacheQueryType> long deleteWithCascade(AbstractJpaOperations<PanacheQueryType> jpaOperations, Class<?> entityClass, String query, Object ... params) {
        EntityManager em = jpaOperations.getEntityManager();
        if (AdditionalJpaOperations.deleteOnCascadeDetected(jpaOperations, entityClass)) {
            int count = 0;
            List objects = jpaOperations.list(jpaOperations.find(entityClass, query, params));
            for (Object entity : objects) {
                em.remove(entity);
                ++count;
            }
            return count;
        }
        return jpaOperations.delete(entityClass, query, params);
    }

    public static <PanacheQueryType> long deleteWithCascade(AbstractJpaOperations<PanacheQueryType> jpaOperations, Class<?> entityClass, String query, Map<String, Object> params) {
        EntityManager em = jpaOperations.getEntityManager();
        if (AdditionalJpaOperations.deleteOnCascadeDetected(jpaOperations, entityClass)) {
            int count = 0;
            List objects = jpaOperations.list(jpaOperations.find(entityClass, query, params));
            for (Object entity : objects) {
                em.remove(entity);
                ++count;
            }
            return count;
        }
        return jpaOperations.delete(entityClass, query, params);
    }

    public static long deleteWithCascade(AbstractJpaOperations<?> jpaOperations, Class<?> entityClass, String query, Parameters params) {
        return AdditionalJpaOperations.deleteWithCascade(jpaOperations, entityClass, query, params.map());
    }
}

