/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import java.util.Arrays;
import java.util.function.Consumer;

final class SparseArray<H> {
    private static final Object[] EMPTY = new Object[0];
    private Object[] elements = EMPTY;

    SparseArray() {
    }

    void forEachInReverseOrder(Consumer<H> action) {
        for (int i = this.elements.length - 1; i >= 0; --i) {
            Object element = this.elements[i];
            if (element == null) continue;
            action.accept(element);
        }
    }

    void clear() {
        Arrays.fill(this.elements, null);
    }

    void put(int seq, H handler) {
        if (seq >= this.elements.length) {
            this.resizeToFit(seq);
        }
        this.elements[seq] = handler;
    }

    private void resizeToFit(int seq) {
        int existingLength = this.elements.length;
        if (existingLength != 0) {
            int targetLength = Math.max(seq + 1, existingLength * 2);
            Object[] newArray = new Object[targetLength];
            System.arraycopy(this.elements, 0, newArray, 0, existingLength);
            this.elements = newArray;
        } else {
            int targetLength = Math.max(seq + 1, 2);
            this.elements = new Object[targetLength];
        }
    }

    H remove(int handlerID) {
        if (handlerID < this.elements.length) {
            Object removed = this.elements[handlerID];
            this.elements[handlerID] = null;
            return (H)removed;
        }
        return null;
    }
}

