/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.employee;

import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.PanacheRepository;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailability;

@ApplicationScoped
public class EmployeeAvailabilityRepository
implements PanacheRepository<EmployeeAvailability> {
    public List<EmployeeAvailability> findAllByTenantId(Integer tenantId) {
        return this.find("tenantId", Sort.ascending((String[])new String[]{"employee.name", "startDateTime"}), new Object[]{tenantId}).list();
    }

    public void deleteForTenant(Integer tenantId) {
        this.delete("tenantId", new Object[]{tenantId});
    }

    public List<EmployeeAvailability> filterWithEmployee(Integer tenantId, Set<Employee> employeeSet, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        if (employeeSet.isEmpty()) {
            return Collections.emptyList();
        }
        return this.find("tenantId = ?1 and employee in ?2 and endDateTime >= ?3 and startDateTime < ?4", Sort.ascending((String[])new String[]{"employee.name", "startDateTime"}), new Object[]{tenantId, employeeSet, startDateTime, endDateTime}).list();
    }

    public long count() {
        return JpaOperations.INSTANCE.count(EmployeeAvailability.class);
    }

    public long count(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.count(EmployeeAvailability.class, string, objectArray);
    }

    public long count(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.count(EmployeeAvailability.class, string, parameters);
    }

    public long count(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.count(EmployeeAvailability.class, string, map);
    }

    public long delete(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.delete(EmployeeAvailability.class, string, objectArray);
    }

    public long delete(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.delete(EmployeeAvailability.class, string, parameters);
    }

    public long delete(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.delete(EmployeeAvailability.class, string, map);
    }

    public long deleteAll() {
        return JpaOperations.INSTANCE.deleteAll(EmployeeAvailability.class);
    }

    public boolean deleteById(Long l) {
        return JpaOperations.INSTANCE.deleteById(EmployeeAvailability.class, (Object)l);
    }

    public PanacheQuery<EmployeeAvailability> find(String string, Object[] objectArray) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(EmployeeAvailability.class, string, objectArray);
    }

    public PanacheQuery<EmployeeAvailability> find(String string, Parameters parameters) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(EmployeeAvailability.class, string, parameters);
    }

    public PanacheQuery<EmployeeAvailability> find(String string, Sort sort, Object[] objectArray) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(EmployeeAvailability.class, string, sort, objectArray);
    }

    public PanacheQuery<EmployeeAvailability> find(String string, Sort sort, Parameters parameters) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(EmployeeAvailability.class, string, sort, parameters);
    }

    public PanacheQuery<EmployeeAvailability> find(String string, Sort sort, Map<String, Object> map) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(EmployeeAvailability.class, string, sort, map);
    }

    public PanacheQuery<EmployeeAvailability> find(String string, Map<String, Object> map) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(EmployeeAvailability.class, string, map);
    }

    public PanacheQuery<EmployeeAvailability> findAll() {
        return (PanacheQuery)JpaOperations.INSTANCE.findAll(EmployeeAvailability.class);
    }

    public PanacheQuery<EmployeeAvailability> findAll(Sort sort) {
        return (PanacheQuery)JpaOperations.INSTANCE.findAll(EmployeeAvailability.class, sort);
    }

    public EmployeeAvailability findById(Long l) {
        return (EmployeeAvailability)JpaOperations.INSTANCE.findById(EmployeeAvailability.class, (Object)l);
    }

    public EmployeeAvailability findById(Long l, LockModeType lockModeType) {
        return (EmployeeAvailability)JpaOperations.INSTANCE.findById(EmployeeAvailability.class, (Object)l, lockModeType);
    }

    public Optional<EmployeeAvailability> findByIdOptional(Long l) {
        return JpaOperations.INSTANCE.findByIdOptional(EmployeeAvailability.class, (Object)l);
    }

    public Optional<EmployeeAvailability> findByIdOptional(Long l, LockModeType lockModeType) {
        return JpaOperations.INSTANCE.findByIdOptional(EmployeeAvailability.class, (Object)l, lockModeType);
    }

    public EntityManager getEntityManager() {
        return JpaOperations.INSTANCE.getEntityManager(EmployeeAvailability.class);
    }

    public EntityManager getEntityManager(Class<?> clazz) {
        return JpaOperations.INSTANCE.getEntityManager(EmployeeAvailability.class, clazz);
    }

    public List<EmployeeAvailability> list(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.list(EmployeeAvailability.class, string, objectArray);
    }

    public List<EmployeeAvailability> list(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.list(EmployeeAvailability.class, string, parameters);
    }

    public List<EmployeeAvailability> list(String string, Sort sort, Object[] objectArray) {
        return JpaOperations.INSTANCE.list(EmployeeAvailability.class, string, sort, objectArray);
    }

    public List<EmployeeAvailability> list(String string, Sort sort, Parameters parameters) {
        return JpaOperations.INSTANCE.list(EmployeeAvailability.class, string, sort, parameters);
    }

    public List<EmployeeAvailability> list(String string, Sort sort, Map<String, Object> map) {
        return JpaOperations.INSTANCE.list(EmployeeAvailability.class, string, sort, map);
    }

    public List<EmployeeAvailability> list(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.list(EmployeeAvailability.class, string, map);
    }

    public List<EmployeeAvailability> listAll() {
        return JpaOperations.INSTANCE.listAll(EmployeeAvailability.class);
    }

    public List<EmployeeAvailability> listAll(Sort sort) {
        return JpaOperations.INSTANCE.listAll(EmployeeAvailability.class, sort);
    }

    public Stream<EmployeeAvailability> stream(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.stream(EmployeeAvailability.class, string, objectArray);
    }

    public Stream<EmployeeAvailability> stream(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.stream(EmployeeAvailability.class, string, parameters);
    }

    public Stream<EmployeeAvailability> stream(String string, Sort sort, Object[] objectArray) {
        return JpaOperations.INSTANCE.stream(EmployeeAvailability.class, string, sort, objectArray);
    }

    public Stream<EmployeeAvailability> stream(String string, Sort sort, Parameters parameters) {
        return JpaOperations.INSTANCE.stream(EmployeeAvailability.class, string, sort, parameters);
    }

    public Stream<EmployeeAvailability> stream(String string, Sort sort, Map<String, Object> map) {
        return JpaOperations.INSTANCE.stream(EmployeeAvailability.class, string, sort, map);
    }

    public Stream<EmployeeAvailability> stream(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.stream(EmployeeAvailability.class, string, map);
    }

    public Stream<EmployeeAvailability> streamAll() {
        return JpaOperations.INSTANCE.streamAll(EmployeeAvailability.class);
    }

    public Stream<EmployeeAvailability> streamAll(Sort sort) {
        return JpaOperations.INSTANCE.streamAll(EmployeeAvailability.class, sort);
    }

    public int update(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.update(EmployeeAvailability.class, string, objectArray);
    }

    public int update(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.update(EmployeeAvailability.class, string, parameters);
    }

    public int update(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.update(EmployeeAvailability.class, string, map);
    }
}

