/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.employee;

import java.io.IOException;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.optaweb.employeerostering.domain.common.MultipartBody;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.view.EmployeeAvailabilityView;
import org.optaweb.employeerostering.domain.employee.view.EmployeeView;
import org.optaweb.employeerostering.service.employee.EmployeeService;

@Path(value="/rest/tenant/{tenantId}/employee")
@Tag(name="Employee")
@ApplicationScoped
public class EmployeeController {
    private final EmployeeService employeeService;

    public EmployeeController() {
    }

    @Inject
    public EmployeeController(EmployeeService employeeService) {
        this.employeeService = employeeService;
    }

    @GET
    @Path(value="/")
    @Operation(summary="List Employees", description="Get a list of all employees")
    public List<Employee> getEmployeeList(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return this.employeeService.getEmployeeList(tenantId);
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get Employee", description="Get an employee by id")
    public Employee getEmployee(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @PathParam(value="id") @Min(value=0L) @Min(value=0L) Long id) {
        return this.employeeService.getEmployee(tenantId, id);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(summary="Delete Employee", description="Delete an employee by id")
    public Boolean deleteEmployee(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @PathParam(value="id") @Min(value=0L) @Min(value=0L) Long id) {
        return this.employeeService.deleteEmployee(tenantId, id);
    }

    @POST
    @Path(value="/add")
    @Operation(summary="Add Employee", description="Add a new employee")
    public Employee createEmployee(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @Valid EmployeeView employeeView) {
        return this.employeeService.createEmployee(tenantId, employeeView);
    }

    @POST
    @Path(value="/import")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Operation(summary="Import Employees", description="Import employees from an Excel file")
    public List<Employee> addEmployeesFromExcelFile(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @MultipartForm MultipartBody excelDataFile) throws IOException {
        return this.employeeService.importEmployeesFromExcel(tenantId, excelDataFile.file);
    }

    @POST
    @Path(value="/update")
    @Operation(summary="Update Employee", description="Updates an employee")
    public Employee updateEmployee(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @Valid EmployeeView employeeView) {
        return this.employeeService.updateEmployee(tenantId, employeeView);
    }

    @GET
    @Path(value="/availability/{id}")
    @Operation(summary="Get Employee Availability", description="Get an employee availability by id")
    public EmployeeAvailabilityView getEmployeeAvailability(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @PathParam(value="id") @Min(value=0L) @Min(value=0L) Long id) {
        return this.employeeService.getEmployeeAvailability(tenantId, id);
    }

    @POST
    @Path(value="/availability/add")
    @Operation(summary="Add Employee Availability", description="Add a new employee availability")
    public EmployeeAvailabilityView createEmployeeAvailability(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @Valid EmployeeAvailabilityView employeeAvailabilityView) {
        return this.employeeService.createEmployeeAvailability(tenantId, employeeAvailabilityView);
    }

    @PUT
    @Path(value="/availability/update")
    @Operation(summary="Update Employee Availability", description="Updates an employee availability")
    public EmployeeAvailabilityView updateEmployeeAvailability(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @Valid EmployeeAvailabilityView employeeAvailabilityView) {
        return this.employeeService.updateEmployeeAvailability(tenantId, employeeAvailabilityView);
    }

    @DELETE
    @Path(value="/availability/{id}")
    @Operation(summary="Delete Employee Availability", description="Deletes an employee availability")
    public Boolean deleteEmployeeAvailability(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @PathParam(value="id") @Min(value=0L) @Min(value=0L) Long id) {
        return this.employeeService.deleteEmployeeAvailability(tenantId, id);
    }
}

